/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterGitService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class JupyterGitController
extends DIPInternalControllerBase {
    @Autowired
    private IJupyterService service;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private JupyterGitService jupyterGitService;
    static Logger logger = Logger.getLogger((String)"dku.jupyter.git");

    @AuditedCall(value={"msgType", "list-remote-notebooks", "repository", "${repository}", "ref", "${ref}"})
    @RequestMapping(value={"/api/jupyter/git/list-remote-notebooks"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<List<JupyterGitService.NotebookImportGitDTO>> listNotebooks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String repository, @RequestParam(required=false) String login, @RequestParam(required=false) String password, @RequestParam(required=false) String ref) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.jupyterGitService.listNotebooksFromGitAsync(user, repository, login, password, ref);
    }

    @AuditedCall(value={"msgType", "import-remote-notebooks"})
    @RequestMapping(value={"/api/jupyter/git/import-remote-notebooks"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<Void> importRemoteNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String repository, @RequestParam(required=false) String login, @RequestParam(required=false) String password, @RequestParam(required=false) String ref, @RequestParam List<JupyterGitService.NotebookImportGitDTO> notebooks) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        user.failIfNoSafeCode("Import a Jupyter notebook from git");
        return this.jupyterGitService.importNotebooksAsync(user, projectKey, repository, login, password, ref, notebooks);
    }

    @AuditedCall(value={"msgType", "get-conflicting-notebooks"})
    @RequestMapping(value={"/api/jupyter/git/get-conflicting-notebooks"}, method={RequestMethod.GET})
    @ResponseBody
    public FutureResponse<JupyterGitService.NotebooksPushGitDTO> getConflictingNotebooks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam List<String> notebooks, @RequestParam(required=false, defaultValue="false") boolean checkPull) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user.failIfNoSafeCode("Import a Jupyter notebook from git");
        }
        return this.jupyterGitService.checkConflictsAsync(user, projectKey, notebooks, checkPull);
    }

    @AuditedCall(value={"msgType", "push-remote-notebooks"})
    @RequestMapping(value={"/api/jupyter/git/push-remote-notebooks"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> pushRemoteNotebooks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam List<JupyterGitService.NotebookNameWithRemoteHashFromConflictDTO> notebooksWithHash, @RequestParam String message) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        user.failIfNoSafeCode("Import a Jupyter notebook from git");
        return this.jupyterGitService.pushNotebooksAsync(user, projectKey, notebooksWithHash, message);
    }

    @AuditedCall(value={"msgType", "push-pull-notebooks"})
    @RequestMapping(value={"/api/jupyter/git/pull-remote-notebooks"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> pullRemoteNotebooks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam List<String> notebooks) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        user.failIfNoSafeCode("Import a Jupyter notebook from git");
        return this.jupyterGitService.pullNotebooksAsync(user, projectKey, notebooks);
    }

    @AuditedCall(value={"msgType", "edit-metadata-notebooks"})
    @RequestMapping(value={"/api/jupyter/git/edit-reference"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void editNotebookReference(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String notebook, @RequestParam GitModel.GitReference reference) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        user.failIfNoSafeCode("Edit notebook git metadata");
        this.jupyterGitService.editGitNotebookReference(user, projectKey, notebook, reference);
    }

    @AuditedCall(value={"msgType", "unlink-metadata-notebooks"})
    @RequestMapping(value={"/api/jupyter/git/unlink-reference"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void unlinkNotebookReference(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String notebook) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        user.failIfNoSafeCode("Edit notebook git metadata");
        this.jupyterGitService.unlinkGitNotebookReference(user, projectKey, notebook);
    }
}

