/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.codestudio.runtime.CodeStudioSyncZones;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class UserContentsEditionController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private FolderEditorService folderEditorService;
    private TransactionProvider libUserDataTransactionProvider;
    private static final Logger logger = Logger.getLogger((String)"dku.user.editfolder");

    @PostConstruct
    public void setupGit() throws IOException {
        logger.debug((Object)"Init userdataedit service");
        File libUserData = ApplicationConfigurator.getFile((String[])new String[]{"lib", "user-data"});
        DKUFileUtils.mkdirs((File)libUserData);
        this.libUserDataTransactionProvider = new TransactionProvider(libUserData, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, false, true));
        logger.debug((Object)"Done init userdataedit service");
    }

    private AuthCtx getAndCheckUser(HttpServletRequest req) throws IOException, DKUSecurityException {
        AuthCtx user = this.authService.getMandatoryUser(req);
        return user;
    }

    private AuthCtx getAndCheckUserNoXSRF(HttpServletRequest req) throws IOException, DKUSecurityException {
        AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
        return user;
    }

    private Transaction beginZoneRead(CodeStudioSyncZones.SyncZone syncZone) {
        if (syncZone instanceof CodeStudioSyncZones.UserVersionedZone) {
            return this.transactionService.beginRead();
        }
        if (syncZone instanceof CodeStudioSyncZones.UserResourcesZone) {
            return this.libUserDataTransactionProvider.beginRead();
        }
        throw new IllegalArgumentException("Unexpected file zone " + syncZone.codeStudioName());
    }

    private RWTransaction beginZoneWrite(AuthCtx authCtx, CodeStudioSyncZones.SyncZone syncZone) {
        if (syncZone instanceof CodeStudioSyncZones.UserVersionedZone) {
            return this.transactionService.beginWriteAsLoggedInUser(authCtx);
        }
        if (syncZone instanceof CodeStudioSyncZones.UserResourcesZone) {
            return this.libUserDataTransactionProvider.beginWrite(authCtx);
        }
        throw new IllegalArgumentException("Unexpected file zone " + syncZone.codeStudioName());
    }

    @AuditedCall(value={"msgType", "user-folder-edit-list", "folderType", "${type}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/list-contents"})
    @ResponseBody
    public List<FolderEditorService.FolderContent> listContents(HttpServletRequest req, @RequestParam String type) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneRead(syncZone);
        try {
            List<FolderEditorService.FolderContent> list = this.folderEditorService.getFolderContent(syncZone.rootRelFile(authCtx, null), (TransactionRef)t);
            return list;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-get", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/get-content"})
    @ResponseBody
    public FolderEditorService.FolderContent getContent(HttpServletRequest req, @RequestParam String type, @RequestParam String path, @RequestParam boolean sendAnyway) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneRead(syncZone);
        try {
            FolderEditorService.FolderContent folderContent = this.folderEditorService.getFolderContent(syncZone.rootRelFile(authCtx, null), path, sendAnyway, null, t);
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-preview-image", "path", "${path}", "contentType", "${contentType}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/preview-image"}, method={RequestMethod.GET})
    public void previewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam String contentType) throws Exception {
        byte[] picData;
        AuthCtx authCtx;
        MimeTypesSecurity.failIfNotSafeImageType((String)contentType);
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUserNoXSRF(req);
        }
        try (Transaction t = this.beginZoneRead(syncZone);){
            picData = this.folderEditorService.previewImageStream(syncZone.rootRelFile(authCtx, null), path, t);
        }
        resp.setContentType(contentType);
        resp.getOutputStream().write(picData);
    }

    @AuditedCall(value={"msgType", "user-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/set-content"})
    public void setContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam String data) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.setFolderContent(syncZone.rootRelFile(authCtx, null), path, data, (RWTransactionRef)t);
            t.commit("edit file");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-save", "folderType", "${type}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/set-content-multiple"})
    public void setContentMultiple(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String contentMap) throws Exception {
        AuthCtx authCtx;
        Map fileMap = (Map)JSON.parse((String)contentMap, (TypeToken)new TypeToken<Map<String, String>>(){});
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.setFolderContentList(syncZone.rootRelFile(authCtx, null), fileMap, (RWTransaction)t);
            t.commit("edit files");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-create", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/create-content"})
    public void createContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path, @RequestParam boolean isFolder) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.addFolderContent(syncZone.rootRelFile(authCtx, null), path, isFolder, (RWTransactionRef)t);
            t.commit("create file");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-delete", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/delete-content"})
    public void deleteContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.removeFolderContent(syncZone.rootRelFile(authCtx, null), path, (RWTransaction)t);
            t.commit("edit file/folder");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/decompress-content"})
    public void decompressContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            this.folderEditorService.decompressFolderContent(syncZone.rootRelFile(authCtx, null), path, (RWTransaction)t);
            t.commit("decompress file");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/rename-content"})
    @ResponseBody
    public FolderEditorService.FolderContent renameContent(HttpServletRequest req, @RequestParam String type, @RequestParam String path, @RequestParam String newName) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.renameFolderContent(syncZone.rootRelFile(authCtx, null), path, newName, (RWTransaction)t);
            t.commit("rename file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/move-content"})
    @ResponseBody
    public FolderEditorService.FolderContent moveContent(HttpServletRequest req, @RequestParam String type, @RequestParam String path, @RequestParam String toPath) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.moveFolderContent(syncZone.rootRelFile(authCtx, null), path, toPath, (RWTransaction)t);
            t.commit("move file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-save", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/copy-content"})
    @ResponseBody
    public FolderEditorService.FolderContent copyContent(HttpServletRequest req, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            FolderEditorService.FolderContent newContent = this.folderEditorService.copyFolderContent(syncZone.rootRelFile(authCtx, null), path, (RWTransaction)t);
            t.commit("copy file/folder");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/myprofile/folder-edition/check-upload-content"})
    @ResponseBody
    public FolderEditorService.UploadFeasabilities checkUploadContent(HttpServletRequest req, @RequestParam String type, @RequestParam String path, @RequestParam List<String> filePaths) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneRead(syncZone);
        try {
            FolderEditorService.UploadFeasabilities uploadFeasabilities = this.folderEditorService.checkUploadContent(syncZone.rootRelFile(authCtx, null), path, filePaths, t);
            return uploadFeasabilities;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-upload", "folderType", "${type}", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/upload-content"})
    @ResponseBody
    public FolderEditorService.FolderContent uploadContent(HttpServletRequest req, @RequestParam String type, @RequestParam String path, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUser(req);
        }
        t = this.beginZoneWrite(authCtx, syncZone);
        try {
            Callable<FolderEditorService.FolderContent> callableUploadHandler = this.folderEditorService.uploadContent(syncZone.rootRelFile(authCtx, null), path, filePart.getInputStream(), filePart.getOriginalFilename(), (RWTransaction)t);
            FolderEditorService.FolderContent newContent = callableUploadHandler.call();
            t.commit("upload file");
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "user-folder-edit-download", "path", "${path}"})
    @RequestMapping(value={"/api/myprofile/folder-edition/download-content"}, method={RequestMethod.GET})
    public void downloadContent(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        CodeStudioSyncZones.SyncZone syncZone = CodeStudioSyncZones.lookup(type);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.getAndCheckUserNoXSRF(req);
        }
        t = this.beginZoneRead(syncZone);
        try {
            this.folderEditorService.streamContent(syncZone.rootRelFile(authCtx, null), path, resp, t);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }
}

