/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ZonesController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ZonesDAO zonesDAO;
    static Logger logger = Logger.getLogger((String)"dku.controller.zones");

    @AuditedCall(value={"msgType", "zones-read-meta", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/api/zones/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, String projectKey, @RequestParam String zoneId) throws Exception {
        NavigatorService.ZoneFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            info = this.navigatorService.getZoneFullInfo(projectKey, zoneId);
        }
        this.navigatorService.addInfo_NT(info, u);
        ZonesController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "zones-read-meta", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/api/zones/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String zoneId) throws Exception {
        TaggableObjectsService.TaggableObject zone;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            zone = (TaggableObjectsService.TaggableObject)this.zonesDAO.getMandatoryUnsafe(projectKey, zoneId);
        }
        ZonesController.writeJSON((HttpServletResponse)resp, (Object)zone);
    }
}

