/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.labeling.LabelingInternalDBService;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LabelingIntercomPrivilegedController
extends DIPInternalControllerBase {
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private LabelingInternalDBService labelingInternalDBService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private LabelingService labelingService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PermissionsService permissionsService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/labeling/load-metadata-if-needed"})
    public void loadDataIfNeeded(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam String authCtxIdentifier) throws Exception {
        Dataset metadataDataset;
        LabelingTask labelingTask;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNoSharedSecret(req);
            labelingTask = this.labelingService.getLabelingTask(projectKey, labelingTaskId);
            metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        }
        AuthCtx counterpartAuthCtx = this.authCtxCreationService.create_autoTxn(authCtxIdentifier);
        this.labelingInternalDBService.loadMetadataToInternalDbIfNeeded(counterpartAuthCtx, labelingTask, metadataDataset);
    }
}

