/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.engine.TicketBasedLocalFolderService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.WorkloadFoldersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TicketBasedLocalFolderIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TicketAuthService ticketAuthService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TicketBasedLocalFolderService ticketFolderService;
    @Autowired
    private WorkloadFoldersService workloadsFoldersService;

    @AuditedCall(value={"msgType", "ticket-folder-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/ticket-folder/get"})
    @ResponseBody
    public FolderPath getTicketLocalFolder(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        APITicketService.Ticket ticket;
        try (Transaction t = this.transactionService.beginRead();
             APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            ticket = tu.getTicket();
            AuthCtx authCtx = ticket.getViaAuthCtx();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        String folderPath = this.ticketFolderService.getTicketFolder(ticket, projectKey);
        FolderPath sf = new FolderPath();
        sf.path = folderPath;
        return sf;
    }

    @AuditedCall(value={"msgType", "workload-folder-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/workload-folder/get"})
    @ResponseBody
    public FolderPath getWorkloadFolder(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        APITicketService.Ticket ticket;
        try (Transaction t = this.transactionService.beginRead();
             APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            ticket = tu.getTicket();
            authCtx = ticket.getViaAuthCtx();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        File folder = this.workloadsFoldersService.getOrCreateWorkloadFolder(authCtx, projectKey, ticket);
        assert (folder.isDirectory());
        return new FolderPath(folder.getAbsolutePath());
    }

    @AuditedCall(value={"msgType", "workload-folder-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/workload-folder/get-for-webapp"})
    @ResponseBody
    public FolderPath getWorkloadFolderForWebapp(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String webappId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.ticketAuthService.getMandTicketAuthCtx(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        APITicketService.LocalFolderAwareWorkload wl = new APITicketService.LocalFolderAwareWorkload(APITicketService.LocalFolderAwareWorkloadType.WEBAPP, projectKey, webappId);
        File folder = this.workloadsFoldersService.getOtherWorkloadFolder(authCtx, projectKey, wl);
        assert (folder.isDirectory());
        return new FolderPath(folder.getAbsolutePath());
    }

    @AuditedCall(value={"msgType", "workload-folder-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/workload-folder/get-for-agent"})
    @ResponseBody
    public FolderPath getWorkloadFolderForAgent(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentId, @RequestParam String versionId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.ticketAuthService.getMandTicketAuthCtx(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        APITicketService.LocalFolderAwareWorkload wl = new APITicketService.LocalFolderAwareWorkload(APITicketService.LocalFolderAwareWorkloadType.AGENT, projectKey, agentId + "-" + versionId);
        File folder = this.workloadsFoldersService.getOtherWorkloadFolder(authCtx, projectKey, wl);
        assert (folder.isDirectory());
        return new FolderPath(folder.getAbsolutePath());
    }

    @AuditedCall(value={"msgType", "workload-folder-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/workload-folder/get-for-agent-tool"})
    @ResponseBody
    public FolderPath getWorkloadFolderForAgentTool(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String agentToolId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.ticketAuthService.getMandTicketAuthCtx(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        APITicketService.LocalFolderAwareWorkload wl = new APITicketService.LocalFolderAwareWorkload(APITicketService.LocalFolderAwareWorkloadType.AGENT_TOOL, projectKey, agentToolId);
        File folder = this.workloadsFoldersService.getOtherWorkloadFolder(authCtx, projectKey, wl);
        assert (folder.isDirectory());
        return new FolderPath(folder.getAbsolutePath());
    }

    public static class FolderPath {
        public String path;

        public FolderPath() {
        }

        public FolderPath(String path) {
            this.path = path;
        }
    }
}

