/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.google.gson.JsonObject;

public class DiscussionMentionEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
WorkspaceEvent,
EnrichmentService.Enrichable,
EventWithHumanReadableString,
TaggableObjectEvent {
    public static final String NAME = "discussion-mention";
    public final String message;
    public final String author;
    public final String projectKey;
    public final String workspaceKey;
    public final ITaggingService.TaggableType objectType;
    public final String objectId;
    public final String discussionId;
    public final String mentionedUser;
    public final JsonObject details;

    public DiscussionMentionEvent(String message, String author, ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String discussionId, String mentionedUser) {
        this(message, author, objectType, projectKey, workspaceKey, objectId, discussionId, mentionedUser, new JsonObject());
    }

    public DiscussionMentionEvent(String message, String author, ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String discussionId, String mentionedUser, JsonObject details) {
        this.message = message.length() < 200 ? message : message.substring(0, 200) + "...";
        this.author = author;
        this.projectKey = projectKey;
        this.workspaceKey = workspaceKey;
        this.objectType = objectType;
        this.objectId = objectId;
        this.discussionId = discussionId;
        this.mentionedUser = mentionedUser;
        this.details = details;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.mentionedUser;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getWorkspaceKey() {
        return this.workspaceKey;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return this.objectType;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public JsonObject getDetails() {
        return this.details;
    }

    @Override
    public TaggableObjectsService.TaggableObjectRef getTaggableObjectRef() {
        return new TaggableObjectsService.TaggableObjectRef(this.projectKey, this.objectType, this.objectId, this.workspaceKey);
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        String authorDisplayName = this.details.has("authorDisplayName") ? this.details.get("authorDisplayName").getAsString() : this.author;
        String typeLabel = this.objectType.toHumanReadableString();
        String objectLabel = this.details.has("objectDisplayName") ? this.details.get("objectDisplayName").getAsString() : this.objectId;
        return String.format("%s mentioned you in a discussion on %s %s: %s", markup.user(this.author, authorDisplayName), markup.text(typeLabel), markup.dssOrWorkspaceObject(this.objectType, this.projectKey, this.objectId, this.workspaceKey, objectLabel, this.discussionId), markup.text(this.message));
    }
}

