/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.dao.FileBasedSessionsDAO2;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.UserEvent;

public class SessionExpirationEvent
extends BackendEvent
implements UserEvent,
EventWithHumanReadableString {
    public static final String NAME = "session-expiration";
    public final String user;
    public final String userDisplayName;
    public final FileBasedSessionsDAO2.ExpirationType kindOfExpiration;

    SessionExpirationEvent(String user, String userDisplayName, FileBasedSessionsDAO2.ExpirationType kindOfExpiration) {
        this.user = user;
        this.userDisplayName = userDisplayName;
        this.kindOfExpiration = kindOfExpiration;
    }

    public static SessionExpirationEvent withUsernameAndKind(String username, String displayName, FileBasedSessionsDAO2.ExpirationType kindOfExpiration) {
        return new SessionExpirationEvent(username, displayName, kindOfExpiration);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return String.format("%s just logged-out", markup.user(this.user, this.userDisplayName));
    }
}

