/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.samples;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.samples.FilesBasedSnippetsDAO;
import com.dataiku.dip.server.samples.SnippetsCRUDService;
import com.dataiku.dip.server.samples.SnippetsDAO;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SnippetsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SnippetsCRUDService snippetsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private AchievementsService achievementService;
    @Autowired
    private AuditTrailService auditTrailService;
    private static Logger logger = Logger.getLogger((String)"dku.flow.snippets");

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/snippets/get"})
    public void getSnippets(HttpServletRequest req, HttpServletResponse resp, @RequestParam String snippetType, @RequestParam String categories) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SnippetsController.writeJSON((HttpServletResponse)resp, this.snippetsService.list(snippetType, StringUtils.split((String)categories, (String)","), user));
        }
    }

    @AuditedCall(value={"msgType", "code-snippet-save"})
    @RequestMapping(value={"/api/flow/snippets/save"})
    public void saveSnippet(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam String category, @RequestParam String snippetType) throws Exception {
        SnippetsDAO.Snippet snippet = (SnippetsDAO.Snippet)JSON.parse((String)data, SnippetsDAO.Snippet.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SnippetsDAO.Permission currentUserSnippetPermission = FilesBasedSnippetsDAO.getSnippetPermissionForUser(snippet, snippetType, user);
            if (!(currentUserSnippetPermission != null && currentUserSnippetPermission.canUpdate || user.isAdmin())) {
                throw new DKUSecurityException("You must have the proper permission to save this code sample");
            }
            this.snippetsService.save(snippet, snippetType, category, user);
            t.commit("Saved snippet " + snippet.title + " (id = " + snippet.id + ")");
            this.achievementService.win(user, AchievementsService.AchievementId.CODE_SAMPLE_WIZZARD);
            this.auditTrailService.generic("snippet-save").with("snippetId", snippet.id).with("snippetType", snippetType).with("category", category).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("snippet-save", (Throwable)e).with("snippetId", snippet.id).with("snippetType", snippetType).with("category", category).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "code-snippet-delete", "snippetId", "${snippetId}", "snippetType", "${snippetType}"})
    @RequestMapping(value={"/api/flow/snippets/delete"})
    public void deleteSnippet(HttpServletRequest req, HttpServletResponse resp, @RequestParam String snippetId, @RequestParam String snippetType) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SnippetsDAO.Permission currentUserSnippetPermission = FilesBasedSnippetsDAO.getSnippetPermissionForUser(snippetId, snippetType, user);
            if (!(currentUserSnippetPermission != null && currentUserSnippetPermission.isAdmin || user.isAdmin())) {
                throw new DKUSecurityException("You must have the proper permission to delete this code sample");
            }
            this.snippetsService.delete(snippetId, snippetType);
            t.commit("Deleted snippet of id " + snippetId);
        }
    }

    @AuditedCall(value={"msgType", "get-user-snippet-permission", "snippetId", "${snippetId}", "snippetType", "${snippetType}"})
    @RequestMapping(value={"/api/flow/snippets/get-user-snippet-permission"})
    public void getUserSnippetPermission(HttpServletRequest req, HttpServletResponse resp, @RequestParam String snippetId, @RequestParam String snippetType) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SnippetsController.writeJSON((HttpServletResponse)resp, (Object)FilesBasedSnippetsDAO.getSnippetPermissionForUser(snippetId, snippetType, user));
        }
    }
}

