/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.kernel.master.postactions.PostJobActionsHandler;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.sql.queries.AbstractQueryBuilderWithWheres;
import com.dataiku.dip.sql.queries.AddColumnQueryBuilder;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.sql.queries.CreateTableQueryBuilder;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.queries.UpdateQueryBuilder;
import com.dataiku.dip.sql.queries.UpsertQueryBuilder;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReadWriteJobsInternalDB
extends ReadOnlyJobsInternalDB {
    @Autowired
    private ScenarioRunContext scenarioRunContext;
    private AtomicInteger lastMetricsSession = new AtomicInteger();
    private AtomicInteger lastChecksSession = new AtomicInteger();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.jobsdb");

    public ReadWriteJobsInternalDB() {
    }

    public ReadWriteJobsInternalDB(boolean autoserver) {
        super(autoserver);
    }

    @PostConstruct
    public void init() throws CodedSQLException {
        try {
            logger.debug((Object)"Init Jobs DB service");
            this.create();
            try (DSSDBConnection ac = this.acquireConnection();){
                try {
                    this.cleanupDanglingJobsAndScenarios(ac);
                    ac.commit();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to cleanup jobs database", (Throwable)e);
                    ac.rollback();
                    throw e;
                }
            }
            ac = this.acquireConnection();
            try {
                ExpressionBuilder lastSessionIndex = EBF.col("SESSION_INDEX").max().coalesce(0);
                SelectQueryBuilder metricsSessionQueryBuilder = new SelectQueryBuilder();
                metricsSessionQueryBuilder.from(this.resolveTable("METRICS_SESSIONS"), "METRICS_SESSIONS");
                metricsSessionQueryBuilder.select(lastSessionIndex);
                try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(metricsSessionQueryBuilder.toSQL(this.getDialect()));){
                    ps2.execute();
                    ResultSet rs2 = ps2.getResultSet();
                    this.lastMetricsSession.set(!rs2.next() ? 1 : rs2.getInt(1));
                }
                SelectQueryBuilder checksSessionQueryBuilder = new SelectQueryBuilder();
                checksSessionQueryBuilder.from(this.resolveTable("CHECKS_SESSIONS"), "METRICS_SESSIONS");
                checksSessionQueryBuilder.select(lastSessionIndex);
                try (PreparedStatement ps3 = ac.prepareNonPersistedStatement(checksSessionQueryBuilder.toSQL(this.getDialect()));){
                    ps3.execute();
                    ResultSet rs3 = ps3.getResultSet();
                    this.lastChecksSession.set(!rs3.next() ? 1 : rs3.getInt(1));
                }
            }
            finally {
                if (ac != null) {
                    ac.close();
                }
            }
            logger.debug((Object)"Done init Jobs DB service");
        }
        catch (CodedSQLException e) {
            logger.errorV((Throwable)e, "Failed to initialize internal database: %s", new Object[]{this.ref.name});
            throw e;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Failed to initialize internal database: %s", new Object[]{this.ref.name});
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to initialize internal database", (Throwable)e);
        }
    }

    @Override
    protected void initDB(int schemaVersion, DSSDBConnection conn) throws CodedSQLException {
        block119: {
            try {
                Statement st2;
                if (schemaVersion == 0) {
                    logger.info((Object)"Creating Jobs DB");
                    st2 = conn.createStatement();
                    try {
                        this.createOrUpdateJobTables(st2, false);
                        this.createScenarioTables(st2);
                        this.createOrUpdateHistorizedStuffTables(st2, false);
                        this.createMetricsTables(st2);
                        logger.info((Object)"Created jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 1) {
                    logger.info((Object)"Migrating Jobs DB from v1");
                    st2 = conn.createStatement();
                    try {
                        st2.execute("CREATE INDEX ON built_dataset_partitions (project_key, dataset_name)");
                        this.createScenarioTables(st2);
                        this.switchAllTimestampColumns(st2);
                        this.createOrUpdateJobTables(st2, true);
                        this.createOrUpdateHistorizedStuffTables(st2, true);
                        this.createMetricsTables(st2);
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 2) {
                    logger.info((Object)"Migrating Jobs DB from v2");
                    st2 = conn.createStatement();
                    try {
                        this.createScenarioTables(st2);
                        this.switchAllTimestampColumns(st2);
                        this.createOrUpdateJobTables(st2, true);
                        this.createOrUpdateHistorizedStuffTables(st2, true);
                        this.createMetricsTables(st2);
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 3) {
                    logger.info((Object)"Migrating Jobs DB from v3");
                    st2 = conn.createStatement();
                    try {
                        this.createMetricsTables(st2);
                        this.switchAllTimestampColumns(st2);
                        st2.execute("CREATE INDEX ON job (job_project_key, state)");
                        this.cleanupNullValuesInMergeKeys(st2);
                        this.updateScenarioRunsTable(st2);
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 4) {
                    logger.info((Object)"Migrating Jobs DB from v4");
                    st2 = conn.createStatement();
                    try {
                        st2.execute("CREATE INDEX ON job (job_project_key, state)");
                        this.switchAllTimestampColumns(st2);
                        this.cleanupNullValuesInMergeKeys(st2);
                        this.updateScenarioRunsTable(st2);
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 5) {
                    logger.info((Object)"Migrating Jobs DB from v5");
                    st2 = conn.createStatement();
                    try {
                        this.switchAllTimestampColumns(st2);
                        this.cleanupNullValuesInMergeKeys(st2);
                        this.updateScenarioRunsTable(st2);
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 6) {
                    logger.info((Object)"Migrating Jobs DB from v6");
                    st2 = conn.createStatement();
                    try {
                        this.switchAllTimestampColumns(st2);
                        this.updateScenarioRunsTable(st2);
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 7) {
                    logger.info((Object)"Migrating Jobs DB from v7");
                    st2 = conn.createStatement();
                    try {
                        this.switchAllTimestampColumns(st2);
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 8) {
                    logger.info((Object)"Migrating Jobs DB from v8");
                    st2 = conn.createStatement();
                    try {
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion == 9) {
                    logger.info((Object)"Migration Jobs DB from v9");
                    st2 = conn.createStatement();
                    try {
                        this.fillNullPartitionFieldOnFolderMetrics(st2);
                        this.fillNullOrEmptyInTables(st2, (List<String>)ImmutableList.of((Object)"FLOW_OBJECT_ACTION", (Object)"METRICS_LAST", (Object)"CHECKS_LAST", (Object)"FLOW_OBJECT_ACTION_HISTORY", (Object)"METRICS_SESSIONS", (Object)"CHECKS_SESSIONS"), "OBJECT_ID", "__null__");
                        this.fillNullOrEmptyInTables(st2, (List<String>)ImmutableList.of((Object)"FLOW_OBJECT_ACTION", (Object)"FLOW_OBJECT_ACTION_HISTORY"), "TYPE", "BUILT_DATASET");
                        this.fillNullOrEmptyInTables(st2, (List<String>)ImmutableList.of((Object)"METRICS_LAST", (Object)"METRICS_HISTORY"), "METRIC_ID", "__null__");
                        this.fillNullOrEmptyInTables(st2, (List<String>)ImmutableList.of((Object)"CHECKS_LAST", (Object)"CHECKS_HISTORY"), "NAME", "__null__");
                        logger.info((Object)"Updated jobs DB");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion < 11) {
                    logger.info((Object)"Migration Jobs DB to v11");
                    st2 = conn.createStatement();
                    try {
                        st2.execute("CREATE INDEX ON " + this.getQuotedFullResolvedTableName("TRIGGER_FIRES") + " (" + this.quote("SCENARIO_PROJECT_KEY") + ", " + this.quote("SCENARIO_ID") + ", " + this.quote("TRIGGER_ID") + ", " + this.quote("TRIGGER_RUN_ID") + " DESC)");
                        st2.execute("CREATE INDEX ON " + this.getQuotedFullResolvedTableName("SCENARIO_RUNS") + " (" + this.quote("SCENARIO_PROJECT_KEY") + ", " + this.quote("SCENARIO_ID") + ", " + this.quote("SCENARIO_RUN_ID") + " DESC)");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                    logger.info((Object)"Migrated Jobs DB to v11");
                }
                if (schemaVersion < 13) {
                    logger.info((Object)"Migration Jobs DB to v13");
                    st2 = conn.createStatement();
                    try {
                        st2.execute("CREATE INDEX " + this.getQuotedIndexName("scenario_runs_prj_id_begin_end_idx") + " ON " + this.getQuotedFullResolvedTableName("SCENARIO_RUNS") + " (" + this.quote("SCENARIO_PROJECT_KEY") + ", " + this.quote("SCENARIO_ID") + ", " + this.quote("TIME_START") + ", " + this.quote("TIME_END") + ")");
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion < 14) {
                    logger.info((Object)"Migration Jobs DB to v14");
                    st2 = conn.createStatement();
                    try {
                        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("JOB")).addColumns("JOB_PROJECT_KEY", "JOB_ID").execute(st2, this.getDialect());
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion < 15) {
                    logger.info((Object)"Migration Jobs DB to v15");
                    st2 = conn.createStatement();
                    try {
                        this.createDataQualityTables(st2);
                        this.addRunTypeColumns(st2);
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion < 16) {
                    logger.info((Object)"Migration Jobs DB to v16");
                    st2 = conn.createStatement();
                    try {
                        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("FLOW_OBJECT_ACTION")).addColumns("JOB_PROJECT_KEY", "TIME_START").execute(st2, this.getDialect());
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (schemaVersion >= 17) break block119;
                logger.info((Object)"Migration Jobs DB to v17");
                st2 = conn.createStatement();
                try {
                    this.updateScenarioRunsTableWithTestColumns(st2);
                }
                finally {
                    if (st2 != null) {
                        st2.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access internal database", (Throwable)e);
            }
        }
    }

    public void tryUpdateJob(String jobProjectKey, String jobId, long timeEnd, JobState finalState, int warningsCount) {
        try {
            this.updateJob(jobProjectKey, jobId, timeEnd, finalState, warningsCount);
        }
        catch (SQLException e) {
            logger.error((Object)"Failed to update job status", (Throwable)e);
        }
    }

    public void updateJob(String jobProjectKey, String jobId, long timeEnd, JobState finalState, int warningsCount) throws SQLException {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.updateJob");
             DSSDBConnection ac = this.acquireConnection();
             PreparedStatement update = ac.prepareNonPersistedStatement("UPDATE " + this.getQuotedFullResolvedTableName("JOB") + " SET " + this.quote("STABLE_STATE") + "=true, " + this.quote("STATE") + "=?, " + this.quote("TIME_END") + "=?, " + this.quote("WARNINGS_COUNT") + "=? WHERE " + this.quote("JOB_PROJECT_KEY") + "=? AND " + this.quote("JOB_ID") + "=?");){
            update.setString(1, finalState.toString());
            update.setLong(2, timeEnd);
            update.setInt(3, warningsCount);
            update.setString(4, jobProjectKey);
            update.setString(5, jobId);
            update.execute();
            ac.commit();
        }
    }

    public void registerNewJob(String jobProjectKey, String jobId, JobDef def, long timeStart) throws SQLException {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.registerNewJob");
             DSSDBConnection ac = this.acquireConnection();
             PreparedStatement insert = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("JOB")).addColumns(new SchemaColumn[][]{this.jobIdColumns, this.actionTimeColumns, this.jobInfoColumns, this.scenarioRunIdColumns, this.stepIdColumns}).toSQL(this.getDialect()));){
            insert.setString(1, jobProjectKey);
            insert.setString(2, jobId);
            ScenarioRun stepRunScenarioRun = null;
            if (def.stepRun != null && def.stepRun.scenarioRun != null) {
                stepRunScenarioRun = def.stepRun.scenarioRun;
                def.stepRun.scenarioRun = null;
            }
            insert.setString(8, JSON.json((Object)def));
            if (stepRunScenarioRun != null) {
                def.stepRun.scenarioRun = stepRunScenarioRun;
            }
            insert.setLong(3, timeStart);
            insert.setLong(4, 0L);
            insert.setBoolean(5, false);
            insert.setNull(6, 12);
            insert.setInt(7, 0);
            StepRun stepRun = this.scenarioRunContext.getStepRun();
            if (stepRun != null) {
                insert.setString(9, stepRun.getScenarioRun().getScenario().getProjectKey());
                insert.setString(10, stepRun.getScenarioRun().getScenario().getId());
                insert.setString(11, stepRun.getScenarioRun().getRunId());
                insert.setString(12, stepRun.getStep().getId());
                insert.setString(13, stepRun.getRunId());
            } else {
                insert.setNull(9, 12);
                insert.setNull(10, 12);
                insert.setNull(11, -5);
                insert.setNull(12, 12);
                insert.setNull(13, -5);
            }
            insert.execute();
            ac.commit();
        }
    }

    public void tryRegisterFlowObjectEvent(AnyLoc loc, String partition, JobContext jobContext, ScenarioRun scenarioRun, StepRun stepRun, ReportItem reportItem) {
        try {
            String jobProjectKey = jobContext == null ? null : jobContext.projectKey;
            String jobId = jobContext == null ? null : jobContext.jobId;
            String activityId = jobContext == null ? null : jobContext.activity;
            String scenarioProjectKey = scenarioRun == null ? null : scenarioRun.getScenario().getProjectKey();
            String scenarioId = scenarioRun == null ? null : scenarioRun.getScenario().getId();
            String scenarioRunIndex = scenarioRun == null ? null : scenarioRun.getRunId();
            String stepId = stepRun == null ? null : stepRun.getStep().getId();
            String stepRunIndex = stepRun == null ? null : stepRun.getRunId();
            this.registerFlowObjectEvent(loc, partition, jobProjectKey, jobId, activityId, scenarioProjectKey, scenarioId, scenarioRunIndex, stepId, stepRunIndex, reportItem);
        }
        catch (Throwable t) {
            logger.warn((Object)"Failed to register flow object event", t);
        }
    }

    public void tryUpdateFlowObjectEvent(AnyLoc loc, String partition, JobContext jobContext, ScenarioRun scenarioRun, StepRun stepRun, ReportItem reportItem) {
        try {
            String jobProjectKey = jobContext == null ? null : jobContext.projectKey;
            String jobId = jobContext == null ? null : jobContext.jobId;
            String activityId = jobContext == null ? null : jobContext.activity;
            String scenarioProjectKey = scenarioRun == null ? null : scenarioRun.getScenario().getProjectKey();
            String scenarioId = scenarioRun == null ? null : scenarioRun.getScenario().getId();
            String scenarioRunIndex = scenarioRun == null ? null : scenarioRun.getRunId();
            String stepId = stepRun == null ? null : stepRun.getStep().getId();
            String stepRunIndex = stepRun == null ? null : stepRun.getRunId();
            this.updateFlowObjectEvent(loc, partition, jobProjectKey, jobId, activityId, scenarioProjectKey, scenarioId, scenarioRunIndex, stepId, stepRunIndex, reportItem);
        }
        catch (Throwable t) {
            logger.warn((Object)"Failed to update flow object event", t);
        }
    }

    public void clearForDataset(DatasetLocUtils.DatasetLoc loc) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("FLOW_OBJECT_ACTION")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID").toSql(this.getDialect()));){
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getName(), "__null__");
                ps2.execute();
            }
            ps2 = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("FLOW_OBJECT_ACTION_HISTORY")).addColumns(this.objectIdColumns).addColumns(DELETED_SCHEMA_COLUMN).toSQL(this.getDialect()));
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getName(), "__null__");
                ps2.setBoolean(3, true);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("METRICS_LAST")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID").toSql(this.getDialect()));
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getName(), "__null__");
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_LAST")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID").toSql(this.getDialect()));
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getName(), "__null__");
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ac.commit();
        }
    }

    public void clearForDataset(DatasetLocUtils.DatasetLoc loc, String partitionId) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("FLOW_OBJECT_ACTION")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION").toSql(this.getDialect()));){
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getName(), "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 3, partitionId, "NP");
                ps2.execute();
            }
            ps2 = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("FLOW_OBJECT_ACTION_HISTORY")).addColumns(this.objectPartitionIdColumns).addColumns(DELETED_SCHEMA_COLUMN).toSQL(this.getDialect()));
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getName(), "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 3, partitionId, "NP");
                ps2.setBoolean(4, true);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("METRICS_LAST")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION").toSql(this.getDialect()));
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getName(), "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 3, partitionId, "NP");
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_LAST")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION").toSql(this.getDialect()));
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getName(), "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 3, partitionId, "NP");
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ac.commit();
        }
    }

    public void clearMetricsForDataset(AnyLoc loc) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement("DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS_LAST") + " WHERE " + this.quote("SESSION_INDEX") + " IN (SELECT " + this.quote("SESSION_INDEX") + " FROM " + this.getQuotedFullResolvedTableName("METRICS_SESSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=?)");){
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getId(), "__null__");
                ps2.execute();
            }
            ps2 = ac.prepareNonPersistedStatement("DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS_HISTORY") + " WHERE " + this.quote("SESSION_INDEX") + " IN (SELECT " + this.quote("SESSION_INDEX") + " FROM " + this.getQuotedFullResolvedTableName("METRICS_SESSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=?)");
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getId(), "__null__");
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement("DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS_SESSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=?");
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getId(), "__null__");
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ac.commit();
        }
    }

    public void clearMetricsForDataset(AnyLoc loc, String partitionId) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement("DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS_LAST") + " WHERE " + this.quote("SESSION_INDEX") + " IN (SELECT " + this.quote("SESSION_INDEX") + " FROM " + this.getQuotedFullResolvedTableName("METRICS_SESSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("PARTITION") + " = ?)");){
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getId(), "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 3, partitionId, "NP");
                ps2.execute();
            }
            ps2 = ac.prepareNonPersistedStatement("DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS_HISTORY") + " WHERE " + this.quote("SESSION_INDEX") + " IN (SELECT " + this.quote("SESSION_INDEX") + " FROM " + this.getQuotedFullResolvedTableName("METRICS_SESSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("PARTITION") + " = ?)");
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getId(), "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 3, partitionId, "NP");
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement("DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS_SESSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("PARTITION") + " = ?");
            try {
                ps2.setString(1, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getId(), "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(ps2, 3, partitionId, "NP");
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ac.commit();
        }
    }

    public void clearDataQualityForPartition(String projectKey, String datasetName, String partitionId) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_PARTITION_LAST")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION").toSql(this.getDialect()));){
                ps2.setString(1, projectKey);
                ps2.setString(2, datasetName);
                ps2.setString(3, partitionId);
                ps2.execute();
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_PARTITION_HISTORY")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.setString(2, datasetName);
                ps2.setString(3, partitionId);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_LAST")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.setString(2, datasetName);
                ps2.setString(3, partitionId);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            SelectQueryBuilder nestedSelectQueryBuilder = new SelectQueryBuilder();
            nestedSelectQueryBuilder.from(this.resolveTable("CHECKS_SESSIONS"), "sessions");
            nestedSelectQueryBuilder.select("SESSION_INDEX");
            nestedSelectQueryBuilder.where(EBF.parameterizedColumnOperation("PROJECT_KEY", QueryUtils.OperatorType.NULL_UNSAFE_EQ), EBF.parameterizedColumnOperation("OBJECT_ID", QueryUtils.OperatorType.NULL_UNSAFE_EQ), EBF.parameterizedColumnOperation("PARTITION", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            try (PreparedStatement ps3 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_HISTORY")).where(EBF.col("SESSION_INDEX").in(EBF.expr(nestedSelectQueryBuilder.toSQL(this.getDialect())))).toSql(this.getDialect()));){
                ps3.setString(1, projectKey);
                ps3.setString(2, datasetName);
                ps3.setString(3, partitionId);
                ps3.execute();
            }
            ps3 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_SESSIONS")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID", "PARTITION").toSql(this.getDialect()));
            try {
                ps3.setString(1, projectKey);
                ps3.setString(2, datasetName);
                ps3.setString(3, partitionId);
                ps3.execute();
            }
            finally {
                if (ps3 != null) {
                    ps3.close();
                }
            }
            ac.commit();
        }
    }

    public void clearDataQualityForDataset(String projectKey, String datasetName) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_PARTITION_LAST")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID").toSql(this.getDialect()));){
                ps2.setString(1, projectKey);
                ps2.setString(2, datasetName);
                ps2.execute();
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_PARTITION_HISTORY")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.setString(2, datasetName);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_LAST")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.setString(2, datasetName);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            SelectQueryBuilder nestedSelectQueryBuilder = new SelectQueryBuilder();
            nestedSelectQueryBuilder.from(this.resolveTable("CHECKS_SESSIONS"), "sessions");
            nestedSelectQueryBuilder.select("SESSION_INDEX");
            nestedSelectQueryBuilder.where(EBF.parameterizedColumnOperation("PROJECT_KEY", QueryUtils.OperatorType.NULL_UNSAFE_EQ), EBF.parameterizedColumnOperation("OBJECT_ID", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            try (PreparedStatement ps3 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_HISTORY")).where(EBF.col("SESSION_INDEX").in(EBF.expr(nestedSelectQueryBuilder.toSQL(this.getDialect())))).toSql(this.getDialect()));){
                ps3.setString(1, projectKey);
                ps3.setString(2, datasetName);
                ps3.execute();
            }
            ps3 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_SESSIONS")).withParameterizedEqualWheres("PROJECT_KEY", "OBJECT_ID").toSql(this.getDialect()));
            try {
                ps3.setString(1, projectKey);
                ps3.setString(2, datasetName);
                ps3.execute();
            }
            finally {
                if (ps3 != null) {
                    ps3.close();
                }
            }
            ac.commit();
        }
    }

    public void clearDataQualityForProject(String projectKey) throws SQLException {
        logger.debug((Object)("Clearing Data Quality DB for project " + projectKey));
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_PROJECT_LAST")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect()));){
                ps2.setString(1, projectKey);
                ps2.execute();
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_PROJECT_HISTORY")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_OBJECT_LAST")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_OBJECT_HISTORY")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_PARTITION_LAST")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("DATA_QUALITY_PARTITION_HISTORY")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_LAST")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.execute();
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            SelectQueryBuilder nestedSelectQueryBuilder = new SelectQueryBuilder();
            nestedSelectQueryBuilder.from(this.resolveTable("CHECKS_SESSIONS"), "sessions");
            nestedSelectQueryBuilder.select("SESSION_INDEX");
            nestedSelectQueryBuilder.where(EBF.parameterizedColumnOperation("PROJECT_KEY", QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            try (PreparedStatement ps3 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_HISTORY")).where(EBF.col("SESSION_INDEX").in(EBF.expr(nestedSelectQueryBuilder.toSQL(this.getDialect())))).toSql(this.getDialect()));){
                ps3.setString(1, projectKey);
                ps3.execute();
            }
            ps3 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable("CHECKS_SESSIONS")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect()));
            try {
                ps3.setString(1, projectKey);
                ps3.execute();
            }
            finally {
                if (ps3 != null) {
                    ps3.close();
                }
            }
            ac.commit();
        }
    }

    void registerScenarioRun(ScenarioRun scenarioRun) throws SQLException {
        logger.info((Object)("Insert a new scenario run for " + this.identifierFor(scenarioRun.getScenario())));
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.registerScenarioRun");
             DSSDBConnection ac = this.acquireConnection();){
            String runId = this.makeRunIdFromTimestamp();
            scenarioRun = (ScenarioRun)scenarioRun.withRunId(runId);
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("SCENARIO_RUNS")).addColumns(this.scenarioRunIdColumns).addColumns(SCENARIO_SCHEMA_COLUMN).addColumns(new SchemaColumn[][]{this.actionTimeColumns, this.triggerIdColumns, this.scenarioRunUserColumns}).addColumns(this.scenarioBundleAndTestColumns).toSQL(this.getDialect()));){
                ps2.setString(1, scenarioRun.getScenario().getProjectKey());
                ps2.setString(2, scenarioRun.getScenario().getId());
                ps2.setString(3, scenarioRun.getRunId());
                ps2.setString(4, JSON.json((Object)scenarioRun.getScenario()));
                ps2.setLong(5, scenarioRun.getStart());
                ps2.setNull(6, -5);
                if (scenarioRun.getTrigger() != null) {
                    ps2.setString(7, scenarioRun.getTrigger().getTrigger().getId());
                    ps2.setString(8, scenarioRun.getTrigger().getRunId());
                } else {
                    ps2.setNull(7, 12);
                    ps2.setNull(8, 12);
                }
                if (scenarioRun.getRunAsUser() != null) {
                    ps2.setString(9, scenarioRun.getRunAsUser().getIdentifier());
                    ps2.setString(10, JSON.json((Object)scenarioRun.getRunAsUser().getVia()));
                } else {
                    ps2.setNull(9, 12);
                    ps2.setNull(10, 12);
                }
                if (scenarioRun.bundleId != null) {
                    ps2.setString(11, scenarioRun.bundleId);
                } else {
                    ps2.setNull(11, 12);
                }
                ps2.setBoolean(12, scenarioRun.markedAsTest);
                ps2.execute();
            }
            ac.commit();
        }
    }

    void registerStepRun(StepRun stepRun) throws SQLException {
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        logger.info((Object)("Insert a new step run for " + stepRun.getStep().getId() + " in scenario run " + this.identifierFor(scenarioRun)));
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.registerStepRun");
             DSSDBConnection ac = this.acquireConnection();){
            String runId = this.makeRunIdFromTimestamp();
            stepRun = stepRun.withRunId(runId);
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("STEP_RUNS")).addColumns(new SchemaColumn[][]{this.scenarioRunIdColumns, this.stepIdColumns, this.stepInfoColumns}).addColumns(TIME_START_SCHEMA_COLUMN).toSQL(this.getDialect()));){
                ps2.setString(1, scenarioRun.getScenario().getProjectKey());
                ps2.setString(2, scenarioRun.getScenario().getId());
                ps2.setString(3, scenarioRun.getRunId());
                ps2.setString(4, stepRun.getStep().getId());
                ps2.setString(5, stepRun.getRunId());
                ps2.setString(6, JSON.json((Object)stepRun.getStep()));
                ps2.setLong(7, stepRun.getStart());
                ps2.execute();
            }
            ac.commit();
        }
    }

    public void saveTriggerFire(TriggerFire triggerFire) throws SQLException {
        logger.info((Object)("Insert a new trigger fire for " + this.identifierFor(triggerFire)));
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.saveTriggerFire");
             DSSDBConnection ac = this.acquireConnection();){
            String runId = this.makeRunIdFromTimestamp();
            triggerFire = triggerFire.withRunId(runId);
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("TRIGGER_FIRES")).addColumns(new SchemaColumn[][]{this.scenarioIdColumns, this.triggerIdColumns, this.triggerInfoColumns}).toSQL(this.getDialect()));){
                ps2.setString(1, triggerFire.getProjectKey());
                ps2.setString(2, triggerFire.getScenarioId());
                ps2.setString(3, triggerFire.getTrigger().getId());
                ps2.setString(4, triggerFire.getRunId());
                ps2.setLong(5, triggerFire.getTimestamp());
                if (triggerFire.getTriggerState() != null) {
                    ps2.setString(6, triggerFire.getTriggerState());
                } else {
                    ps2.setNull(6, 12);
                }
                ps2.setString(7, JSON.json((Object)triggerFire.getParams()));
                ps2.setBoolean(8, triggerFire.isCancelled());
                ps2.setString(9, JSON.json((Object)triggerFire.getTrigger()));
                ps2.execute();
            }
            ac.commit();
        }
        this.setCachedLastTriggerState(triggerFire.getProjectKey(), triggerFire.getScenarioId(), triggerFire.getTrigger().getId(), triggerFire.getTriggerState());
    }

    void updateScenarioRun(ScenarioRun scenarioRun) throws SQLException {
        logger.info((Object)("Update scenario run " + this.identifierFor(scenarioRun)));
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.updateScenarioRun");
             DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement("UPDATE " + this.getQuotedFullResolvedTableName("SCENARIO_RUNS") + " SET " + this.quote("TIME_END") + " = ?, " + this.quote("RESULT") + " = ?, " + this.quote("VARIABLES") + " = ?, " + this.quote("OUTCOME") + " = ?, " + this.quote("WARNINGS_COUNT") + " = ? WHERE " + this.quote("SCENARIO_PROJECT_KEY") + " = ? AND " + this.quote("SCENARIO_ID") + " = ? AND " + this.quote("SCENARIO_RUN_ID") + " = ?");){
                ps2.setString(6, scenarioRun.getScenario().getProjectKey());
                ps2.setString(7, scenarioRun.getScenario().getId());
                ps2.setString(8, scenarioRun.getRunId());
                if (scenarioRun.getEnd() > 0L) {
                    ps2.setLong(1, scenarioRun.getEnd());
                } else {
                    ps2.setNull(1, -5);
                }
                if (scenarioRun.getResult() != null) {
                    ps2.setString(2, JSON.json((Object)scenarioRun.getResult()));
                } else {
                    ps2.setNull(2, 12);
                }
                ps2.setString(3, JSON.json((Object)scenarioRun.getVariables()));
                if (scenarioRun.getResult() != null && scenarioRun.getResult().getOutcome() != null) {
                    ps2.setString(4, scenarioRun.getResult().getOutcome().toString());
                } else {
                    ps2.setNull(4, 12);
                }
                if (scenarioRun.getResult() != null && scenarioRun.getResult().getWarnings() != null) {
                    ps2.setInt(5, scenarioRun.getResult().getWarnings().totalCount);
                } else {
                    ps2.setNull(5, 4);
                }
                ps2.execute();
                logger.info((Object)("Updated " + ps2.getUpdateCount() + " rows"));
            }
            ac.commit();
        }
    }

    void updateStepRun(StepRun stepRun) throws SQLException {
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        logger.info((Object)("Update step run " + this.identifierFor(stepRun)));
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.updateStepRun");
             DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement("UPDATE " + this.getQuotedFullResolvedTableName("STEP_RUNS") + " SET " + this.quote("TIME_END") + " = ?, " + this.quote("RESULT") + " = ?, " + this.quote("OUTCOME") + " = ?, " + this.quote("WARNINGS_COUNT") + " = ? WHERE " + this.quote("SCENARIO_PROJECT_KEY") + " = ? AND " + this.quote("SCENARIO_ID") + " = ? AND " + this.quote("SCENARIO_RUN_ID") + " = ? AND " + this.quote("STEP_RUN_ID") + " = ?");){
                ps2.setString(5, scenarioRun.getScenario().getProjectKey());
                ps2.setString(6, scenarioRun.getScenario().getId());
                ps2.setString(7, scenarioRun.getRunId());
                ps2.setString(8, stepRun.getRunId());
                if (stepRun.getEnd() > 0L) {
                    ps2.setLong(1, stepRun.getEnd());
                } else {
                    ps2.setNull(1, -5);
                }
                if (stepRun.getResult() != null) {
                    ps2.setString(2, JSON.json((Object)stepRun.getResult()));
                } else {
                    ps2.setNull(2, 12);
                }
                if (stepRun.getResult() != null && stepRun.getResult().getOutcome() != null) {
                    ps2.setString(3, stepRun.getResult().getOutcome().toString());
                } else {
                    ps2.setNull(3, 12);
                }
                if (scenarioRun.getResult() != null && scenarioRun.getResult().getWarnings() != null) {
                    ps2.setInt(4, scenarioRun.getResult().getWarnings().totalCount);
                } else {
                    ps2.setNull(4, 4);
                }
                ps2.execute();
                logger.info((Object)("Updated " + ps2.getUpdateCount() + " rows"));
            }
            ac.commit();
        }
    }

    public void saveMetrics(DatasetLocUtils.DatasetLoc loc, String partitionId, long timeCompute, String hash, TreeMap<Metric, String> metricValues) throws SQLException {
        logger.debug((Object)("Saving metrics for " + loc.getFullName()));
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.saveMetrics");
             DSSDBConnection ac = this.acquireConnection();){
            Type saveDataType;
            Type metricDataType;
            String metricId;
            String value;
            Metric metric;
            int runIndex = this.lastMetricsSession.incrementAndGet();
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("METRICS_SESSIONS")).addColumns(this.metricsSessionColumns).toSQL(this.getDialect()));){
                insert.setInt(1, runIndex);
                insert.setString(2, loc.getProjectKey());
                ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 3, loc.getName(), "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 4, partitionId, "NP");
                insert.setLong(5, timeCompute);
                insert.setString(6, hash);
                insert.execute();
            }
            insert = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("METRICS_HISTORY")).addColumns(this.metricsColumns).toSQL(this.getDialect()));
            try {
                for (Map.Entry<Metric, String> metricValue : metricValues.entrySet()) {
                    metric = metricValue.getKey();
                    value = metricValue.getValue();
                    insert.setInt(1, runIndex);
                    metricId = metric.getId();
                    metricDataType = metric.getDataType();
                    insert.setString(2, metricId);
                    saveDataType = metricDataType == null ? Type.STRING : metricDataType;
                    insert.setString(3, saveDataType.name());
                    insert.setString(4, value);
                    insert.addBatch();
                }
                insert.executeBatch();
            }
            finally {
                if (insert != null) {
                    insert.close();
                }
            }
            insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("METRICS_LAST")).addColumns(new SchemaColumn[][]{this.metricsSessionColumns, this.metricsDataColumns}).addKeyColumns("PROJECT_KEY", "OBJECT_ID", "PARTITION", "METRIC_ID").toSQL(this.getDialect()));
            try {
                for (Map.Entry<Metric, String> metricValue : metricValues.entrySet()) {
                    metric = metricValue.getKey();
                    value = metricValue.getValue();
                    insert.setInt(1, runIndex);
                    insert.setString(2, loc.getProjectKey());
                    ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 3, loc.getName(), "__null__");
                    ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 4, partitionId, "NP");
                    insert.setLong(5, timeCompute);
                    insert.setString(6, hash);
                    metricId = metric.getId();
                    metricDataType = metric.getDataType();
                    ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 7, metricId, "__null__");
                    saveDataType = metric.getDataType() == null ? Type.STRING : metricDataType;
                    insert.setString(8, saveDataType.name());
                    insert.setString(9, value);
                    insert.addBatch();
                }
                insert.executeBatch();
            }
            finally {
                if (insert != null) {
                    insert.close();
                }
            }
            ac.commit();
        }
    }

    public void saveChecks(String projectKey, String objectId, String partitionId, long timeCompute, Map<? extends DataQualityRule, AbstractCheckContext.CheckResult> checkValues, DataQualityRunOrigin runOrigin) throws SQLException {
        logger.debug((Object)("Saving checks for " + projectKey + "." + objectId));
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.write.saveChecks");
             DSSDBConnection ac = this.acquireConnection();){
            AbstractCheckContext.CheckResult value;
            DataQualityRule check;
            int runIndex = this.lastChecksSession.incrementAndGet();
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("CHECKS_SESSIONS")).addColumns(this.checksSessionColumns).toSQL(this.getDialect()));){
                insert.setInt(1, runIndex);
                insert.setString(2, projectKey);
                ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 3, objectId, "__null__");
                ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 4, partitionId, "NP");
                insert.setLong(5, timeCompute);
                insert.setString(6, JSON.json((Object)runOrigin));
                insert.execute();
            }
            insert = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("CHECKS_HISTORY")).addColumns(this.checksColumns).toSQL(this.getDialect()));
            try {
                for (Map.Entry<? extends DataQualityRule, AbstractCheckContext.CheckResult> checkValue : checkValues.entrySet()) {
                    check = checkValue.getKey();
                    value = checkValue.getValue();
                    insert.setInt(1, runIndex);
                    ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 2, check.getId(), "__null__");
                    insert.setString(3, JSON.json((Object)check));
                    insert.setString(4, value.outcome.name());
                    if (value.message == null) {
                        insert.setNull(5, 12);
                    } else {
                        insert.setString(5, value.message);
                    }
                    insert.addBatch();
                }
                insert.executeBatch();
            }
            finally {
                if (insert != null) {
                    insert.close();
                }
            }
            insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("CHECKS_LAST")).addColumns(new SchemaColumn[][]{this.checksSessionColumns, this.checksDataColumns}).addKeyColumns("PROJECT_KEY", "OBJECT_ID", "PARTITION", "NAME").toSQL(this.getDialect()));
            try {
                for (Map.Entry<? extends DataQualityRule, AbstractCheckContext.CheckResult> checkValue : checkValues.entrySet()) {
                    check = checkValue.getKey();
                    value = checkValue.getValue();
                    insert.setInt(1, runIndex);
                    insert.setString(2, projectKey);
                    ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 3, objectId, "__null__");
                    ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 4, partitionId, "NP");
                    insert.setLong(5, timeCompute);
                    insert.setString(6, JSON.json((Object)runOrigin));
                    ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 7, check.getId(), "__null__");
                    insert.setString(8, JSON.json((Object)check));
                    insert.setString(9, value.outcome.name());
                    if (value.message == null) {
                        insert.setNull(10, 12);
                    } else {
                        insert.setString(10, value.message);
                    }
                    insert.addBatch();
                }
                insert.executeBatch();
            }
            finally {
                if (insert != null) {
                    insert.close();
                }
            }
            ac.commit();
        }
    }

    public void updateDataQualityPartitionStatus(ReadOnlyJobsInternalDB.DataQualityPartitionPoint pt, List<ReadOnlyJobsInternalDB.ComputedRule> computedRules) throws Exception {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("DATA_QUALITY_PARTITION_LAST")).addColumns(new SchemaColumn[][]{DATA_QUALITY_PARTITION_LAST_KEY_COLUMNS, DATA_QUALITY_PARTITION_LAST_DATA_COLUMNS}).addKeyColumns(DATA_QUALITY_PARTITION_LAST_KEY_COLUMNS).toSQL(this.getDialect()));){
                insert.setString(1, pt.projectKey);
                insert.setString(2, pt.objectId);
                insert.setString(3, pt.partitionId);
                insert.setLong(4, pt.timestamp);
                insert.setInt(5, pt.last.errorCount);
                insert.setInt(6, pt.last.warningCount);
                insert.setInt(7, pt.last.okCount);
                insert.setInt(8, pt.last.emptyCount);
                insert.setInt(9, pt.worst.errorCount);
                insert.setInt(10, pt.worst.warningCount);
                insert.setInt(11, pt.worst.okCount);
                insert.setInt(12, pt.worst.emptyCount);
                insert.setLong(13, pt.lastRunRuleComputeTime);
                insert.execute();
            }
            long computeDay = new DateTime(pt.timestamp).withZone(DateTimeZone.UTC).withTimeAtStartOfDay().getMillis();
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("DATA_QUALITY_PARTITION_HISTORY")).addColumns(new SchemaColumn[][]{DATA_QUALITY_PARTITION_HISTORY_KEY_COLUMNS, DATA_QUALITY_PARTITION_HISTORY_DATA_COLUMNS}).addKeyColumns(DATA_QUALITY_PARTITION_HISTORY_KEY_COLUMNS).toSQL(this.getDialect()));){
                insert.setString(1, pt.projectKey);
                insert.setString(2, pt.objectId);
                insert.setString(3, pt.partitionId);
                insert.setLong(4, computeDay);
                insert.setInt(5, pt.last.errorCount);
                insert.setInt(6, pt.last.warningCount);
                insert.setInt(7, pt.last.okCount);
                insert.setInt(8, pt.last.emptyCount);
                insert.setInt(9, pt.worst.errorCount);
                insert.setInt(10, pt.worst.warningCount);
                insert.setInt(11, pt.worst.okCount);
                insert.setInt(12, pt.worst.emptyCount);
                insert.setString(13, JSON.json(computedRules));
                insert.setLong(14, pt.lastRunRuleComputeTime);
                insert.execute();
            }
            ac.commit();
        }
    }

    public void updateDataQualityObjectStatus(ReadOnlyJobsInternalDB.DataQualityLastObjectPoint pt, boolean monitored) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("DATA_QUALITY_OBJECT_LAST")).addColumns(new SchemaColumn[][]{DATA_QUALITY_OBJECT_LAST_KEY_COLUMNS, DATA_QUALITY_OBJECT_LAST_DATA_COLUMNS}).addKeyColumns(DATA_QUALITY_OBJECT_LAST_KEY_COLUMNS).toSQL(this.getDialect()));){
                insert.setString(1, pt.projectKey);
                insert.setString(2, pt.objectId);
                insert.setLong(3, pt.timestamp);
                insert.setInt(4, pt.last.errorCount);
                insert.setInt(5, pt.last.warningCount);
                insert.setInt(6, pt.last.okCount);
                insert.setInt(7, pt.last.emptyCount);
                insert.setInt(8, pt.worst.errorCount);
                insert.setInt(9, pt.worst.warningCount);
                insert.setInt(10, pt.worst.okCount);
                insert.setInt(11, pt.worst.emptyCount);
                insert.setString(12, pt.worstMonitoredOutcome == null ? null : pt.worstMonitoredOutcome.name());
                insert.setString(13, pt.displayName);
                insert.setBoolean(14, pt.deleted);
                insert.setLong(15, pt.lastRunRuleComputeTime);
                insert.execute();
            }
            long computeDay = new DateTime(pt.timestamp).withZone(DateTimeZone.UTC).withTimeAtStartOfDay().getMillis();
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("DATA_QUALITY_OBJECT_HISTORY")).addColumns(new SchemaColumn[][]{DATA_QUALITY_OBJECT_HISTORY_KEY_COLUMNS, DATA_QUALITY_OBJECT_HISTORY_DATA_COLUMNS}).addKeyColumns(DATA_QUALITY_OBJECT_HISTORY_KEY_COLUMNS).toSQL(this.getDialect()));){
                insert.setString(1, pt.projectKey);
                insert.setString(2, pt.objectId);
                insert.setLong(3, computeDay);
                insert.setInt(4, pt.last.errorCount);
                insert.setInt(5, pt.last.warningCount);
                insert.setInt(6, pt.last.okCount);
                insert.setInt(7, pt.last.emptyCount);
                insert.setInt(8, pt.worst.errorCount);
                insert.setInt(9, pt.worst.warningCount);
                insert.setInt(10, pt.worst.okCount);
                insert.setInt(11, pt.worst.emptyCount);
                insert.setBoolean(12, monitored);
                insert.setBoolean(13, pt.deleted);
                insert.setLong(14, pt.lastRunRuleComputeTime);
                insert.execute();
            }
            ac.commit();
        }
    }

    public void updateDataQualityProjectStatus(ReadOnlyJobsInternalDB.DataQualityProjectPoint pt, List<ReadOnlyJobsInternalDB.ObjectHistoryRef> objectHistoryRefs) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("DATA_QUALITY_PROJECT_LAST")).addColumns(new SchemaColumn[][]{DATA_QUALITY_PROJECT_LAST_KEY_COLUMNS, DATA_QUALITY_PROJECT_LAST_DATA_COLUMNS}).addKeyColumns(DATA_QUALITY_PROJECT_LAST_KEY_COLUMNS).toSQL(this.getDialect()));){
                insert.setString(1, pt.projectKey);
                insert.setLong(2, pt.timestamp);
                insert.setInt(3, pt.last.errorCount);
                insert.setInt(4, pt.last.warningCount);
                insert.setInt(5, pt.last.okCount);
                insert.setInt(6, pt.last.emptyCount);
                insert.setInt(7, pt.worst.errorCount);
                insert.setInt(8, pt.worst.warningCount);
                insert.setInt(9, pt.worst.okCount);
                insert.setInt(10, pt.worst.emptyCount);
                insert.setLong(11, pt.lastRunRuleComputeTime);
                insert.execute();
            }
            long computeDay = new DateTime(pt.timestamp).withZone(DateTimeZone.UTC).withTimeAtStartOfDay().getMillis();
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("DATA_QUALITY_PROJECT_HISTORY")).addColumns(new SchemaColumn[][]{DATA_QUALITY_PROJECT_HISTORY_KEY_COLUMNS, DATA_QUALITY_PROJECT_HISTORY_DATA_COLUMNS}).addKeyColumns(DATA_QUALITY_PROJECT_HISTORY_KEY_COLUMNS).toSQL(this.getDialect()));){
                insert.setString(1, pt.projectKey);
                insert.setLong(2, computeDay);
                insert.setInt(3, pt.last.errorCount);
                insert.setInt(4, pt.last.warningCount);
                insert.setInt(5, pt.last.okCount);
                insert.setInt(6, pt.last.emptyCount);
                insert.setInt(7, pt.worst.errorCount);
                insert.setInt(8, pt.worst.warningCount);
                insert.setInt(9, pt.worst.okCount);
                insert.setInt(10, pt.worst.emptyCount);
                insert.setString(11, JSON.json(objectHistoryRefs));
                insert.setLong(12, pt.lastRunRuleComputeTime);
                insert.execute();
            }
            ac.commit();
        }
    }

    private String buildTimeShiftQuery(String tableName, String projectKey, @Nullable String objectId, long by, String ... toUpdateColumns) {
        HashMap<Object, String> placeholders = new HashMap<Object, String>();
        placeholders.put("TABLE", this.getQuotedFullResolvedTableName(tableName));
        placeholders.put("PROJECT_KEY_COLUMN", this.quote("PROJECT_KEY"));
        placeholders.put("PROJECT_KEY", this.quoteString(projectKey));
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ${TABLE} SET ");
        int i = 0;
        for (String toUpdateColumn : toUpdateColumns) {
            String colId = "COL" + i++;
            sb.append("${" + colId + "} = CASE ${" + colId + "} WHEN -1 THEN -1 ELSE ${" + colId + "} - ${BY} END,");
            placeholders.put(colId, this.quote(toUpdateColumn));
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" WHERE ${PROJECT_KEY_COLUMN} = ${PROJECT_KEY}");
        if (objectId != null) {
            sb.append(" AND ${OBJECT_ID_COLUMN} = ${OBJECT_ID}");
            placeholders.put("OBJECT_ID_COLUMN", this.quote("OBJECT_ID"));
            placeholders.put("OBJECT_ID", this.quoteString(objectId));
        }
        placeholders.put("BY", Long.toString(1L));
        String q1 = new StringSubstitutor(placeholders, "${", "}").replace(sb.toString());
        placeholders.put("BY", Long.toString(by - 1L));
        String q2 = new StringSubstitutor(placeholders, "${", "}").replace(sb.toString());
        return q1 + "; " + q2;
    }

    public void shiftAllDQTimestamps(String projectKey, String objectId, long by) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            ArrayList queries = Lists.newArrayList((Object[])new String[]{this.buildTimeShiftQuery("CHECKS_LAST", projectKey, objectId, by, "TIME_COMPUTE"), this.buildTimeShiftQuery("CHECKS_SESSIONS", projectKey, objectId, by, "TIME_COMPUTE"), this.buildTimeShiftQuery("DATA_QUALITY_PARTITION_HISTORY", projectKey, objectId, by, "DAY", "LAST_RULE_COMPUTE_TIME"), this.buildTimeShiftQuery("DATA_QUALITY_PARTITION_LAST", projectKey, objectId, by, "UPDATE_TIME", "LAST_RULE_COMPUTE_TIME"), this.buildTimeShiftQuery("DATA_QUALITY_OBJECT_HISTORY", projectKey, objectId, by, "DAY", "LAST_RULE_COMPUTE_TIME"), this.buildTimeShiftQuery("DATA_QUALITY_OBJECT_LAST", projectKey, objectId, by, "UPDATE_TIME", "LAST_RULE_COMPUTE_TIME"), this.buildTimeShiftQuery("DATA_QUALITY_PROJECT_HISTORY", projectKey, null, by, "DAY", "LAST_RULE_COMPUTE_TIME"), this.buildTimeShiftQuery("DATA_QUALITY_PROJECT_LAST", projectKey, null, by, "UPDATE_TIME", "LAST_RULE_COMPUTE_TIME")});
            for (String query : queries) {
                PreparedStatement update = ac.prepareNonPersistedStatement(query);
                try {
                    update.execute();
                }
                finally {
                    if (update == null) continue;
                    update.close();
                }
            }
            SelectQueryBuilder getLine = new SelectQueryBuilder();
            getLine.from(this.resolveTable("DATA_QUALITY_PROJECT_HISTORY"), "history");
            getLine.select("DAY");
            getLine.select("OBJECT_HISTORY_REFS");
            getLine.where(EBF.col("PROJECT_KEY").nullUnsafeEq(projectKey));
            String updateQuery = UpdateQueryBuilder.update(this.resolveTable("DATA_QUALITY_PROJECT_HISTORY")).columns("OBJECT_HISTORY_REFS").where(EBF.col("PROJECT_KEY").nullUnsafeEq(projectKey)).where(EBF.col("DAY").nullUnsafeEq(EBF.expr("?"))).toSql(this.getDialect());
            try (PreparedStatement select = ac.prepareNonPersistedStatement(getLine.toSQL(this.getDialect()));
                 PreparedStatement update = ac.prepareNonPersistedStatement(updateQuery);){
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    long day = rs2.getLong(1);
                    List refs = (List)JSON.parse((String)rs2.getString(2), (TypeToken)new TypeToken<List<ReadOnlyJobsInternalDB.ObjectHistoryRef>>(){});
                    List updatedRefs = refs.stream().map(r -> new ReadOnlyJobsInternalDB.ObjectHistoryRef(r.objectId, Math.max(r.computeDay - by, -1L))).collect(Collectors.toList());
                    update.setString(1, JSON.json(updatedRefs));
                    update.setLong(2, day);
                    update.execute();
                }
            }
            ac.commit();
        }
    }

    public void shiftAllMetricsTimestamps(String projectKey, @Nullable String objectId, long by) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            String updateLast = this.buildTimeShiftQuery("METRICS_LAST", projectKey, objectId, by, "TIME_COMPUTE");
            try (PreparedStatement update = ac.prepareNonPersistedStatement(updateLast);){
                update.execute();
            }
            String updateSessions = this.buildTimeShiftQuery("METRICS_SESSIONS", projectKey, objectId, by, "TIME_COMPUTE");
            try (PreparedStatement update = ac.prepareNonPersistedStatement(updateSessions);){
                update.execute();
            }
            ac.commit();
        }
    }

    private void switchAllTimestampColumns(Statement st2) throws SQLException {
        HashMap columnsToSwitch = Maps.newHashMap();
        columnsToSwitch.put("metrics_sessions", Lists.newArrayList((Object[])new String[]{"time_compute"}));
        columnsToSwitch.put("checks_sessions", Lists.newArrayList((Object[])new String[]{"time_compute"}));
        columnsToSwitch.put("metrics_last", Lists.newArrayList((Object[])new String[]{"time_compute"}));
        columnsToSwitch.put("checks_last", Lists.newArrayList((Object[])new String[]{"time_compute"}));
        columnsToSwitch.put("trigger_fires", Lists.newArrayList((Object[])new String[]{"time_trigger"}));
        columnsToSwitch.put("step_runs", Lists.newArrayList((Object[])new String[]{"time_start", "time_end"}));
        columnsToSwitch.put("scenario_runs", Lists.newArrayList((Object[])new String[]{"time_start", "time_end"}));
        columnsToSwitch.put("job", Lists.newArrayList((Object[])new String[]{"time_start", "time_end"}));
        columnsToSwitch.put("flow_object_action", Lists.newArrayList((Object[])new String[]{"time_start", "time_end"}));
        columnsToSwitch.put("flow_object_action_history", Lists.newArrayList((Object[])new String[]{"time_start", "time_end"}));
        columnsToSwitch.put("built_dataset_partitions", Lists.newArrayList((Object[])new String[]{"time_start", "time_end"}));
        this.switchTimestampsToLong(st2, columnsToSwitch);
    }

    private void cleanupDanglingJobsAndScenarios(DSSDBConnection conn) throws SQLException {
        Statement st2;
        ArrayList<Pair> jobsToCleanup = new ArrayList<Pair>();
        try (Statement st3 = conn.createStatement();){
            ResultSet rs2 = st3.executeQuery("SELECT " + this.quote("JOB_PROJECT_KEY") + "," + this.quote("JOB_ID") + " FROM " + this.getQuotedFullResolvedTableName("JOB") + " where " + this.quote("STABLE_STATE") + " = false");
            while (rs2.next()) {
                jobsToCleanup.add(new Pair((Object)rs2.getString(1), (Object)rs2.getString(2)));
            }
            logger.info((Object)("Collected " + jobsToCleanup.size() + " jobs to cleanup"));
        }
        catch (SQLException e) {
            logger.error((Object)"Failed to initialize database state", (Throwable)e);
            conn.rollback();
            throw e;
        }
        PostJobActionsHandler handler = (PostJobActionsHandler)SpringUtils.getBean(PostJobActionsHandler.class);
        for (Pair p : jobsToCleanup) {
            handler.onEndOfJob((String)p.first, (String)p.second);
        }
        try {
            st2 = conn.createStatement();
            try {
                st2.execute("UPDATE " + this.getQuotedFullResolvedTableName("JOB") + " SET " + this.quote("STATE") + " = 'ABORTED', " + this.quote("STABLE_STATE") + " = true where " + this.quote("STABLE_STATE") + " = false");
                logger.info((Object)("Marked " + st2.getUpdateCount() + " jobs as aborted"));
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Failed to initialize database state", (Throwable)e);
            conn.rollback();
            throw e;
        }
        try {
            st2 = conn.prepareNonPersistedStatement("UPDATE " + this.getQuotedFullResolvedTableName("SCENARIO_RUNS") + " SET " + this.quote("TIME_END") + " = ?, " + this.quote("RESULT") + " = ?, " + this.quote("OUTCOME") + " = ? WHERE " + this.quote("TIME_END") + " IS NULL");
            try {
                ReportItem result = new ReportItem.ScenarioDone(new ReportTargetItem.ScenarioItem(null, null)).withOutcome(ReportItem.Outcome.ABORTED).withThrown(new Exception("Unterminated run, aborted when starting DSS"));
                st2.setLong(1, DateTime.now().getMillis());
                st2.setString(2, JSON.json((Object)result));
                st2.setString(3, result.getOutcome().name());
                st2.execute();
                logger.info((Object)("Marked " + st2.getUpdateCount() + " scenarios as done"));
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Failed to initialize database state", (Throwable)e);
            conn.rollback();
            throw e;
        }
    }

    private void createOrUpdateJobTables(Statement st2, boolean updateOldJobTable) throws SQLException {
        if (updateOldJobTable) {
            st2.execute("ALTER TABLE " + this.getQuotedFullResolvedTableName("JOB") + " ADD COLUMN (" + this.getDefinition(this.scenarioRunIdColumns, this.stepIdColumns) + ")");
        } else {
            CreateTableQueryBuilder.createTable(this.resolveTable("JOB")).addColumns(new SchemaColumn[][]{this.jobIdColumns, this.actionTimeColumns, this.jobInfoColumns, this.scenarioRunIdColumns, this.stepIdColumns}).execute(st2, this.getDialect());
        }
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("JOB")).addColumns("JOB_PROJECT_KEY", "STATE").execute(st2, this.getDialect());
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("JOB")).addColumns(new SchemaColumn[][]{this.scenarioRunIdColumns, this.stepIdColumns}).execute(st2, this.getDialect());
    }

    private void createDataQualityTables(Statement st2) throws SQLException {
        logger.info((Object)"Creating data quality tables");
        CreateTableQueryBuilder.createTable(this.resolveTable("DATA_QUALITY_PARTITION_HISTORY")).ifNotExists().addColumns(new SchemaColumn[][]{DATA_QUALITY_PARTITION_HISTORY_KEY_COLUMNS, DATA_QUALITY_PARTITION_HISTORY_DATA_COLUMNS}).addKeyColumns(new SchemaColumn[][]{DATA_QUALITY_PARTITION_HISTORY_KEY_COLUMNS}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("DATA_QUALITY_PARTITION_LAST")).ifNotExists().addColumns(new SchemaColumn[][]{DATA_QUALITY_PARTITION_LAST_KEY_COLUMNS, DATA_QUALITY_PARTITION_LAST_DATA_COLUMNS}).addKeyColumns(new SchemaColumn[][]{DATA_QUALITY_PARTITION_LAST_KEY_COLUMNS}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("DATA_QUALITY_OBJECT_HISTORY")).ifNotExists().addColumns(new SchemaColumn[][]{DATA_QUALITY_OBJECT_HISTORY_KEY_COLUMNS, DATA_QUALITY_OBJECT_HISTORY_DATA_COLUMNS}).addKeyColumns(new SchemaColumn[][]{DATA_QUALITY_OBJECT_HISTORY_KEY_COLUMNS}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("DATA_QUALITY_OBJECT_LAST")).ifNotExists().addColumns(new SchemaColumn[][]{DATA_QUALITY_OBJECT_LAST_KEY_COLUMNS, DATA_QUALITY_OBJECT_LAST_DATA_COLUMNS}).addKeyColumns(new SchemaColumn[][]{DATA_QUALITY_OBJECT_LAST_KEY_COLUMNS}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("DATA_QUALITY_PROJECT_HISTORY")).ifNotExists().addColumns(new SchemaColumn[][]{DATA_QUALITY_PROJECT_HISTORY_KEY_COLUMNS, DATA_QUALITY_PROJECT_HISTORY_DATA_COLUMNS}).addKeyColumns(new SchemaColumn[][]{DATA_QUALITY_PROJECT_HISTORY_KEY_COLUMNS}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("DATA_QUALITY_PROJECT_LAST")).ifNotExists().addColumns(new SchemaColumn[][]{DATA_QUALITY_PROJECT_LAST_KEY_COLUMNS, DATA_QUALITY_PROJECT_LAST_DATA_COLUMNS}).addKeyColumns(new SchemaColumn[][]{DATA_QUALITY_PROJECT_LAST_KEY_COLUMNS}).execute(st2, this.getDialect());
    }

    private void addRunTypeColumns(Statement st2) throws SQLException {
        logger.info((Object)"Adding RUN_ORIGIN column to Checks tables");
        AddColumnQueryBuilder.addColumnTo(this.resolveTable("CHECKS_LAST")).addColumns(this.runOriginColumn).execute(st2, this.getDialect());
        AddColumnQueryBuilder.addColumnTo(this.resolveTable("CHECKS_SESSIONS")).addColumns(this.runOriginColumn).execute(st2, this.getDialect());
    }

    private void createScenarioTables(Statement st2) throws SQLException {
        logger.info((Object)"Creating scenario tables");
        CreateTableQueryBuilder.createTable(this.resolveTable("SCENARIO_RUNS")).addColumns(new SchemaColumn[][]{this.scenarioRunIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.scenarioRunInfoColumns}).execute(st2, this.getDialect());
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("SCENARIO_RUNS")).addColumns(this.scenarioRunIdColumns).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("TRIGGER_FIRES")).addColumns(new SchemaColumn[][]{this.scenarioIdColumns, this.triggerIdColumns, this.triggerInfoColumns}).execute(st2, this.getDialect());
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("TRIGGER_FIRES")).addColumns(new SchemaColumn[][]{this.scenarioIdColumns, this.triggerIdColumns}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("STEP_RUNS")).addColumns(new SchemaColumn[][]{this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.stepInfoColumns}).addKeyColumns(this.scenarioRunIdColumns, this.stepIdColumns).execute(st2, this.getDialect());
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("STEP_RUNS")).addColumns(new SchemaColumn[][]{this.scenarioRunIdColumns, this.stepIdColumns}).execute(st2, this.getDialect());
    }

    private void createOrUpdateHistorizedStuffTables(Statement st2, boolean updateOldBuiltPartitionsTable) throws SQLException {
        CreateTableQueryBuilder.createTable(this.resolveTable("FLOW_OBJECT_ACTION")).addColumns(new SchemaColumn[][]{this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns}).addKeyColumns("PROJECT_KEY", "OBJECT_ID", "PARTITION", "TYPE").execute(st2, this.getDialect());
        if (updateOldBuiltPartitionsTable) {
            logger.info((Object)"Updating historized actions table");
            st2.execute("ALTER TABLE built_dataset_partitions RENAME TO flow_object_action_history");
            st2.execute("ALTER TABLE flow_object_action_history ALTER COLUMN dataset_name RENAME TO object_id");
            st2.execute("ALTER TABLE flow_object_action_history ADD COLUMN (" + this.getDefinition(this.scenarioRunIdColumns, this.stepIdColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns) + ", deleted boolean)");
            st2.execute("UPDATE flow_object_action_history SET outcome = CASE WHEN success THEN '" + String.valueOf((Object)ReportItem.Outcome.SUCCESS) + "' ELSE '" + String.valueOf((Object)ReportItem.Outcome.FAILED) + "' END");
            st2.execute("ALTER TABLE flow_object_action_history DROP COLUMN success");
            String lastOfEach = "SELECT " + this.getList(new SchemaColumn[][]{this.objectPartitionIdColumns}) + ",MAX(time_start) AS time_start FROM flow_object_action_history GROUP BY " + this.getList(new SchemaColumn[][]{this.objectPartitionIdColumns});
            SchemaColumn[][] cols = new SchemaColumn[][]{this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns};
            st2.execute("CREATE INDEX ON flow_object_action_history (" + this.getList(new SchemaColumn[][]{this.objectIdColumns}) + ", time_start)");
            st2.execute("INSERT INTO flow_object_action (" + this.getList(cols) + ") (SELECT " + this.getList("h.", (SchemaColumn[][])cols) + " FROM flow_object_action_history h INNER JOIN (" + lastOfEach + ") l ON h.project_key = l.project_key AND h.object_id = l.object_id AND h.partition = l.partition AND h.time_start = l.time_start)");
        } else {
            logger.info((Object)"Creating historized actions table");
            CreateTableQueryBuilder.createTable(this.resolveTable("FLOW_OBJECT_ACTION_HISTORY")).addColumns(new SchemaColumn[][]{this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns}).addColumns(DELETED_SCHEMA_COLUMN).execute(st2, this.getDialect());
            CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("FLOW_OBJECT_ACTION_HISTORY")).addColumns(this.objectPartitionIdColumns).execute(st2, this.getDialect());
        }
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("FLOW_OBJECT_ACTION_HISTORY")).addColumns(this.scenarioRunIdColumns).execute(st2, this.getDialect());
    }

    private void createMetricsTables(Statement st2) throws SQLException {
        CreateTableQueryBuilder.createTable(this.resolveTable("METRICS_SESSIONS")).addColumns(this.metricsSessionColumns).execute(st2, this.getDialect());
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("METRICS_SESSIONS")).addColumns("PROJECT_KEY", "OBJECT_ID", "PARTITION", "TIME_COMPUTE").execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("METRICS_HISTORY")).addColumns(this.metricsColumns).execute(st2, this.getDialect());
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("METRICS_HISTORY")).addColumns("SESSION_INDEX", "METRIC_ID").execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("METRICS_LAST")).addKeyColumns("PROJECT_KEY", "OBJECT_ID", "PARTITION", "METRIC_ID").addColumns(new SchemaColumn[][]{this.metricsSessionColumns, this.metricsDataColumns}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("CHECKS_SESSIONS")).addColumns(this.checksSessionColumnsLegacyBeforeV15).execute(st2, this.getDialect());
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("CHECKS_SESSIONS")).addColumns("PROJECT_KEY", "OBJECT_ID", "PARTITION", "TIME_COMPUTE").execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("CHECKS_HISTORY")).addColumns(this.checksColumns).execute(st2, this.getDialect());
        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("CHECKS_HISTORY")).addColumns("SESSION_INDEX", "NAME").execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("CHECKS_LAST")).addKeyColumns("PROJECT_KEY", "OBJECT_ID", "PARTITION", "NAME").addColumns(new SchemaColumn[][]{this.checksSessionColumnsLegacyBeforeV15, this.checksDataColumns}).execute(st2, this.getDialect());
    }

    private void updateScenarioRunsTable(Statement st2) throws SQLException {
        st2.execute("ALTER TABLE scenario_runs ADD COLUMN (" + this.getDefinition(new SchemaColumn[][]{this.scenarioRunUserColumns}) + ")");
    }

    private void updateScenarioRunsTableWithTestColumns(Statement st2) throws SQLException {
        logger.info((Object)"Adding BUNDLE_ID and MARKED_AS_TEST columns to scenario_runs table");
        AddColumnQueryBuilder.addColumnTo(this.resolveTable("SCENARIO_RUNS")).addColumns(this.scenarioBundleAndTestColumns[0]).execute(st2, this.getDialect());
        AddColumnQueryBuilder.addColumnTo(this.resolveTable("SCENARIO_RUNS")).addColumns(this.scenarioBundleAndTestColumns[1]).execute(st2, this.getDialect());
    }

    private void cleanupNullValuesInMergeKeys(Statement st2) throws SQLException {
        st2.execute("DROP TABLE IF EXISTS " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION_NULLS"));
        st2.execute("DROP TABLE IF EXISTS " + this.getQuotedFullResolvedTableName("METRICS_LAST_NULLS"));
        st2.execute("DROP TABLE IF EXISTS " + this.getQuotedFullResolvedTableName("CHECKS_LAST_NULLS"));
        CreateTableQueryBuilder.createTable(this.resolveTable("FLOW_OBJECT_ACTION_NULLS")).addColumns(new SchemaColumn[][]{this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("METRICS_LAST_NULLS")).addColumns(new SchemaColumn[][]{this.metricsSessionColumns, this.metricsDataColumns}).execute(st2, this.getDialect());
        CreateTableQueryBuilder.createTable(this.resolveTable("CHECKS_LAST_NULLS")).addColumns(new SchemaColumn[][]{this.checksSessionColumnsLegacyBeforeV15, this.checksDataColumns}).execute(st2, this.getDialect());
        st2.execute("INSERT INTO " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION_NULLS") + " (" + this.getList(this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns) + ") SELECT " + this.getList(this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns) + " FROM " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION") + " WHERE partition IS NULL OR partition = ''");
        st2.execute("INSERT INTO " + this.getQuotedFullResolvedTableName("METRICS_LAST_NULLS") + " (" + this.getList(this.metricsSessionColumns, this.metricsDataColumns) + ") SELECT " + this.getList(this.metricsSessionColumns, this.metricsDataColumns) + " FROM " + this.getQuotedFullResolvedTableName("METRICS_LAST") + " WHERE partition IS NULL OR partition = ''");
        st2.execute("INSERT INTO " + this.getQuotedFullResolvedTableName("CHECKS_LAST_NULLS") + " (" + this.getList(this.checksSessionColumnsLegacyBeforeV15, this.checksDataColumns) + ") SELECT " + this.getList(this.checksSessionColumnsLegacyBeforeV15, this.checksDataColumns) + " FROM " + this.getQuotedFullResolvedTableName("CHECKS_LAST") + " WHERE partition IS NULL OR partition = '' OR name IS NULL OR name = ''");
        st2.execute("UPDATE " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION_NULLS") + " SET partition = '' WHERE partition IS NULL");
        st2.execute("UPDATE " + this.getQuotedFullResolvedTableName("METRICS_LAST_NULLS") + " SET partition = '' WHERE partition IS NULL");
        st2.execute("UPDATE " + this.getQuotedFullResolvedTableName("CHECKS_LAST_NULLS") + " SET partition = '' WHERE partition IS NULL");
        st2.execute("UPDATE " + this.getQuotedFullResolvedTableName("CHECKS_LAST_NULLS") + " SET name = '' WHERE name IS NULL");
        st2.execute("DELETE FROM " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION") + " WHERE partition IS NULL OR partition = ''");
        st2.execute("DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS_LAST") + " WHERE partition IS NULL OR partition = ''");
        st2.execute("DELETE FROM " + this.getQuotedFullResolvedTableName("CHECKS_LAST") + " WHERE partition IS NULL OR partition = '' OR name IS NULL OR name = ''");
        st2.execute("INSERT INTO " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION") + " (" + this.getList(this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns) + ") SELECT " + this.getList("x.", (SchemaColumn[][])new SchemaColumn[][]{this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns}) + " FROM " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION_NULLS") + " x INNER JOIN (SELECT project_key, object_id, partition, type, MAX(time_end) as time_end FROM " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION_NULLS") + " GROUP BY project_key, object_id, partition, type) l ON l.project_key = x.project_key AND l.object_id = x.object_id AND l.partition = x.partition AND l.type = x.type AND l.time_end = x.time_end");
        st2.execute("INSERT INTO " + this.getQuotedFullResolvedTableName("METRICS_LAST") + " (" + this.getList(this.metricsSessionColumns, this.metricsDataColumns) + ") SELECT " + this.getList("x.", (SchemaColumn[][])new SchemaColumn[][]{this.metricsSessionColumns, this.metricsDataColumns}) + " FROM " + this.getQuotedFullResolvedTableName("METRICS_LAST_NULLS") + " x INNER JOIN (SELECT project_key, object_id, partition, metric_id, MAX(time_compute) as time_compute FROM " + this.getQuotedFullResolvedTableName("METRICS_LAST_NULLS") + " GROUP BY project_key, object_id, partition, metric_id) l ON l.project_key = x.project_key AND l.object_id = x.object_id AND l.partition = x.partition AND l.metric_id = x.metric_id AND l.time_compute = x.time_compute");
        st2.execute("INSERT INTO " + this.getQuotedFullResolvedTableName("CHECKS_LAST") + " (" + this.getList(this.checksSessionColumnsLegacyBeforeV15, this.checksDataColumns) + ") SELECT " + this.getList("x.", (SchemaColumn[][])new SchemaColumn[][]{this.checksSessionColumnsLegacyBeforeV15, this.checksDataColumns}) + " FROM CHECKS_LAST_NULLS x INNER JOIN (SELECT project_key, object_id, partition, name, MAX(time_compute) as time_compute FROM " + this.getQuotedFullResolvedTableName("CHECKS_LAST_NULLS") + "  GROUP BY project_key, object_id, partition, name) l ON l.project_key = x.project_key AND l.object_id = x.object_id AND l.partition = x.partition AND l.name = x.name AND l.time_compute = x.time_compute");
        st2.execute("DROP TABLE " + this.getQuotedFullResolvedTableName("FLOW_OBJECT_ACTION_NULLS"));
        st2.execute("DROP TABLE " + this.getQuotedFullResolvedTableName("METRICS_LAST_NULLS"));
        st2.execute("DROP TABLE " + this.getQuotedFullResolvedTableName("CHECKS_LAST_NULLS"));
    }

    private void fillNullPartitionFieldOnFolderMetrics(Statement st2) throws SQLException {
        this.fillNullOrEmptyInTables(st2, (List<String>)ImmutableList.of((Object)"METRICS_SESSIONS", (Object)"METRICS_LAST", (Object)"CHECKS_SESSIONS", (Object)"CHECKS_LAST"), "PARTITION", "NP");
    }

    private void fillNullOrEmptyInTables(Statement st2, List<String> tables, String columnToFill, String valueForNull) throws SQLException {
        for (String tableName : tables) {
            st2.execute(this.buildNullOrEmptyUpdateQuery(tableName, columnToFill, valueForNull));
        }
    }

    private String buildNullOrEmptyUpdateQuery(String tableName, String columnToUpdate, String valueForNull) {
        return UpdateQueryBuilder.update(this.resolveTable(tableName)).column(columnToUpdate, valueForNull).where(EBF.col(columnToUpdate).isnull().or(EBF.col(columnToUpdate).eq(""))).toSql(this.getDialect());
    }

    private void registerFlowObjectEvent(AnyLoc loc, String partition, String jobProjectKey, String jobId, String activityId, String scenarioProjectKey, String scenarioId, String scenarioRunId, String stepId, String stepRunId, ReportItem reportItem) throws SQLException {
        logger.debug((Object)"Register flow object event");
        try (DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement insert = ac.prepareNonPersistedStatement(InsertQueryBuilder.insertInto(this.resolveTable("FLOW_OBJECT_ACTION_HISTORY")).addColumns(new SchemaColumn[][]{this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns}).addColumns(DELETED_SCHEMA_COLUMN).toSQL(this.getDialect()));){
                this.fillPreparedStatementForObjectKey(loc, partition, jobProjectKey, jobId, activityId, scenarioProjectKey, scenarioId, scenarioRunId, stepId, stepRunId, insert);
                this.fillPreparedStatementForObjectResult(reportItem, insert, 12);
                insert.setBoolean(18, false);
                insert.execute();
            }
            insert = ac.prepareNonPersistedStatement(UpsertQueryBuilder.into(this.resolveTable("FLOW_OBJECT_ACTION")).addColumns(new SchemaColumn[][]{this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns}).addKeyColumns("PROJECT_KEY", "OBJECT_ID", "PARTITION", "TYPE").toSQL(this.getDialect()));
            try {
                this.fillPreparedStatementForObjectKey(loc, partition, jobProjectKey, jobId, activityId, scenarioProjectKey, scenarioId, scenarioRunId, stepId, stepRunId, insert);
                this.fillPreparedStatementForObjectResult(reportItem, insert, 12);
                insert.execute();
            }
            finally {
                if (insert != null) {
                    insert.close();
                }
            }
            ac.commit();
        }
    }

    private AbstractQueryBuilderWithWheres buildUpdateQueryBuilderForFlow(String tableToUpdate, AnyLoc loc, String partition, String jobProjectKey, String jobId, String activityId, String scenarioProjectKey, String scenarioId, String scenarioRunId, String stepId, String stepRunId) {
        UpdateQueryBuilder updateQueryBuilder = UpdateQueryBuilder.update(this.resolveTable(tableToUpdate)).columns("TIME_START", "TIME_END", "OUTCOME", "WARNINGS_COUNT", "RESULT", "TYPE");
        this.fillQueryBuilderWheres(loc, partition, jobProjectKey, jobId, activityId, scenarioProjectKey, scenarioId, scenarioRunId, stepId, stepRunId, updateQueryBuilder);
        return updateQueryBuilder;
    }

    private void updateFlowObjectEvent(AnyLoc loc, String partition, String jobProjectKey, String jobId, String activityId, String scenarioProjectKey, String scenarioId, String scenarioRunId, String stepId, String stepRunId, ReportItem reportItem) throws SQLException {
        logger.debug((Object)"Update flow object event ");
        try (DSSDBConnection ac = this.acquireConnection();){
            this.updateFlowObjectEvent(true, loc, partition, jobProjectKey, jobId, activityId, scenarioProjectKey, scenarioId, scenarioRunId, stepId, stepRunId, reportItem, ac);
            this.updateFlowObjectEvent(false, loc, partition, jobProjectKey, jobId, activityId, scenarioProjectKey, scenarioId, scenarioRunId, stepId, stepRunId, reportItem, ac);
            ac.commit();
        }
    }

    private void updateFlowObjectEvent(boolean historyTable, AnyLoc loc, String partition, String jobProjectKey, String jobId, String activityId, String scenarioProjectKey, String scenarioId, String scenarioRunId, String stepId, String stepRunId, ReportItem reportItem, DSSDBConnection ac) throws SQLException {
        String updateQuery = this.buildUpdateQueryBuilderForFlow(historyTable ? "FLOW_OBJECT_ACTION_HISTORY" : "FLOW_OBJECT_ACTION", loc, partition, jobProjectKey, jobId, activityId, scenarioProjectKey, scenarioId, scenarioRunId, stepId, stepRunId).toSql(this.getDialect());
        try (PreparedStatement update = ac.prepareNonPersistedStatement(updateQuery);){
            this.fillPreparedStatementForObjectResult(reportItem, update, 1);
            int modified = update.executeUpdate();
            logger.infoV("Updated %ss %srows", new Object[]{modified, historyTable ? "history " : ""});
        }
    }

    private void fillQueryBuilderWheres(AnyLoc loc, String partition, String jobProjectKey, String jobId, String activityId, String scenarioProjectKey, String scenarioId, String scenarioRunId, String stepId, String stepRunId, AbstractQueryBuilderWithWheres queryBuilder) {
        queryBuilder.where(EBF.col("PROJECT_KEY").eq(loc.getProjectKey())).where(EBF.col("OBJECT_ID").eq(ReadWriteJobsInternalDB.getNotNullStringParameterOrDefault(loc.getId(), "__null__"))).where(EBF.col("PARTITION").eq(ReadWriteJobsInternalDB.getNotNullStringParameterOrDefault(partition, "NP"))).where(ReadWriteJobsInternalDB.buildNullableWhere("JOB_PROJECT_KEY", jobProjectKey)).where(ReadWriteJobsInternalDB.buildNullableWhere("JOB_ID", jobId)).where(ReadWriteJobsInternalDB.buildNullableWhere("ACTIVITY_ID", activityId)).where(ReadWriteJobsInternalDB.buildNullableWhere("SCENARIO_PROJECT_KEY", scenarioProjectKey)).where(ReadWriteJobsInternalDB.buildNullableWhere("SCENARIO_ID", scenarioId)).where(ReadWriteJobsInternalDB.buildNullableWhere("SCENARIO_RUN_ID", scenarioRunId)).where(ReadWriteJobsInternalDB.buildNullableWhere("STEP_ID", stepId)).where(ReadWriteJobsInternalDB.buildNullableWhere("STEP_RUN_ID", stepRunId));
    }

    private void fillPreparedStatementForObjectKey(AnyLoc loc, String partition, String jobProjectKey, String jobId, String activityId, String scenarioProjectKey, String scenarioId, String scenarioRunId, String stepId, String stepRunId, PreparedStatement insert) throws SQLException {
        insert.setString(1, loc.getProjectKey());
        ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 2, loc.getId(), "__null__");
        ReadWriteJobsInternalDB.setNotNullStringParameter(insert, 3, partition, "NP");
        if (StringUtils.isBlank((String)jobProjectKey)) {
            insert.setNull(4, 12);
            insert.setNull(5, 12);
            insert.setNull(6, 12);
        } else {
            insert.setString(4, jobProjectKey);
            insert.setString(5, jobId);
            if (StringUtils.isBlank((String)activityId)) {
                insert.setNull(6, 12);
            } else {
                insert.setString(6, activityId);
            }
        }
        if (StringUtils.isBlank((String)scenarioProjectKey)) {
            insert.setNull(7, 12);
            insert.setNull(8, 12);
            insert.setNull(9, 12);
        } else {
            insert.setString(7, scenarioProjectKey);
            insert.setString(8, scenarioId);
            insert.setString(9, scenarioRunId);
        }
        if (StringUtils.isBlank((String)scenarioProjectKey)) {
            insert.setNull(10, 12);
            insert.setNull(11, 12);
        } else {
            insert.setString(10, stepId);
            insert.setString(11, stepRunId);
        }
    }

    private void fillPreparedStatementForObjectResult(ReportItem reportItem, PreparedStatement insert, int offset) throws SQLException {
        insert.setLong(offset, reportItem.getStart());
        insert.setLong(offset + 1, reportItem.getEnd());
        if (reportItem.getOutcome() == null) {
            insert.setNull(offset + 2, 12);
        } else {
            insert.setString(offset + 2, reportItem.getOutcome().toString());
        }
        if (reportItem.getWarnings() == null) {
            insert.setNull(offset + 3, 4);
        } else {
            insert.setInt(offset + 3, reportItem.getWarnings().totalCount);
        }
        insert.setString(offset + 4, JSON.json((Object)reportItem));
        insert.setString(offset + 5, reportItem.getType().name());
    }

    private String makeRunIdFromTimestamp() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return DKUDateUtils.isoFormatFileFriendlyLocalNow();
    }
}

