/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.Checklists;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Objects;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaggableObjectsService {
    @Autowired
    private UsersService usersService;
    static Logger logger = Logger.getLogger((String)"dku.services.taggableobjects");

    public TaggableObjectsService() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void handleCreationVersionTagOnObjectCreation(TaggableObject to) {
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        to.versionTag = new VersionTag(authCtx.getIdentifier());
        to.creationTag = new VersionTag(authCtx.getIdentifier());
    }

    public void handleCreationVersionTagOnObjectUpdate(TaggableObject to, TaggableObject preExisting) {
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        to.versionTag = VersionTag.increment(preExisting.versionTag, authCtx.getIdentifier());
        to.creationTag = (VersionTag)JSON.deepCopy((Object)preExisting.creationTag);
    }

    public void handleCreationVersionTagOnObjectUpdateNullAllowed(TaggableObject to, TaggableObject preExisting) {
        if (preExisting == null) {
            this.handleCreationVersionTagOnObjectCreation(to);
        } else {
            this.handleCreationVersionTagOnObjectUpdate(to, preExisting);
        }
    }

    public void setEditionInfoFromTags(TaggableObject object, TaggableListItem head) {
        try {
            if (object.versionTag != null) {
                head.lastModifiedBy = this.usersService.getPublicUser(object.versionTag.getLastAuthor());
                head.lastModifiedOn = object.versionTag.getLastModifiedOn();
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)(String.valueOf((Object)object.getTaggableType()) + " " + object.getFullId() + " has no version tag"));
            }
            if (object.creationTag != null) {
                head.createdBy = this.usersService.getPublicUser(object.creationTag.getLastAuthor());
                head.createdOn = object.creationTag.getLastModifiedOn();
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)(String.valueOf((Object)object.getTaggableType()) + " " + object.getFullId() + " has no creation tag"));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get edition info", (Throwable)e);
        }
    }

    public static abstract class TaggableObject {
        @Nullable
        public VersionTag versionTag;
        @Nullable
        public VersionTag creationTag;
        @Nullable
        public String description;
        @Nullable
        public String shortDesc;
        public List<String> tags = new ArrayList<String>();
        public JsonObject customFields = new JsonObject();
        public Checklists checklists = new Checklists();

        public abstract ITaggingService.TaggableType getTaggableType();

        public abstract String getProjectKey();

        public abstract String getId();

        public abstract void setProjectKey(String var1);

        public abstract void setId(String var1);

        public abstract String getDisplayName();

        public String getSubtype() {
            return null;
        }

        public String getFullId() {
            return this.getProjectKey() + "." + this.getId();
        }

        public List<String> getTags() {
            return this.tags;
        }

        public TaggableObjectRef getRef() {
            return new TaggableObjectRef(this.getProjectKey(), this.getTaggableType(), this.getId());
        }
    }

    public static abstract class TaggableListItem {
        public final String projectKey;
        public final String id;
        public final String name;
        public final List<String> tags;
        public final String shortDesc;
        public PublicUser lastModifiedBy;
        public long lastModifiedOn;
        public PublicUser createdBy;
        public long createdOn;
        public InterestsInternalDB.Interest interest;

        public TaggableListItem(TaggableObject object) {
            this.projectKey = object.getProjectKey();
            this.id = object.getId();
            this.name = StringUtils.isNotBlank((String)object.getDisplayName()) ? object.getDisplayName() : "Untitled";
            this.tags = object.tags;
            this.shortDesc = object.shortDesc;
        }

        public abstract ITaggingService.TaggableType getTaggableType();
    }

    public static class FilteredTaggableItems<T extends TaggableListItem> {
        public List<T> items = new ArrayList<T>();
        public int filteredOut;
    }

    public static class TaggableObjectSaveInfo {
        public String commitMessage;
        public boolean summaryOnly;

        public static TaggableObjectSaveInfo parse(String saveInfo) {
            if (StringUtils.isBlank((String)saveInfo)) {
                return new TaggableObjectSaveInfo();
            }
            return (TaggableObjectSaveInfo)JSON.parseDefault((String)saveInfo, TaggableObjectSaveInfo.class);
        }
    }

    public static class TaggableObjectSummary {
        public TaggableObject object;
        public InterestsInternalDB.Interest interest;
        public TimelinesService.TimelineWithVersioning timeline;
    }

    @UIModel
    public static class TaggableObjectRefWithName
    extends TaggableObjectRef {
        public final String displayName;

        public TaggableObjectRefWithName(String projectKey, ITaggingService.TaggableType type, String id, String displayName) {
            super(projectKey, type, id);
            this.displayName = displayName;
        }

        public TaggableObjectRefWithName(TaggableObjectRef tor, String displayName) {
            super(tor.projectKey, tor.type, tor.id);
            this.displayName = displayName;
        }
    }

    @UIModel
    public static class TaggableObjectRef {
        public final String projectKey;
        public final ITaggingService.TaggableType type;
        public final String id;
        @Nullable
        public final String workspaceKey;

        public TaggableObjectRef(String projectKey, ITaggingService.TaggableType type, String id, String workspaceKey) {
            this.projectKey = projectKey;
            this.type = type;
            this.id = id;
            this.workspaceKey = workspaceKey;
        }

        public TaggableObjectRef(String projectKey, ITaggingService.TaggableType type, String id) {
            this(projectKey, type, id, null);
        }

        public TaggableObjectRef(TaggableObject obj, String workspaceKey) {
            this(obj.getProjectKey(), obj.getTaggableType(), obj.getId(), workspaceKey);
        }

        public TaggableObjectRef(TaggableObject obj) {
            this(obj, null);
        }

        public TaggableObjectRef(TaggableListItem obj, String workspaceKey) {
            this(obj.projectKey, obj.getTaggableType(), obj.id, workspaceKey);
        }

        public TaggableObjectRef(TaggableListItem obj) {
            this(obj, null);
        }

        public TaggableObjectRef(TaggableObjectRef objRef, String workspaceKey) {
            this(objRef.projectKey, objRef.type, objRef.id, workspaceKey);
        }

        public String toString() {
            return "{projectKey:" + this.projectKey + ", workspaceKey:" + this.workspaceKey + ", type:" + String.valueOf((Object)this.type) + ", id:" + this.id + "}";
        }

        public String toPrettyString() {
            StringBuilder s = new StringBuilder();
            if (this.type != ITaggingService.TaggableType.PROJECT) {
                s.append(this.type.toHumanReadableString());
                if (StringUtils.isNotBlank((String)this.id)) {
                    s.append(" ").append(this.id);
                }
            }
            if (StringUtils.isNotBlank((String)this.projectKey)) {
                if (!s.isEmpty()) {
                    s.append(" from ");
                }
                s.append("project ").append(this.projectKey);
            }
            if (StringUtils.isNotBlank((String)this.workspaceKey)) {
                s.append(" in workspace ").append(this.workspaceKey);
            }
            return s.toString();
        }

        public AnyLoc getLoc() {
            return new AnyLoc(this.projectKey, this.id);
        }

        public ITaggingService.TaggableType getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.projectKey, this.type, this.workspaceKey});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TaggableObjectRef)) {
                return false;
            }
            TaggableObjectRef other = (TaggableObjectRef)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.projectKey == null ? other.projectKey != null : !this.projectKey.equals(other.projectKey)) {
                return false;
            }
            if (StringUtils.isBlank((String)this.workspaceKey) ? StringUtils.isNotBlank((String)other.workspaceKey) : !this.workspaceKey.equals(other.workspaceKey)) {
                return false;
            }
            return this.type == other.type;
        }
    }

    public static class TaggableObjectMetadata {
        public List<String> tags;
        public String shortDesc;
        public String description;
        public JsonObject customFields = new JsonObject();
    }

    public static class TaggableObjectFilter {
        public ITaggingService.TaggableType taggableType;
        public String projectKey;
        public String workspaceKey;
    }
}

