/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.dataquality;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.server.services.dataquality.DataQualityRuleComputationService;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataQualityRulesLaunchService {
    @Autowired
    DataQualityRuleComputationService dataQualityRuleComputationService;
    @Autowired
    FutureService futureService;

    public FutureResponse<AbstractCheckReport.DataQualityRulesComputationReport> computeRulesOnSinglePartition(AuthCtx user, Dataset dataset, List<DataQualityRule> rules, @Nonnull String partitionId, RunOptions options) throws Exception {
        Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId);
        ComputeRulesOnSinglePartitionThread ft = new ComputeRulesOnSinglePartitionThread((DSSAuthCtx)user, dataset, rules, partition, options);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<AbstractCheckReport.DataQualityRulesComputationReport>>(){});
    }

    public FutureResponse<AbstractCheckReport.DataQualityRulesComputationReport> computeRulesOnFullDataset(AuthCtx user, Dataset dataset, List<DataQualityRule> rules, RunOptions options) throws Exception {
        Preconditions.checkArgument((boolean)dataset.getModel().isPartitioned());
        return this.computeRulesOnSinglePartition(user, dataset, rules, "ALL", options);
    }

    public FutureResponse<Map<String, AbstractCheckReport.DataQualityRulesComputationReport>> computeRulesOnAllPartitions(AuthCtx user, Dataset dataset, List<DataQualityRule> rules, boolean computeOnFullDataset, RunOptions options) throws Exception {
        Preconditions.checkArgument((boolean)dataset.getModel().isPartitioned());
        ComputeRulesOnAllPartitionsThread ft = new ComputeRulesOnAllPartitionsThread((DSSAuthCtx)user, dataset, rules, computeOnFullDataset, options);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<Map<String, AbstractCheckReport.DataQualityRulesComputationReport>>>(){});
    }

    public FutureResponse<Map<String, AbstractCheckReport.DataQualityRulesComputationReport>> computeRulesOnMultiplePartitions(AuthCtx user, Dataset dataset, List<DataQualityRule> rules, @Nonnull String partitionSpecs, boolean computeOnFullDataset, RunOptions options) throws Exception {
        List<Partition> partitions = PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), partitionSpecs);
        ComputeRulesOnMultiplePartitionsThread ft = new ComputeRulesOnMultiplePartitionsThread((DSSAuthCtx)user, dataset, rules, partitions, computeOnFullDataset, options);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<Map<String, AbstractCheckReport.DataQualityRulesComputationReport>>>(){});
    }

    private class ComputeRulesOnSinglePartitionThread
    extends AbstractComputeRulesThread<AbstractCheckReport.DataQualityRulesComputationReport> {
        public ComputeRulesOnSinglePartitionThread(DSSAuthCtx user, Dataset dataset, List<DataQualityRule> rules, Partition partition, RunOptions options) {
            super(user, dataset, rules, false, partition.isAll() ? Collections.emptyList() : Collections.singletonList(partition), partition.isAll(), options);
            Preconditions.checkArgument((dataset.getModel().isPartitioned() || partition.isNP() ? 1 : 0) != 0);
        }

        public AbstractCheckReport.DataQualityRulesComputationReport getResult() {
            return this.result.values().stream().findFirst().orElse(null);
        }
    }

    public static class RunOptions {
        public final DataQualityRunOrigin runOrigin;
        public final boolean saveRuleResult;
        public final boolean saveMetricsResult;
        public final boolean computeAllMetrics;
        public final boolean ignorePartitionSelectionMode;
        public final boolean computeAutoRunRules;
        public final boolean computeManualRules;
        public final boolean computeDisabledRules;

        public RunOptions(DataQualityRunOrigin runOrigin, boolean saveRuleResult, boolean computeAllMetrics, boolean ignorePartitionSelectionMode, boolean computeAutoRunRules, boolean computeManualRules, boolean computeDisabledRules) {
            this.runOrigin = runOrigin;
            this.saveRuleResult = saveRuleResult;
            this.saveMetricsResult = saveRuleResult;
            this.computeAllMetrics = computeAllMetrics;
            this.ignorePartitionSelectionMode = ignorePartitionSelectionMode;
            this.computeAutoRunRules = computeAutoRunRules;
            this.computeManualRules = computeManualRules;
            this.computeDisabledRules = computeDisabledRules;
        }

        public static RunOptions fromBuildJob(String jobProjectKey, String jobId) {
            return new RunOptions(new DataQualityRunOrigin.Build(jobProjectKey, jobId), true, true, false, true, false, false);
        }

        public static RunOptions manualRun(boolean computeAutoRunRules) {
            return new RunOptions(new DataQualityRunOrigin.Manual(), true, false, false, computeAutoRunRules, true, false);
        }

        public static RunOptions testRun(boolean computeAutoRunRules) {
            return new RunOptions(new DataQualityRunOrigin.Test(), false, false, true, computeAutoRunRules, true, true);
        }

        public static RunOptions fromPublicAPI() {
            return new RunOptions(new DataQualityRunOrigin.PublicAPI(), true, false, false, true, true, false);
        }
    }

    private class ComputeRulesOnAllPartitionsThread
    extends ComputeRulesOnMultiplePartitionsThread {
        public ComputeRulesOnAllPartitionsThread(DSSAuthCtx user, Dataset dataset, List<DataQualityRule> rules, boolean computeForFullDataset, RunOptions options) {
            super(user, dataset, rules, null, computeForFullDataset, options);
        }
    }

    private class ComputeRulesOnMultiplePartitionsThread
    extends AbstractComputeRulesThread<Map<String, AbstractCheckReport.DataQualityRulesComputationReport>> {
        public ComputeRulesOnMultiplePartitionsThread(DSSAuthCtx user, Dataset dataset, List<DataQualityRule> rules, List<Partition> partitions, boolean computeForFullDataset, RunOptions options) {
            super(user, dataset, rules, partitions == null, partitions, computeForFullDataset, options);
        }

        public Map<String, AbstractCheckReport.DataQualityRulesComputationReport> getResult() {
            return this.result;
        }
    }

    private abstract class AbstractComputeRulesThread<T>
    extends FutureThread<T> {
        private final Dataset dataset;
        private final List<DataQualityRule> rules;
        private final boolean computeForAllPartitions;
        private final boolean computeForFullDataset;
        private final List<Partition> partitions;
        private final FuturePayload payload;
        protected Map<String, AbstractCheckReport.DataQualityRulesComputationReport> result;
        public final RunOptions options;

        public AbstractComputeRulesThread(DSSAuthCtx user, Dataset dataset, List<DataQualityRule> rules, boolean computeForAllPartitions, List<Partition> partitions, boolean computeForFullDataset, RunOptions options) {
            super(user);
            this.result = new HashMap<String, AbstractCheckReport.DataQualityRulesComputationReport>();
            this.dataset = dataset;
            this.rules = rules;
            this.partitions = partitions;
            this.computeForAllPartitions = computeForAllPartitions;
            this.computeForFullDataset = computeForFullDataset;
            this.payload = new FuturePayload();
            this.payload.action = "data_quality_rules_computation";
            this.payload.targets.add(DSSFuturePayloadUtils.forDataset(dataset));
            this.payload.displayName = "Compute data quality rules on " + dataset.getFullName();
            this.options = options;
        }

        public String getPayloadForStartDoneMessage() {
            return "dataset:" + this.dataset.getFullName() + " - partitions:" + JSON.json(this.partitions);
        }

        public FuturePayload getPayload() {
            return this.payload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            this.result = this.computeForAllPartitions ? DataQualityRulesLaunchService.this.dataQualityRuleComputationService.computeRulesAllPartitions_NT(this.owner, this.dataset, this.rules, this.computeForFullDataset, this.options) : DataQualityRulesLaunchService.this.dataQualityRuleComputationService.computeRules_NT(this.owner, this.dataset, this.rules, this.partitions, this.computeForFullDataset, this.options);
        }
    }
}

