/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLDialectsRegistry;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLGenerationService {
    @Autowired
    TransactionService transactionService;
    @Autowired
    ConnectionsDAO connectionsDAO;

    public SQLDialect getDialect(String dialectName, String connection) throws IOException, DKUSecurityException {
        SQLDialect dialect;
        if (StringUtils.isNotBlank((String)dialectName)) {
            dialect = SQLDialectsRegistry.get(dialectName);
            if (dialect == null) {
                throw ErrorContext.iaef((String)"Unknown SQL dialect: \"%s\". Available dialects are: %s", (Object)dialectName, (Object[])new Object[]{SQLDialectsRegistry.listAvailable().toString()});
            }
        } else {
            DSSConnection conn;
            if (StringUtils.isBlank((String)connection)) {
                throw new IllegalArgumentException("Either a dialect or a connection must be specified");
            }
            ConnectionsDAO.VirtualConnectionId virtualConnection = ConnectionsDAO.parseVirtualConnection(connection);
            if (virtualConnection != null) {
                ConnectionsDAO.VirtualConnectionType virtualConnectionType = ConnectionsDAO.VirtualConnectionType.valueOf(virtualConnection.type);
                switch (virtualConnectionType) {
                    case HIVE_HPROXY: 
                    case HIVE_JDBC: {
                        return new HiveSQLDialect();
                    }
                    case IMPALA_JDBC: {
                        return new ImpalaSQLDialect();
                    }
                    case SPARK_LIVY: {
                        return new SparkSQLDialect();
                    }
                }
            }
            if ((conn = this.connectionsDAO.getConnection(DSSAuthCtx.newNone(), connection)) == null) {
                throw ErrorContext.iaef((String)"Connection '%s' does not exist.", (Object)connection, (Object[])new Object[0]);
            }
            if (!(conn instanceof AbstractSQLConnection)) {
                throw ErrorContext.iaef((String)"Connection '%s' is not an SQL connection.", (Object)connection, (Object[])new Object[0]);
            }
            AbstractSQLConnection sqlConn = (AbstractSQLConnection)conn;
            dialect = sqlConn.getDialect();
        }
        return dialect;
    }

    public SQLTranslationResult generateSQL(QueryAst.Expr expr, SQLDialect sqlDialect) {
        SQLTranslationResult ret = new SQLTranslationResult();
        ret.sql = QuerySQLWriter.generateSafeSQL(sqlDialect, expr);
        return ret;
    }

    public static class SQLTranslationResult {
        public String sql;
    }

    public static class Dialects {
        public Collection<String> dialects;

        public Dialects(Collection<String> dialects) {
            this.dialects = dialects;
        }
    }
}

