/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hpsf.Blob;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.RecordFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.SubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.util.ZipSecureFile;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.IOUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LZWDecompresser;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.StringUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.TempFile;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.TempFileCreationStrategy;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBParser;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;

public class PoiUtils {
    private static boolean initialized;
    private static final DKULogger logger;

    public static void initializePoi() {
        try {
            TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)new CustomTempFileCreationStrategy(ApplicationConfigurator.getFile((String[])new String[]{"tmp", "poi-files"})));
            initialized = true;
        }
        catch (UnsupportedClassVersionError e) {
            logger.warn((Object)"Failed to load Apache POI. It is no longer available on Java 7, so if you need it you must upgrade to Java 8 or above.", (Throwable)e);
            initialized = false;
        }
        System.setProperty("com.dataiku.dss.shadelibpoi.log4j2.loggerContextFactory", "com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.simple.SimpleLoggerContextFactory");
        try {
            ZipSecureFile.setMinInflateRatio((double)Double.parseDouble(ApplicationConfigurator.getProperty((String)"dku.poi.secureZipFile.minInflateRatio", (String)"0.001")));
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid value found in dip.properties for dku.poi.secureZipFile.minInflateRatio", (Throwable)e);
        }
        try {
            ZipSecureFile.setGraceEntrySize((long)ApplicationConfigurator.getProperty((String)"dku.poi.secureZipFile.graceEntrySize", (int)0x100000));
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid value found in dip.properties for dku.poi.secureZipFile.graceEntrySize", (Throwable)e);
        }
        try {
            ZipSecureFile.setMaxFileCount((long)ApplicationConfigurator.getProperty((String)"dku.poi.secureZipFile.maxFileCount", (long)ZipSecureFile.getMaxFileCount()));
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid value found in dip.properties for dku.poi.secureZipFile.maxFileCount", (Throwable)e);
        }
        try {
            ZipSecureFile.setMaxEntrySize((long)ApplicationConfigurator.getProperty((String)"dku.poi.secureZipFile.maxEntrySize", (long)ZipSecureFile.getMaxEntrySize()));
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid value found in dip.properties for dku.poi.secureZipFile.maxEntrySize", (Throwable)e);
        }
        try {
            IOUtils.setByteArrayMaxOverride((int)ApplicationConfigurator.getProperty((String)"dku.poi.byteArrayMaxOverride", (int)IOUtils.getByteArrayMaxOverride()));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to set POI's IOUtils setByteArrayMaxOverride. Enter a valid value in dip.properties for dku.poi.byteArrayMaxOverride", (Throwable)e);
        }
        try {
            RecordFactory.setMaxNumberOfRecords((int)ApplicationConfigurator.getProperty((String)"dku.poi.xls.maxNumberOfRecords", (int)RecordFactory.getMaxNumberOfRecords()));
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid value found in dip.properties for dku.poi.xls.maxNumberOfRecords", (Throwable)e);
        }
        try {
            HSSFWorkbook.setMaxRecordLength((int)ApplicationConfigurator.getProperty((String)"dku.poi.xls.maxRecordLength", (int)HSSFWorkbook.getMaxRecordLength()));
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid value found in dip.properties for dku.poi.xls.maxRecordLength", (Throwable)e);
        }
        try {
            HSSFWorkbook.setMaxImageLength((int)ApplicationConfigurator.getProperty((String)"dku.poi.xls.maxImageLength", (int)HSSFWorkbook.getMaxImageLength()));
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid value found in dip.properties for dku.poi.xls.maxImageLength", (Throwable)e);
        }
        try {
            SubRecord.setMaxRecordLength((int)ApplicationConfigurator.getProperty((String)"dku.poi.xls.subRecord.maxRecordLength", (int)SubRecord.getMaxRecordLength()));
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid value found in dip.properties for dku.poi.xls.subRecord.maxRecordLength", (Throwable)e);
        }
        try {
            Blob.setMaxRecordLength((int)ApplicationConfigurator.getProperty((String)"dku.poi.xls.blob.maxMaxRecordLength", (int)Blob.getMaxRecordLength()));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to set POI's Blob maxMaxRecordLength. Enter a valid value in dip.properties for dku.poi.xls.blob.maxMaxRecordLength", (Throwable)e);
        }
        try {
            StringUtil.setMaxRecordLength((int)ApplicationConfigurator.getProperty((String)"dku.poi.stringUtil.maxMaxRecordLength", (int)StringUtil.getMaxRecordLength()));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to set POI's StringUtil maxMaxRecordLength. Enter a valid value in dip.properties for dku.poi.stringUtil.maxMaxRecordLength", (Throwable)e);
        }
        try {
            LZWDecompresser.setMaxRecordLength((int)ApplicationConfigurator.getProperty((String)"dku.poi.lzwDecompresser.maxMaxRecordLength", (int)LZWDecompresser.getMaxRecordLength()));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to set POI's LZWDecompresser maxMaxRecordLength. Enter a valid value in dip.properties for dku.poi.lzwDecompresser.maxMaxRecordLength", (Throwable)e);
        }
        try {
            XSSFBParser.setMaxRecordLength((int)ApplicationConfigurator.getProperty((String)"dku.poi.xlsb.maxMaxRecordLength", (int)XSSFBParser.getMaxRecordLength()));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to set POI's XSSFBParser maxMaxRecordLength. Enter a valid value in dip.properties for dku.poi.xlsb.maxMaxRecordLength", (Throwable)e);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        logger = DKULogger.getLogger(PoiUtils.class);
    }

    private static class CustomTempFileCreationStrategy
    implements TempFileCreationStrategy {
        private final File tmpDirectory;
        private final SecureRandom random = new SecureRandom();

        private CustomTempFileCreationStrategy(File tmpDirectory) {
            Preconditions.checkNotNull((Object)tmpDirectory, (Object)"tmpDirectory");
            this.tmpDirectory = tmpDirectory;
        }

        public File createTempFile(String prefix, String suffix) throws IOException {
            File newFile;
            try {
                DKUFileUtils.mkdirs((File)this.tmpDirectory);
                newFile = File.createTempFile(prefix, suffix, this.tmpDirectory);
            }
            catch (IOException e) {
                logger.warn((Object)("Unable to create temporary file in " + String.valueOf(this.tmpDirectory) + ". Will use system-wide temporary directory"), (Throwable)e);
                newFile = File.createTempFile(prefix, suffix);
            }
            return newFile;
        }

        public File createTempDirectory(String prefix) throws IOException {
            File newDirectory;
            try {
                DKUFileUtils.mkdirs((File)this.tmpDirectory);
                newDirectory = this.createTmpDirectory(this.tmpDirectory, prefix);
            }
            catch (IOException e) {
                logger.warn((Object)("Unable to create temporary directory in " + String.valueOf(this.tmpDirectory) + ". Will use system-wide temporary directory"), (Throwable)e);
                File systemTmpDirectory = new File(System.getProperty("java.io.tmpdir"));
                newDirectory = this.createTmpDirectory(systemTmpDirectory, prefix);
            }
            return newDirectory;
        }

        private File createTmpDirectory(File directory, String prefix) throws IOException {
            File newDirectory;
            while ((newDirectory = new File(directory, prefix + this.random.nextLong())).exists()) {
            }
            if (!newDirectory.mkdir()) {
                throw new IOException("Unable to create directory: " + newDirectory.getAbsolutePath());
            }
            return newDirectory;
        }
    }
}

