/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.zip");

    public static <T> T readFileContentJSON(File archive, String file, Class<T> ofClazz) throws IOException {
        try (ZipFile zipFile = new ZipFile(archive);){
            ZipEntry entry = zipFile.getEntry(file);
            if (entry == null) {
                logger.trace(() -> "File " + file + " not found within archive " + String.valueOf(archive));
                T t = null;
                return t;
            }
            logger.trace(() -> "Found entry " + file + " size " + entry.getSize());
            Object object = JSON.parse((InputStream)zipFile.getInputStream(entry), ofClazz);
            return (T)object;
        }
    }

    public static <T> T readFileContentJSON(File archive, String file, TypeToken<T> ofClazz) throws IOException {
        try (ZipFile zipFile = new ZipFile(archive);){
            ZipEntry entry = zipFile.getEntry(file);
            if (entry == null) {
                logger.trace(() -> "File " + file + " not found within archive " + String.valueOf(archive));
                T t = null;
                return t;
            }
            logger.trace(() -> "Found entry " + file + " size " + entry.getSize());
            Object object = JSON.parse((InputStream)zipFile.getInputStream(entry), ofClazz);
            return (T)object;
        }
    }

    public static String readFileContentString(File archive, String file) throws IOException {
        try (ZipFile zipFile = new ZipFile(archive);){
            ZipEntry entry = zipFile.getEntry(file);
            if (entry == null) {
                logger.trace(() -> "File " + file + " not found within archive " + String.valueOf(archive));
                String string = null;
                return string;
            }
            logger.trace(() -> "Found entry " + file + " size " + entry.getSize());
            String string = IOUtils.toString((InputStream)zipFile.getInputStream(entry), (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

