/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.trust.TrustedCodeService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.backend.WebAppBackendInfra;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;

@UIModel
public class WebApp
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    @JSON.FileTransient
    public RelFile storageFile;
    public String type;
    public WebAppParams params;
    public JsonObject config = new JsonObject();
    public String name;
    public String apiKey;
    public boolean isVirtual;
    boolean hasLegacyBackendURL = false;
    public String reuseKey;

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.WEB_APP;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getSubtype() {
        return this.type;
    }

    public boolean hasLegacyBackendURL() {
        return this.hasLegacyBackendURL || DKUtils.isOsWindows();
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void redactKeySecret() {
        this.apiKey = "******";
    }

    public JsonObject getSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
        return this.params.getSensitiveSettings(authCtx);
    }

    public byte[] fingerprintOfSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
        return JSON.sha256((Object)this.getSensitiveSettings(authCtx));
    }

    public <T extends WebAppParams> T getParamsAs(Class<T> clazz) {
        return (T)((WebAppParams)clazz.cast(this.params));
    }

    public static abstract class WebAppParams {
        public String runAs;
        public Integer readinessProbeTimeoutSeconds;
        public WebAppBackendInfra infra = new WebAppBackendInfra();
        public boolean forceAuthentication;

        public abstract boolean isBackendEnabled();

        public abstract boolean isAutoStartBackend();

        public JsonObject getSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
            JsonObject ret = new JsonObject();
            ret.addProperty("runAs", this.runAs);
            ret.addProperty("forceAuthentication", Boolean.valueOf(this.forceAuthentication));
            ret.add("infra", (JsonElement)this.infra.getSensitiveSettings());
            return ret;
        }

        public abstract boolean isLoadingPythonLibraries();

        public abstract boolean isLoadingRLibraries();

        public abstract List<Object> getHashElements();

        public abstract void setCodeForFile(String var1, String var2, String var3);
    }

    public static class WebAppSummary
    extends TaggableObjectsService.TaggableObjectSummary {
        public WebAppBackendInstance.BackendState backendState;
        public TrustedCodeService.TrustedCodeCheckReport trustedCodeReport;
    }

    public static class WebAppListItem
    extends TaggableObjectsService.TaggableListItem {
        public boolean backendRunning;
        public String type;

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.WEB_APP;
        }

        public WebAppListItem(WebApp webApp) {
            super(webApp);
            this.type = webApp.type;
        }
    }
}

