/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.HasFieldsList;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Collection;
import java.util.Properties;
import org.json.JSONArray;

public class Length
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1) {
            Object v = args[0];
            if (v == null) {
                return null;
            }
            if (v.getClass().isArray()) {
                Object[] a = (Object[])v;
                return a.length;
            }
            if (v instanceof Collection) {
                return ((Collection)v).size();
            }
            if (v instanceof HasFieldsList) {
                return ((HasFieldsList)v).length();
            }
            if (v instanceof JSONArray) {
                return ((JSONArray)v).length();
            }
            if (v instanceof Long) {
                return ((Long)v).toString().length();
            }
            if (v instanceof Integer) {
                return ((Integer)v).toString().length();
            }
            if (v instanceof Number && (Double)v == (double)((Double)v).longValue()) {
                v = ((Double)v).longValue();
            }
            String s = v instanceof String ? (String)v : v.toString();
            return s.length();
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects an array or a string");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Length.DOCUMENTATION", "Returns the length of <code>o</code>.").withParams("array or string o").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"hello world\"").returns("11")).withExample(Example.with("[4,5,6]").returns("3"));
    }
}

