/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.arrays;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.List;
import java.util.Properties;

public class Reverse
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1) {
            Object v = args[0];
            List<?> list = DKUFormulaUtils.asList(v);
            Object[] r = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                r[i] = list.get(r.length - i - 1);
            }
            return r;
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects an array");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Reverse.DOCUMENTATION", "Reverses array <code>a</code>.").withParams("array a").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions").withExample(Example.with("[1,2,3]", "-").returns("[3,2,1]"));
    }
}

