/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.dataiku.dip.i18n.LocalizedString;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.controls.IsTest;
import org.apache.commons.lang.StringUtils;

public class IsNotNull
extends IsTest {
    @Override
    protected LocalizedString getDescription() {
        return new LocalizedString("GREL.FUNCTION.IsNotNull.DOCUMENTATION", "Returns whether <code>o</code> is not null. It returns false when value is null or empty (\"\").<br/>It does not consider a string made of blank spaces as not null, and considers an expression with an error as not null.");
    }

    @Override
    protected boolean test(Object o) {
        if (o instanceof String) {
            return StringUtils.isNotBlank((String)((String)o));
        }
        return o != null;
    }

    @Override
    public Documentation getDocumentation() {
        return super.getDocumentation().withExample(Example.with("\"\"").returns("false")).withExample(Example.with("\" \"").returns("false")).withExample(Example.with("abs(\"a\")").returns("true"));
    }
}

