/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda;

import com.codahale.metrics.Timer;
import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.server.controllers.CallTracingAspectBase;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.MDC;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=1)
public class LambdaCallTracingAspect
extends CallTracingAspectBase {
    static final Set<String> ignoredForLoggingAndAudit = new HashSet<String>();
    private String hostname = null;
    private static DKULogger logger;

    public static void setIgnoredQueryCalls() {
        ignoredForLoggingAndAudit.add("/public/api/v1/{serviceId}/{endpointId}/predict");
        ignoredForLoggingAndAudit.add("/public/api/v1/{serviceId}/{endpointId}/predict-simple");
        ignoredForLoggingAndAudit.add("/public/api/v1/{serviceId}/{endpointId}/predict-multi");
    }

    public String getLambdaHost() {
        if (this.hostname == null) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.info((Object)("Failed to get hostname for audit logs : " + e.getMessage()));
                this.hostname = "";
            }
        }
        return this.hostname;
    }

    @Around(value="traceRequestMapping()")
    public Object doCall(ProceedingJoinPoint joinpoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinpoint.getSignature();
        Method method = signature.getMethod();
        String mapping = LambdaCallTracingAspect.getMapping((Method)method);
        this.setAuditContext(mapping);
        DKULogger.startCurrentCall();
        Timer timer = DSSMetrics.registry().timer("dku.api.internal.calltime" + mapping.replace('/', '.'));
        Timer.Context timerCtx = timer.time();
        long startTime = System.currentTimeMillis();
        HttpServletRequest request = null;
        try {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            AuditContextBase.setIPInfo((HttpServletRequest)request);
        }
        catch (Exception e) {
            logger.info((Object)("Failed to trace call info: " + e.getMessage()));
        }
        MDC.put((String)"apiCall", (Object)mapping);
        CallTracingAspectBase.AllCallsLoggingContext aclc = null;
        if (!ignoredForLoggingAndAudit.contains(mapping)) {
            aclc = this.buildAllCallsLoggingContext(joinpoint, signature);
        }
        if (aclc != null) {
            aclc.logStart(mapping, null, null, request);
        }
        Throwable thrown = null;
        try {
            Object object = joinpoint.proceed();
            return object;
        }
        catch (Throwable t) {
            thrown = t;
            throw t;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long executeTime = endTime - startTime;
            timerCtx.stop();
            if (aclc != null) {
                aclc.logDone(mapping, null, null, executeTime, thrown, request);
                aclc.emitAudit(executeTime);
            }
            this.reportPossibleAuthenticationFailure(thrown, this.getLambdaHost());
            DKULogger.endCurrentCall();
            MDC.clear();
            AuditContextBase.reset();
        }
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void traceRequestMapping() {
    }

    static {
        ignoredForLoggingAndAudit.add("/monitoring/api/{serviceId}/isAliveSimple");
        logger = DKULogger.getLogger((String)"dku.tracing");
    }
}

