/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.functioncommon;

import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.controllers.RequestMetadata;
import com.dataiku.lambda.endpoints.LambdaEndpointHandler;
import com.dataiku.lambda.endpoints.pool.PoolCallbacks;
import com.dataiku.lambda.endpoints.pool.PoolablePipeline;
import com.dataiku.lambda.model.api.FunctionResponse;
import com.dataiku.lambda.model.api.ResponseElements;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import com.dataiku.lambda.services.ServiceManager;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;

public abstract class FunctionEndpointHandlerBase<C extends LambdaEndpointConfig, P extends PoolablePipeline>
extends LambdaEndpointHandler<C>
implements PoolCallbacks<P> {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.pred");

    public FunctionEndpointHandlerBase(C config) {
        super(config);
    }

    public FunctionResponse runAndLog(JsonObject input, ServiceManager.RefcountedEndpoint re, QueryAPIKey apiKey, @Nonnull RequestMetadata requestMetadata) throws Exception {
        FunctionResponse resp = null;
        ResponseElements.Context apiContext = this.newContext();
        Exception error = null;
        try {
            resp = this.run(input, apiKey, requestMetadata);
            resp.apiContext = apiContext;
        }
        catch (Exception exc) {
            error = exc;
            throw exc;
        }
        finally {
            this.audit(re, input, resp, apiContext, error);
        }
        return resp;
    }

    @Override
    protected String getMessageType() {
        return "function-query";
    }

    @Override
    protected String getQueryType() {
        return "function";
    }

    private void audit(ServiceManager.RefcountedEndpoint re, JsonObject input, FunctionResponse resp, ResponseElements.Context apiContext, Exception error) {
        try {
            String timing = resp != null ? JSON.json((Object)resp.timing) : null;
            LambdaEndpointHandler.AuditResult output = resp != null ? this.createResult(JSON.json((Object)resp.response)) : null;
            this.createEvent(re, logger, input, output, error, timing, JSON.json((Object)apiContext)).ifPresent(AuditTrailService.EmittableAuditObj::emit);
        }
        catch (Exception e) {
            logger.warn((Object)"failed to log queries", (Throwable)e);
        }
    }

    public abstract FunctionResponse run(JsonObject var1, QueryAPIKey var2, @Nonnull RequestMetadata var3) throws Exception;
}

