/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DiskImageDetail;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ImportVolumeRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VolumeDetail;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ImportVolumeRequestMarshaller
implements Marshaller<Request<ImportVolumeRequest>, ImportVolumeRequest> {
    @Override
    public Request<ImportVolumeRequest> marshall(ImportVolumeRequest importVolumeRequest) {
        VolumeDetail volume;
        DiskImageDetail image;
        if (importVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportVolumeRequest> request = new DefaultRequest<ImportVolumeRequest>(importVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "ImportVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importVolumeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(importVolumeRequest.getAvailabilityZone()));
        }
        if (importVolumeRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(importVolumeRequest.getDescription()));
        }
        if ((image = importVolumeRequest.getImage()) != null) {
            if (image.getBytes() != null) {
                request.addParameter("Image.Bytes", StringUtils.fromLong(image.getBytes()));
            }
            if (image.getFormat() != null) {
                request.addParameter("Image.Format", StringUtils.fromString(image.getFormat()));
            }
            if (image.getImportManifestUrl() != null) {
                request.addParameter("Image.ImportManifestUrl", StringUtils.fromString(image.getImportManifestUrl()));
            }
        }
        if ((volume = importVolumeRequest.getVolume()) != null && volume.getSize() != null) {
            request.addParameter("Volume.Size", StringUtils.fromLong(volume.getSize()));
        }
        return request;
    }
}

