/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model;

import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonWebServiceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.CatalogEntry;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.Location;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetMappingRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private CatalogEntry source;
    private List<CatalogEntry> sinks;
    private Location location;

    public void setSource(CatalogEntry source) {
        this.source = source;
    }

    public CatalogEntry getSource() {
        return this.source;
    }

    public GetMappingRequest withSource(CatalogEntry source) {
        this.setSource(source);
        return this;
    }

    public List<CatalogEntry> getSinks() {
        return this.sinks;
    }

    public void setSinks(Collection<CatalogEntry> sinks) {
        if (sinks == null) {
            this.sinks = null;
            return;
        }
        this.sinks = new ArrayList<CatalogEntry>(sinks);
    }

    public GetMappingRequest withSinks(CatalogEntry ... sinks) {
        if (this.sinks == null) {
            this.setSinks(new ArrayList<CatalogEntry>(sinks.length));
        }
        for (CatalogEntry ele : sinks) {
            this.sinks.add(ele);
        }
        return this;
    }

    public GetMappingRequest withSinks(Collection<CatalogEntry> sinks) {
        this.setSinks(sinks);
        return this;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public GetMappingRequest withLocation(Location location) {
        this.setLocation(location);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getSinks() != null) {
            sb.append("Sinks: ").append(this.getSinks()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMappingRequest)) {
            return false;
        }
        GetMappingRequest other = (GetMappingRequest)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getSinks() == null ^ this.getSinks() == null) {
            return false;
        }
        if (other.getSinks() != null && !other.getSinks().equals(this.getSinks())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        return other.getLocation() == null || other.getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getSinks() == null ? 0 : this.getSinks().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        return hashCode;
    }

    @Override
    public GetMappingRequest clone() {
        return (GetMappingRequest)super.clone();
    }
}

