/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.ProcessingOutput;

@SdkInternalApi
public class ProcessingOutputMarshaller {
    private static final MarshallingInfo<String> OUTPUTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputName").build();
    private static final MarshallingInfo<StructuredPojo> S3OUTPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Output").build();
    private static final MarshallingInfo<StructuredPojo> FEATURESTOREOUTPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureStoreOutput").build();
    private static final MarshallingInfo<Boolean> APPMANAGED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppManaged").build();
    private static final ProcessingOutputMarshaller instance = new ProcessingOutputMarshaller();

    public static ProcessingOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProcessingOutput processingOutput, ProtocolMarshaller protocolMarshaller) {
        if (processingOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(processingOutput.getOutputName(), OUTPUTNAME_BINDING);
            protocolMarshaller.marshall(processingOutput.getS3Output(), S3OUTPUT_BINDING);
            protocolMarshaller.marshall(processingOutput.getFeatureStoreOutput(), FEATURESTOREOUTPUT_BINDING);
            protocolMarshaller.marshall(processingOutput.getAppManaged(), APPMANAGED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

