/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.license;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.server.services.licensing.LicenseLimitsParser;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.util.ExpireUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LocalOnlyBackendLicenseStatusService
implements LicenseStatusService {
    private CachedSatus cachedStatus;
    private static Logger logger = Logger.getLogger((String)"dku.licensing");

    @Override
    public synchronized LicenseStatusService.LicensingStatus getLicensingStatus() {
        return this.getLocalFile();
    }

    protected LicenseStatusService.LicensingStatus getLocalFile() {
        try (DSSMetrics.TimeCtx c = DSSMetrics.timeCtx("services.licenses.getLocalFile");){
            LicenseStatusService.LicensingStatus ls = new LicenseStatusService.LicensingStatus();
            File f = new File(DKUApp.getBaseFolderF(), "config/license.json");
            if (!f.isFile()) {
                ls.hasLicense = false;
                ls.invalidMessage = "No license found";
                LicenseStatusService.LicensingStatus licensingStatus = ls;
                return licensingStatus;
            }
            long ts = f.lastModified();
            if (this.cachedStatus == null || ts != this.cachedStatus.timestamp) {
                this.cachedStatus = new CachedSatus();
                try {
                    this.cachedStatus.license = (License)JSON.parseFile((File)f, License.class);
                    this.cachedStatus.timestamp = ts;
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to read license file", (Throwable)e);
                    this.cachedStatus = null;
                    ls.invalidMessage = "Failed to parse license file. Please check logs.";
                    LicenseStatusService.LicensingStatus licensingStatus = ls;
                    if (c != null) {
                        c.close();
                    }
                    return licensingStatus;
                }
                try {
                    if (System.getenv("DKU_HA_LICENSE") == null) {
                        LicenseUtils.verify(this.cachedStatus.license);
                    }
                    this.cachedStatus.valid = true;
                }
                catch (Exception e) {
                    logger.info((Object)"Validation failed", (Throwable)e);
                    this.cachedStatus.invalidMessage = e.getMessage();
                }
            }
            ls.valid = this.cachedStatus.valid;
            ls.invalidMessage = this.cachedStatus.invalidMessage;
            ls.licenseContent = (License.Content)JSON.deepCopy((Object)this.cachedStatus.license.content);
            ls.sublicense = this.cachedStatus.license.sublicense;
            ls.properties = ls.licenseContent.properties != null ? new Params(ls.licenseContent.properties) : new Params();
            this.checkExpiration(ls);
            this.checkNodeLocking(ls);
            boolean isCommunityLicense = "true".equals(ls.licenseContent.communityEdition);
            if (isCommunityLicense) {
                ls.community = true;
                ls.ceInstanceId = ls.licenseContent.instanceId;
                ls.ceRegistrationEmail = ls.licenseContent.licensee.email;
                String ceTrialUntil = ls.properties.getParam("community.eeTrialUntil", null);
                try {
                    if (!StringUtils.isBlank((String)ceTrialUntil)) {
                        Date now;
                        Date endOfTrial = ExpireUtils.parseStrAsExpires(ceTrialUntil);
                        if (endOfTrial.after(now = new Date())) {
                            ls.community = false;
                            ls.ceEntrepriseTrial = true;
                            ls.ceEntrepriseTrialUntil = endOfTrial.getTime();
                        } else {
                            ls.wasCEEntrepriseTrial = true;
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Bad license trial data", (Throwable)e);
                }
            }
            LimitsStatusComputer.LicenseLimitsStatus fakeLimitsStatusForListingProfiles = new LimitsStatusComputer.LicenseLimitsStatus();
            LicenseLimitsParser.parseLicensedProfiles(ls, fakeLimitsStatusForListingProfiles);
            boolean addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true);
            if (addNoneProfile) {
                LicenseLimitsParser.addNoneProfile(fakeLimitsStatusForListingProfiles);
            }
            ls.userProfiles = Lists.newArrayList(fakeLimitsStatusForListingProfiles.licensedProfiles.keySet());
            ls.fallbackProfile = fakeLimitsStatusForListingProfiles.fallbackProfile;
            LicenseStatusService.LicensingStatus licensingStatus = ls;
            return licensingStatus;
        }
    }

    protected void checkNodeLocking(LicenseStatusService.LicensingStatus ls) {
        if (ls.licenseContent.allowedNodes != null) {
            try {
                if (!LicenseUtils.verifyNode(ls.licenseContent.allowedNodes)) {
                    ls.valid = false;
                    ls.invalidMessage = "Your license is not authorized on this node";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void checkExpiration(LicenseStatusService.LicensingStatus ls) {
        if (ls.licenseContent.expiresOn != null) {
            long now = System.currentTimeMillis();
            ls.expiresOn = ISODateTimeFormat.basicDate().parseMillis(ls.licenseContent.expiresOn);
            if (now > ls.expiresOn) {
                ls.expired = true;
                if (now - ls.expiresOn > 604800000L) {
                    ls.valid = false;
                    ls.invalidMessage = "License has expired";
                }
            }
        }
    }

    @Override
    public void failIfLocked() {
        if (!this.getLicensingStatus().valid) {
            throw new SecurityException("License error. Action denied");
        }
    }

    static class CachedSatus {
        long timestamp;
        License license;
        boolean valid;
        String invalidMessage;

        CachedSatus() {
        }
    }
}

