/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.ReadWriteFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import com.dataiku.dip.transactions.fs.imfs.InMemoryDiff;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.CountingOutputStream;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.ProxyOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriteFS
extends ReadWriteFSBase
implements AutoCloseable {
    private static final int BUFFER_SIZE = 0x100000;
    private final InMemoryDiff imfs = new InMemoryDiff();
    private final ZipOutputStream zipOutputStream;
    private RelFile currentFile = null;

    public ZipWriteFS(OutputStream outputStream, int level) {
        super(FileContentFactory.DEFAULT);
        this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream, 0x100000));
        this.zipOutputStream.setLevel(level);
    }

    public ZipWriteFS(OutputStream outputStream) {
        this(outputStream, -1);
    }

    public ZipWriteFS(File outputFile, int level) throws IOException {
        this(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), level);
    }

    @Override
    public List<RelFile> listFilesUnordered(RelFile directory) throws IOException {
        return this.imfs.listFilesUnordered(directory);
    }

    @Override
    public FileContent readContentUnsafe(RelFile file) throws IOException {
        return this.imfs.readContentUnsafe(file);
    }

    @Override
    public RelFileAttribute getAttributes(RelFile file) throws IOException {
        return this.imfs.getAttributes(file);
    }

    @Override
    public boolean deleteFile(RelFile file) throws IOException {
        throw new IOException("File deletion is not supported");
    }

    @Override
    public boolean deleteDirectory(RelFile directory) throws IOException {
        throw new IOException("Directory deletion is not supported");
    }

    @Override
    public boolean makeDirectory(RelFile directory) throws IOException {
        if (this.currentFile != null) {
            throw new IOException("Already writing to " + String.valueOf(this.currentFile));
        }
        for (RelFile currentDirectory : directory.walk()) {
            if (this.imfs.isDirectory(currentDirectory)) continue;
            if (!this.imfs.makeDirectory(currentDirectory)) break;
            ZipEntry directoryEntry = new ZipEntry(currentDirectory.getFullPath() + "/");
            this.zipOutputStream.putNextEntry(directoryEntry);
            this.zipOutputStream.closeEntry();
        }
        return this.imfs.isDirectory(directory);
    }

    @Override
    public void writeContentUnsafeNoMkdir(RelFile file, FileContent content) throws IOException {
        try (RelFileOutputStream os = this.writeStreamNoMkdir(file);
             InputStream is = content.getAsNewStream();){
            IOUtils.copyLarge((InputStream)is, (OutputStream)((Object)os));
        }
    }

    @Override
    public void writeBytes(RelFile file, byte[] bytes) throws IOException {
        if (file.getParent() != null) {
            this.makeDirectory(file.getParent());
        }
        try (RelFileOutputStream os = this.writeStreamNoMkdir(file);){
            ((OutputStream)((Object)os)).write(bytes);
        }
    }

    @Override
    public RelFileOutputStream writeStreamNoMkdir(final RelFile file) throws IOException {
        if (this.currentFile != null) {
            throw new IOException("Already writing to " + String.valueOf(this.currentFile));
        }
        if (file.isRoot() || !this.imfs.isDirectory(file.getParent())) {
            throw new IOException("Parent directory does not exist");
        }
        if (this.imfs.exists(file)) {
            throw new IOException("File already exists");
        }
        ZipEntry directoryEntry = new ZipEntry(file.getFullPath());
        this.zipOutputStream.putNextEntry(directoryEntry);
        this.currentFile = file;
        final CountingOutputStream counting = new CountingOutputStream((OutputStream)this.zipOutputStream);
        ProxyOutputStream proxied = new ProxyOutputStream((OutputStream)counting){
            private boolean closed;
            {
                super(proxy);
                this.closed = false;
            }

            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    ZipWriteFS.this.zipOutputStream.closeEntry();
                    ZipWriteFS.this.currentFile = null;
                    ZipWriteFS.this.imfs.writeContentUnsafeNoMkdir(file, FileContentFactory.DEFAULT.fromUncompressedStreamSupplier(() -> {
                        throw new IOException("Reading data is not supported");
                    }, counting.getByteCount()));
                }
            }
        };
        return new RelFileOutputStream(file, (OutputStream)proxied);
    }

    @Override
    public void close() throws IOException {
        this.zipOutputStream.close();
    }
}

