/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.Git;

public class JGitWrapper {
    public static final String GIT_MINIMUM_VERSION = "v2.12.0";
    protected Git git;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.jgit");

    public JGitWrapper(Git git) {
        this.git = git;
    }

    protected byte[] executeGitCommand(GitModel.GitAuthor author, String ... params) throws IOException, InterruptedException {
        logger.info((Object)("Running in " + String.valueOf(this.git.getRepository().getWorkTree())));
        ArrayList<String> command = new ArrayList<String>();
        command.add("git");
        command.add("-c");
        command.add("commit.gpgsign=false");
        if (DKUApp.getParams().getBoolParam("dku.core.fs.disableSymlinksInGit", true)) {
            command.add("-c");
            command.add("core.symlinks=false");
        }
        if (DKUApp.getParams().getBoolParam("dku.core.fs.disableGitHooks", true)) {
            command.add("-c");
            command.add("core.hooksPath=/dev/null");
        }
        command.addAll(Arrays.asList(params));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.directory(this.git.getRepository().getWorkTree());
        if (StringUtils.isNotBlank((String)author.name)) {
            pb.environment().put("GIT_AUTHOR_NAME", author.name);
            pb.environment().put("GIT_COMMITTER_NAME", author.name);
        }
        if (StringUtils.isNotBlank((String)author.email)) {
            pb.environment().put("GIT_AUTHOR_EMAIL", author.email);
            pb.environment().put("GIT_COMMITTER_EMAIL", author.email);
        }
        return JGitWrapper.execAndGetOutputWithErrorInException(pb, "Git command failed");
    }

    public static byte[] execAndGetOutputWithErrorInException(ProcessBuilder pb, String message) throws IOException, InterruptedException {
        DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ErrorCollectingExecCompletionHandler completionHandler = new DKUtils.ErrorCollectingExecCompletionHandler(message){

            public void handle(int rv) throws IOException {
                if (rv != 0) {
                    String collected = this.baos.toString(StandardCharsets.UTF_8.name());
                    if (collected.contains("unknown option")) {
                        throw new IOException("Current Git version is too old. Please upgrade Git to minimum v2.12.0.");
                    }
                    super.handle(rv);
                }
            }
        };
        return DKUtils.execAndGetOutputWithErrorInException((ProcessBuilder)pb, (DKUtils.ByteCollectingSubscription)outputCollector, (DKUtils.ErrorCollectingExecCompletionHandler)completionHandler);
    }
}

