/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.HashUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.gh.security.model.PersonalPublicAPIKey;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public class EnableHashedApiKeysCommand
extends CLICommandWithInvalidateCommonFilesCache {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.enableHashedApiKeys");

    @Override
    public String usageString() {
        return "enable-hashed-api-keys";
    }

    @Override
    public String description() {
        return "Enables the hashing of API keys and hashes any API keys that are not already hashed";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        this.parseAndMiniSetup(args, this.usageString(), true);
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        GHSpring.doCLISetup();
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (RWTransaction rwt = transactionService.beginWriteAsDSS();){
            String keyBefore;
            Object list;
            boolean didSomething = false;
            GeneralSettingsDAO.GeneralSettings gs = (GeneralSettingsDAO.GeneralSettings)rwt.readObject("general-settings.json", GeneralSettingsDAO.GeneralSettings.class);
            if (!gs.security.hashApiKeys) {
                logger.info((Object)"Enabling hashed public API keys");
                gs.security.hashApiKeys = true;
                rwt.writeObject("general-settings.json", (Object)gs);
                didSomething = true;
            } else {
                logger.info((Object)"Hashed public API keys already enabled");
            }
            logger.info((Object)"Hashing public API keys");
            try {
                RelFile globalFile = RelFile.global((String)"public-apikeys.json");
                if (rwt.exists(globalFile)) {
                    list = (AbstractGlobalScopePublicAPIKey.KeyList)rwt.readObject(globalFile, AbstractGlobalScopePublicAPIKey.KeyList.class);
                    Iterator<Object> iterator = ((ArrayList)list).iterator();
                    while (iterator.hasNext()) {
                        AbstractGlobalScopePublicAPIKey abstractGlobalScopePublicAPIKey = (AbstractGlobalScopePublicAPIKey)((Object)iterator.next());
                        keyBefore = abstractGlobalScopePublicAPIKey.key;
                        abstractGlobalScopePublicAPIKey.key = this.hashIfNotHashed(keyBefore);
                        if (keyBefore == null || keyBefore.equals(abstractGlobalScopePublicAPIKey.key)) continue;
                        didSomething = true;
                    }
                    rwt.writeObject(globalFile, list);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to read and hash global API keys", (Throwable)e);
            }
            try {
                RelFile personalFile = RelFile.global((String)"personal-apikeys.json");
                if (rwt.exists(personalFile)) {
                    list = (PersonalPublicAPIKey.ListFile)rwt.readObject(personalFile, PersonalPublicAPIKey.ListFile.class);
                    for (PersonalPublicAPIKey personalPublicAPIKey : ((PersonalPublicAPIKey.ListFile)list).keys) {
                        keyBefore = personalPublicAPIKey.key;
                        personalPublicAPIKey.key = this.hashIfNotHashed(keyBefore);
                        if (keyBefore == null || keyBefore.equals(personalPublicAPIKey.key)) continue;
                        didSomething = true;
                    }
                    rwt.writeObject(personalFile, list);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to read and hash personal API keys", (Throwable)e);
            }
            if (didSomething) {
                rwt.commit("Hash public API keys");
            }
        }
        logger.info((Object)"Done hashing public API keys");
        return 0;
    }

    private String hashIfNotHashed(String key) {
        if (StringUtils.isNotBlank((String)key) && !key.startsWith("sha256:")) {
            return HashUtils.sha256WithSalt((String)key);
        }
        return key;
    }

    @Override
    protected boolean warnIfCacheInvalidationFails() {
        return false;
    }
}

