/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.import_export.ExportedEntity;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPathStatus;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationService;
import com.dataiku.gh.core.services.migration_paths.IAdminBlueprintVersionMigrationPathsService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminBlueprintVersionMigrationPathController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminBlueprintVersionMigrationPathsService adminBlueprintVersionMigrationPathsService;
    @Autowired
    private IExportedEntityMigrationService importExportMigrationService;

    @AuditedCall(value={"msgType", "admin-blueprint-version-migration-path-get", "migrationPathId", "${blueprintVersionMigrationPathId}"})
    @RequestMapping(value={"/api/admin/blueprint-version-migration-paths/get"}, method={RequestMethod.GET})
    @ResponseBody
    public BlueprintVersionMigrationPath get(HttpServletRequest req, @RequestParam String blueprintVersionMigrationPathId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminBlueprintVersionMigrationPathsService.getBlueprintVersionMigrationPath(authCtx, blueprintVersionMigrationPathId);
    }

    @AuditedCall(value={"msgType", "admin-blueprint-version-migration-paths-list"})
    @RequestMapping(value={"/api/admin/blueprint-version-migration-paths/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BlueprintVersionMigrationPath> list(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminBlueprintVersionMigrationPathsService.listBlueprintVersionMigrationPaths(authCtx);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-version-migration-paths/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_MIGRATION_PATH_CREATE)
    @ResponseBody
    public BlueprintVersionMigrationPath create(HttpServletRequest req, @RequestParam BlueprintVersionMigrationPath blueprintVersionMigrationPath, @RequestParam String newIdentifier) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintVersionMigrationPath createdBlueprintVersionMigrationPath = this.adminBlueprintVersionMigrationPathsService.createBlueprintVersionMigrationPath(authCtx, blueprintVersionMigrationPath, newIdentifier);
            this.auditTrailService.generic("admin-blueprint-version-migration-path-create").with("migrationPathId", createdBlueprintVersionMigrationPath.id).emit();
            return createdBlueprintVersionMigrationPath;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-migration-path-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-version-migration-paths/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_MIGRATION_PATH_SAVE)
    @ResponseBody
    public BlueprintVersionMigrationPath save(HttpServletRequest req, @RequestParam BlueprintVersionMigrationPath blueprintVersionMigrationPath, @RequestParam(required=false) Boolean dangerZoneAccepted) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintVersionMigrationPath updatedBlueprintVersionMigrationPath = this.adminBlueprintVersionMigrationPathsService.saveBlueprintVersionMigrationPath(authCtx, blueprintVersionMigrationPath, Boolean.TRUE.equals(dangerZoneAccepted));
            this.auditTrailService.generic("admin-blueprint-version-migration-path-save").with("migrationPathId", blueprintVersionMigrationPath.id).emit();
            return updatedBlueprintVersionMigrationPath;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-migration-path-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-blueprint-version-migration-path-update-status", "migrationPathId", "${blueprintVersionMigrationPathId}"})
    @RequestMapping(value={"/api/admin/blueprint-version-migration-paths/update-status"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_MIGRATION_PATH_UPDATE_STATUS)
    @ResponseBody
    public BlueprintVersionMigrationPath updateStatus(HttpServletRequest req, @RequestParam String blueprintVersionMigrationPathId, @RequestParam BlueprintVersionMigrationPathStatus migrationPathStatus) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminBlueprintVersionMigrationPathsService.updateBlueprintVersionMigrationPathStatus(authCtx, blueprintVersionMigrationPathId, migrationPathStatus);
    }

    @AuditedCall(value={"msgType", "admin-blueprint-version-migration-path", "migrationPathId", "${blueprintVersionMigrationPathId}"})
    @RequestMapping(value={"/api/admin/blueprint-version-migration-paths/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_MIGRATION_PATH_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @RequestParam String blueprintVersionMigrationPathId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.adminBlueprintVersionMigrationPathsService.deleteBlueprintVersionMigrationPath(authCtx, blueprintVersionMigrationPathId);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-version-migration-paths/import"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_MIGRATION_PATH_IMPORT)
    @ResponseBody
    public BlueprintVersionMigrationPath importMigrationPath(HttpServletRequest req, @RequestParam JsonObject toImport, @RequestParam String blueprintId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintVersionMigrationPath migrationPathExport = this.importExportMigrationService.unwrapAndMigrateExportedEntity(toImport, BlueprintVersionMigrationPath.class);
            BlueprintVersionMigrationPath importedBlueprintVersionMigrationPath = this.adminBlueprintVersionMigrationPathsService.importBlueprintVersionMigrationPath(authCtx, migrationPathExport, blueprintId, BlueprintVersionExport.MigrationPathImportBehavior.FAIL_IMPORT_ON_EXISTING_MIGRATION_OR_MISSING_VERSION);
            this.auditTrailService.generic("admin-blueprint-version-migration-path-import").with("migrationPathId", importedBlueprintVersionMigrationPath.id).emit();
            return importedBlueprintVersionMigrationPath;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-migration-path-import", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-version-migration-paths/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ExportedEntity<BlueprintVersionMigrationPath> exportMigrationPath(HttpServletRequest req, @RequestParam String blueprintVersionMigrationPathId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintVersionMigrationPath blueprintVersionMigrationPath = this.adminBlueprintVersionMigrationPathsService.getBlueprintVersionMigrationPath(authCtx, blueprintVersionMigrationPathId);
            ExportedEntity<BlueprintVersionMigrationPath> export = this.importExportMigrationService.wrapToExportedEntity(blueprintVersionMigrationPath);
            this.auditTrailService.generic("admin-blueprint-version-migration-path-export").with("migrationPathId", blueprintVersionMigrationPathId).emit();
            return export;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-migration-path-export", (Throwable)e).emit();
            throw e;
        }
    }
}

