/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.kernel;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.gh.core.kernel.GHIsolableProcess;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class GHPythonKernel
extends DSSKernelBase {
    private final ResponderKernelLink link = new ResponderKernelLink();
    private final Runnable afterProcessComplete;

    public GHPythonKernel(String id, Runnable afterProcessComplete) throws IOException {
        super(id);
        this.afterProcessComplete = afterProcessComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        ArrayList args = Lists.newArrayList();
        String pythonBin = System.getenv("DKUPYTHONBIN");
        if (pythonBin == null) {
            throw new Error("environment variable DKUPYTHONBIN not defined");
        }
        args.add(new File(pythonBin).getAbsolutePath());
        args.add("-m");
        args.add("govern.javalink.server");
        args.add(String.valueOf(this.link.getPort()));
        args.add(this.link.getSecret());
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().put("PYTHONIOENCODING", "UTF-8");
        pb.environment().put("DKU_GOVERNSERVER_PORT", System.getenv("DKU_GOVERNSERVER_PORT"));
        this.process = new GHIsolableProcess(pb, DKUApp.getBaseFolderF());
        this.process.start();
        this.startStandardTailers();
        this.monitorThread = new DSSKernelBase.KernelMonitorThread(){

            protected void onAfterProcessComplete() {
                GHPythonKernel.this.afterProcessComplete.run();
            }
        };
        this.monitorThread.setCloseOnFailure((Closeable)this.link.getServerSocket());
        try {
            this.monitorThread.start();
            this.link.waitForProcess();
        }
        finally {
            this.monitorThread.setCloseOnFailure(null);
        }
    }

    public <TReq, TResp> TResp execute(TReq command, Class<TResp> clazz) throws IOException {
        return (TResp)this.link.execute(command, clazz);
    }
}

