/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations.utils;

import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.common.collect.Iterators;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationEntitiesUtilsBetweenV13300AndBeyond {
    public static final int BATCH_SIZE = 100;

    public static void fixArtifacts(IDBMigrationDAO dbMigrationDAO, String whereCondition, Function<JsonObject, JsonObject> artifactModifier, long actionId, long migrationTSMilli) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        try (Stream<JsonObject> selectStream = MigrationEntitiesUtilsBetweenV13300AndBeyond.streamObjects(jdbcTemplate, "artifacts", "artifact_json", whereCondition);){
            selectStream.forEach(artifact -> MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "artifacts", "artifact_json", JSON.json(artifactModifier.apply((JsonObject)artifact)), "artifact_id=?", Collections.singletonList(artifact.get("id").getAsString()), "artifacts_history", "ARTIFACT", migrationTSMilli));
        }
    }

    public static Stream<JsonObject> streamObjects(JdbcTemplate jdbcTemplate, String table, String jsonColumn, @Nullable String whereCond) throws IOException {
        String sqlSelectAll = String.format("SELECT %s FROM %s WHERE %s", jsonColumn, table, ObjectUtils.defaultIfNull((Object)whereCond, (Object)"1=1"));
        try {
            return jdbcTemplate.queryForStream(sqlSelectAll, (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString(jsonColumn), JsonObject.class));
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    public static void migrateObjectsStructure(JdbcTemplate jdbcTemplate, String table, String idExpr, String jsonColumn, @Nullable String whereExpr, @Nullable String orderByExpr, Function<JsonObject, List<String>> idExprArgsGetterAfterModification, Function<JsonObject, JsonObject> objectModifier) throws IOException {
        String builtWhereExpr = whereExpr == null ? "1=1" : whereExpr;
        Object builtOrderByExpr = orderByExpr == null ? "" : "ORDER BY " + orderByExpr;
        String sqlSelectAll = String.format("SELECT %s FROM %s WHERE %s %s FOR UPDATE", jsonColumn, table, builtWhereExpr, builtOrderByExpr);
        String sqlUpdate = String.format("UPDATE %s SET %s = (?)::jsonb WHERE %s", table, jsonColumn, idExpr);
        try (Stream selectStream = jdbcTemplate.queryForStream(sqlSelectAll, (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString(jsonColumn), JsonObject.class));){
            Iterator selectIterator = selectStream.map(objectModifier).iterator();
            Iterators.partition(selectIterator, (int)100).forEachRemaining(listToUpdate -> jdbcTemplate.batchUpdate(sqlUpdate, (Collection)listToUpdate, 100, (ps, toUpdate) -> {
                ps.setString(1, JSON.json((Object)toUpdate));
                List idExprArgs = (List)idExprArgsGetterAfterModification.apply((JsonObject)toUpdate);
                for (int i = 0; i < idExprArgs.size(); ++i) {
                    ps.setString(2 + i, (String)idExprArgs.get(i));
                }
            }));
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    public static void migrateObjectsStructureHistoryAtTimestamp(JdbcTemplate jdbcTemplate, String historyTable, String jsonColumn, @Nullable String whereExpr, Function<JSONObjectAtTimestamp, JsonObject> objectModifier) throws IOException {
        String builtWhereExpr = whereExpr == null ? "1=1" : whereExpr;
        String sqlSelectAllHistory = String.format("SELECT _revision_id, _revision_timestamp, %s FROM %s WHERE %s FOR UPDATE", jsonColumn, historyTable, builtWhereExpr);
        String sqlUpdateHistory = String.format("UPDATE %s SET %s = (?)::jsonb WHERE _revision_id = (?)", historyTable, jsonColumn);
        try (Stream selectStream = jdbcTemplate.queryForStream(sqlSelectAllHistory, (rs, rowNum) -> Pair.of((Object)rs.getLong("_revision_id"), (Object)JSONObjectAtTimestamp.build((JsonObject)JSON.parse((String)rs.getString(jsonColumn), JsonObject.class), rs.getTimestamp("_revision_timestamp"))));){
            Iterator selectIterator = selectStream.map(p -> Pair.of((Object)((Long)p.getLeft()), (Object)((JsonObject)objectModifier.apply((JSONObjectAtTimestamp)p.getRight())))).iterator();
            Iterators.partition(selectIterator, (int)100).forEachRemaining(listToUpdate -> jdbcTemplate.batchUpdate(sqlUpdateHistory, (Collection)listToUpdate, 100, (ps, toUpdate) -> {
                ps.setString(1, JSON.json((Object)toUpdate.getRight()));
                ps.setLong(2, (Long)toUpdate.getLeft());
            }));
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    public static void upsertBlueprint(JdbcTemplate jdbcTemplate, File file, String blueprintId, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "blueprints", "blueprint_json", JSON.json((Object)MigrationEntitiesUtilsBetweenV13300AndBeyond.loadBlueprint(file, blueprintId)), "blueprint_id=?", Collections.singletonList(blueprintId), "blueprints_history", "BLUEPRINT", migrationTSMilli);
    }

    private static JsonObject loadBlueprint(File file, String blueprintId) throws IOException {
        JsonObject obj = MigrationEntitiesUtilsBetweenV13300AndBeyond.loadJsonFromFile(file);
        obj.addProperty("id", blueprintId);
        return obj;
    }

    public static void upsertBlueprintRoleAssignments(JdbcTemplate jdbcTemplate, File file, String blueprintId, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintRoleAssignments(jdbcTemplate, MigrationEntitiesUtilsBetweenV13300AndBeyond.loadBlueprintRoleAssignments(file, blueprintId), blueprintId, actionId, migrationTSMilli);
    }

    public static void upsertBlueprintRoleAssignments(JdbcTemplate jdbcTemplate, JsonObject obj, String blueprintId, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "blueprint_role_assignments", "blueprint_role_assignments_json", JSON.json((Object)obj), "blueprint_role_assignments_blueprint_id=?", Collections.singletonList(blueprintId), "blueprint_role_assignments_history", "BLUEPRINT_ROLE_ASSIGNMENTS", migrationTSMilli);
    }

    private static JsonObject loadBlueprintRoleAssignments(File file, String blueprintId) throws IOException {
        JsonObject obj = MigrationEntitiesUtilsBetweenV13300AndBeyond.loadJsonFromFile(file);
        obj.addProperty("blueprintId", blueprintId);
        return obj;
    }

    public static void upsertBlueprintPermissions(JdbcTemplate jdbcTemplate, File file, String blueprintId, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintPermissions(jdbcTemplate, MigrationEntitiesUtilsBetweenV13300AndBeyond.loadJsonFromFile(file), blueprintId, actionId, migrationTSMilli);
    }

    public static void upsertBlueprintPermissions(JdbcTemplate jdbcTemplate, JsonObject obj, String blueprintId, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "blueprint_permissions", "blueprint_permissions_json", JSON.json((Object)MigrationEntitiesUtilsBetweenV13300AndBeyond.addBlueprintIdToBlueprintRolePermissions(obj, blueprintId)), "blueprint_permissions_blueprint_id=?", Collections.singletonList(blueprintId), "blueprint_permissions_history", "BLUEPRINT_PERMISSIONS", migrationTSMilli);
    }

    private static JsonObject addBlueprintIdToBlueprintRolePermissions(JsonObject obj, String blueprintId) throws IOException {
        obj.addProperty("blueprintId", blueprintId);
        return obj;
    }

    public static void upsertCustomPage(JdbcTemplate jdbcTemplate, File file, long actionId, long migrationTSMilli) throws IOException {
        JsonObject cp = MigrationEntitiesUtilsBetweenV13300AndBeyond.loadJsonFromFile(file);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "custom_pages", "custom_page_json", JSON.json((Object)cp), "custom_page_id=?", Collections.singletonList(cp.get("id").getAsString()), "custom_pages_history", "CUSTOM_PAGE", migrationTSMilli);
    }

    public static void upsertGovernConfiguration(JdbcTemplate jdbcTemplate, JsonObject configuration, long actionId, long migrationTSMilli) throws IOException {
        String revisionType;
        String confId = configuration.get("type").getAsString();
        String jsonConfiguration = JSON.json((Object)configuration);
        if (MigrationEntitiesUtilsBetweenV13300AndBeyond.entityExists(jdbcTemplate, "SELECT 1 FROM govern_configuration WHERE configuration_item_id=?", confId)) {
            jdbcTemplate.update("UPDATE govern_configuration SET configuration_item_json=(?::jsonb) WHERE configuration_item_id=?", new Object[]{jsonConfiguration, confId});
            revisionType = "UPDATE";
        } else {
            jdbcTemplate.update("INSERT INTO govern_configuration(configuration_item_json) VALUES(?::jsonb)", new Object[]{jsonConfiguration});
            revisionType = "ADD";
        }
        jdbcTemplate.update("INSERT INTO govern_configuration_history(_revision_json, configuration_item_json) VALUES(?::jsonb, ?::jsonb)", new Object[]{MigrationEntitiesUtilsBetweenV13300AndBeyond.buildRevisionObject(jdbcTemplate, actionId, revisionType, "GOVERN_CONFIGURATION", migrationTSMilli), jsonConfiguration});
    }

    public static void genericUpsert(JdbcTemplate jdbcTemplate, long actionId, String table, String jsonCol, String jsonStr, String cond, List<Object> condArgs, String historyTable, String entityType, long migrationTSMilli) {
        String revisionType;
        if (MigrationEntitiesUtilsBetweenV13300AndBeyond.entityExists(jdbcTemplate, String.format("SELECT 1 FROM %s WHERE %s", table, cond), condArgs.toArray())) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(jsonStr);
            args.addAll(condArgs);
            jdbcTemplate.update(String.format("UPDATE %s SET %s=(?::jsonb) WHERE %s", table, jsonCol, cond), args.toArray());
            revisionType = "UPDATE";
        } else {
            jdbcTemplate.update(String.format("INSERT INTO %s(%s) VALUES(?::jsonb)", table, jsonCol), new Object[]{jsonStr});
            revisionType = "ADD";
        }
        jdbcTemplate.update(String.format("INSERT INTO %s(_revision_json, %s) VALUES(?::jsonb, ?::jsonb)", historyTable, jsonCol), new Object[]{MigrationEntitiesUtilsBetweenV13300AndBeyond.buildRevisionObject(jdbcTemplate, actionId, revisionType, entityType, migrationTSMilli), jsonStr});
    }

    public static void genericDelete(JdbcTemplate jdbcTemplate, long actionId, String table, String jsonCol, String cond, List<Object> condArgs, String historyTable, String entityType, long migrationTSMilli) {
        List<JsonObject> entities = MigrationEntitiesUtilsBetweenV13300AndBeyond.genericGetEntity(jdbcTemplate, table, jsonCol, cond, condArgs);
        if (CollectionUtils.isNotEmpty(entities)) {
            for (JsonObject entity : entities) {
                if (entity == null) continue;
                jdbcTemplate.update(String.format("INSERT INTO %s(_revision_json, %s) VALUES(?::jsonb, ?::jsonb)", historyTable, jsonCol), new Object[]{MigrationEntitiesUtilsBetweenV13300AndBeyond.buildRevisionObject(jdbcTemplate, actionId, "DELETE", entityType, migrationTSMilli), JSON.json((Object)entity)});
            }
            jdbcTemplate.update(String.format("DELETE FROM %s WHERE %s", table, cond), condArgs.toArray());
        }
    }

    public static List<JsonObject> genericGetEntity(JdbcTemplate jdbcTemplate, String table, String jsonCol, String cond, List<Object> condArgs) {
        return jdbcTemplate.query(String.format("SELECT %s FROM %s WHERE %s", jsonCol, table, cond), (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString(jsonCol), JsonObject.class), condArgs.toArray());
    }

    public static void upsertBlueprintVersion(JdbcTemplate jdbcTemplate, File file, String blueprintId, String versionId, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, MigrationEntitiesUtilsBetweenV13300AndBeyond.loadBlueprintVersion(file, blueprintId, versionId), blueprintId, versionId, actionId, migrationTSMilli);
    }

    public static void upsertBlueprintVersion(JdbcTemplate jdbcTemplate, JsonObject bpv, String blueprintId, String versionId, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "blueprint_versions", "blueprint_version_json", JSON.json((Object)bpv), "blueprint_version_blueprint_id=? and blueprint_version_version_id=?", Arrays.asList(blueprintId, versionId), "blueprint_versions_history", "BLUEPRINT_VERSION", migrationTSMilli);
        JsonObject jsonTrace = new JSON.JsonBuilder().kv("blueprintVersionId", (Object)bpv.getAsJsonObject("id")).kv("status", (Object)"ACTIVE").kv("originVersionId", null).get();
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersionTrace(jdbcTemplate, jsonTrace, blueprintId, versionId, actionId, migrationTSMilli);
    }

    public static String buildRevisionObject(JdbcTemplate jdbcTemplate, long actionId, String revisionType, String entityType, long migrationTSMilli) {
        Long revisionId = (Long)jdbcTemplate.queryForObject("SELECT nextval('history_revisions_seq')", Long.class);
        JsonObject revisionObject = new JSON.JsonBuilder().kv("id", (Object)revisionId).kv("actionId", (Object)actionId).kv("user", null).kv("timestamp", (Object)migrationTSMilli).kv("operation", (Object)revisionType).kv("entityType", (Object)entityType).get();
        return JSON.json((Object)revisionObject);
    }

    public static Long createMigrationAction(JdbcTemplate jdbcTemplate, long timestampMS) throws IOException {
        return MigrationEntitiesUtilsBetweenV13300AndBeyond.createMigrationAction_Internal(jdbcTemplate, "INTERNAL_MIGRATION", timestampMS);
    }

    private static Long createMigrationAction_Internal(JdbcTemplate jdbcTemplate, String migrationType, long timestampMS) throws IOException {
        Long actionId = (Long)jdbcTemplate.queryForObject("SELECT nextval('history_actions_seq')", Long.class);
        JsonObject jsonAction = new JSON.JsonBuilder().kv("user", null).kv("id", (Object)actionId).kv("type", (Object)migrationType).kv("timestamp", (Object)timestampMS).get();
        jdbcTemplate.update("INSERT INTO history_actions (history_action_json) VALUES (?::jsonb)", new Object[]{JSON.json((Object)jsonAction)});
        return actionId;
    }

    private static boolean entityExists(JdbcTemplate jdbcTemplate, String sql, Object ... args) {
        List exists = jdbcTemplate.queryForList(sql, Object.class, args);
        return CollectionUtils.isNotEmpty((Collection)exists);
    }

    private static JsonObject loadBlueprintVersion(File file, String blueprintId, String versionId) throws IOException {
        JsonObject obj = MigrationEntitiesUtilsBetweenV13300AndBeyond.loadJsonFromFile(file);
        obj.add("id", (JsonElement)new JSON.JsonBuilder().kv("blueprintId", (Object)blueprintId).kv("versionId", (Object)versionId).get());
        return obj;
    }

    public static JsonObject loadJsonFromFile(File file) throws IOException {
        return (JsonObject)JSON.parse((String)MigrationEntitiesUtilsBetweenV13300AndBeyond.readFile(file), JsonObject.class);
    }

    private static String readFile(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()));
    }

    private static void upsertBlueprintVersionTrace(JdbcTemplate jdbcTemplate, JsonObject jsonTrace, String blueprintId, String versionId, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "blueprint_version_traces", "blueprint_version_trace_json", JSON.json((Object)jsonTrace), "blueprint_version_trace_blueprint_id=? and blueprint_version_trace_version_id=?", Arrays.asList(blueprintId, versionId), "blueprint_version_traces_history", "BLUEPRINT_VERSION_TRACE", migrationTSMilli);
    }

    @Nullable
    public static JsonObject getArtifact(JdbcTemplate jdbcTemplate, String artifactId) throws IOException {
        List<JsonObject> found = MigrationEntitiesUtilsBetweenV13300AndBeyond.genericGetEntity(jdbcTemplate, "artifacts", "artifact_json", "artifact_id=?", Arrays.asList(artifactId));
        return CollectionUtils.size(found) >= 1 ? found.get(0) : null;
    }

    public static JsonObject buildNewArtifact(JdbcTemplate jdbcTemplate, String bpId, String bpvId, String name) {
        Long newId = (Long)jdbcTemplate.queryForObject("SELECT nextval('artifacts_seq')", Long.class);
        String artifactId = "ar." + newId;
        return MigrationEntitiesUtilsBetweenV13300AndBeyond.buildNewArtifact(artifactId, bpId, bpvId, name);
    }

    public static JsonObject buildNewArtifact(String artifactId, String bpId, String bpvId, String name) {
        return new JSON.JsonBuilder().kv("id", (Object)artifactId).kv("name", (Object)name).kv("blueprintVersionId", (Object)new JSON.JsonBuilder().kv("blueprintId", (Object)bpId).kv("versionId", (Object)bpvId).get()).kv("fields", (Object)new JsonObject()).kv("status", (Object)new JSON.JsonBuilder().kv("archived", (Object)false).get()).kv("workflow", (Object)new JSON.JsonBuilder().kv("steps", (Object)new JsonObject()).get()).kv("attachments", (Object)new JSON.JsonBuilder().kv("files", (Object)new JsonArray()).kv("references", (Object)new JsonArray()).get()).get();
    }

    public static void upsertArtifact(JdbcTemplate jdbcTemplate, JsonObject artifact, long actionId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "artifacts", "artifact_json", JSON.json((Object)artifact), "artifact_id=?", Collections.singletonList(artifact.get("id").getAsString()), "artifacts_history", "ARTIFACT", migrationTSMilli);
    }

    public static void upsertPlainFieldReference(JdbcTemplate jdbcTemplate, JsonObject reference, long actionId, long migrationTSMilli) throws IOException {
        String artifactIdFrom = reference.get("artifactIdFrom").getAsString();
        String fieldId = reference.getAsJsonObject("relationshipData").get("fieldId").getAsString();
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "reference_relationships", "reference_relationship_json", JSON.json((Object)reference), "reference_relationship_artifact_id_from = ? AND reference_relationship_json -> 'relationshipData' ->> 'type' = 'field' AND reference_relationship_json -> 'relationshipData' -> 'details' ->> 'type' = 'plain' AND reference_relationship_json -> 'relationshipData' ->> 'fieldId' = ?", Arrays.asList(artifactIdFrom, fieldId), "reference_relationships_history", "REFERENCE_RELATIONSHIP", migrationTSMilli);
    }

    public static void deletePlainFieldReference(JdbcTemplate jdbcTemplate, long actionId, String artifactIdFrom, String fieldId, long migrationTSMilli) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericDelete(jdbcTemplate, actionId, "reference_relationships", "reference_relationship_json", "reference_relationship_artifact_id_from=? AND reference_relationship_json -> 'relationshipData' ->> 'type'='field' AND reference_relationship_json -> 'relationshipData' -> 'details' ->> 'type' = 'plain' AND reference_relationship_json -> 'relationshipData' ->> 'fieldId'=? ", Arrays.asList(artifactIdFrom, fieldId), "reference_relationships_history", "REFERENCE_RELATIONSHIP", migrationTSMilli);
    }

    public static List<JsonObject> getArtifactReferencesForField(JdbcTemplate jdbcTemplate, String artifactId, String fieldId) throws IOException {
        String query = "SELECT reference_relationship_json FROM reference_relationships WHERE reference_relationship_artifact_id_from=? AND reference_relationship_json -> 'relationshipData' ->> 'type'='field' AND reference_relationship_json -> 'relationshipData' ->> 'fieldId'=? ";
        return jdbcTemplate.query(query, (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("reference_relationship_json"), JsonObject.class), new Object[]{artifactId, fieldId});
    }

    public static JsonObject buildNewPlainFieldReference(String artifactFrom, String artifactTo, String fieldId) {
        return new JSON.JsonBuilder().kv("artifactIdFrom", (Object)artifactFrom).kv("artifactIdTo", (Object)artifactTo).kv("relationshipData", (Object)new JSON.JsonBuilder().kv("type", (Object)"field").kv("fieldId", (Object)fieldId).kv("details", (Object)new JSON.JsonBuilder().kv("type", (Object)"plain").get()).get()).get();
    }

    public static class JSONObjectAtTimestamp {
        public JsonObject jsonObject;
        public Timestamp timestamp;

        public static JSONObjectAtTimestamp build(JsonObject jsonObject, Timestamp timestamp) {
            JSONObjectAtTimestamp jsonObjectAtTimestamp = new JSONObjectAtTimestamp();
            jsonObjectAtTimestamp.jsonObject = jsonObject;
            jsonObjectAtTimestamp.timestamp = timestamp;
            return jsonObjectAtTimestamp;
        }
    }
}

