/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.utils;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.services.utils.BlueprintVersionsDependencyGraph;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class BlueprintVersionsDependencySortHelper {
    public static List<BlueprintVersionExport> sortBlueprintVersionsWithOriginVersion(List<BlueprintVersionExport> blueprintVersionsWithOriginVersionId) {
        BlueprintVersionsDependencyGraph graph = BlueprintVersionsDependencyGraph.build(blueprintVersionsWithOriginVersionId);
        return Arrays.stream(BlueprintVersionsDependencySortHelper.sortBlueprintVersionNodes(graph.getBlueprintVersionNodesMap().values())).map(BlueprintVersionsDependencyGraph.BlueprintVersionNode::getBlueprintVersionWithOriginVersion).collect(Collectors.toList());
    }

    private static BlueprintVersionsDependencyGraph.BlueprintVersionNode[] sortBlueprintVersionNodes(Collection<BlueprintVersionsDependencyGraph.BlueprintVersionNode> blueprintVersionNodes) {
        BlueprintVersionsDependencyGraph.BlueprintVersionNode[] sortedBlueprintVersionNodes = new BlueprintVersionsDependencyGraph.BlueprintVersionNode[blueprintVersionNodes.size()];
        int arrayLength = BlueprintVersionsDependencySortHelper.addNonDependentBlueprintVersions(sortedBlueprintVersionNodes, blueprintVersionNodes, 0);
        for (int i = 0; i < sortedBlueprintVersionNodes.length; ++i) {
            BlueprintVersionsDependencyGraph.BlueprintVersionNode currentBlueprintVersionNode = sortedBlueprintVersionNodes[i];
            if (currentBlueprintVersionNode == null) {
                throw new ValidationException("Invalid blueprint versions: cycle of dependency made by the originVersionIds");
            }
            Collection<BlueprintVersionsDependencyGraph.BlueprintVersionNode> dependantNodes = currentBlueprintVersionNode.getDependantNodes();
            for (BlueprintVersionsDependencyGraph.BlueprintVersionNode node : dependantNodes) {
                node.decrementDependencies();
            }
            arrayLength = BlueprintVersionsDependencySortHelper.addNonDependentBlueprintVersions(sortedBlueprintVersionNodes, dependantNodes, arrayLength);
        }
        return sortedBlueprintVersionNodes;
    }

    private static int addNonDependentBlueprintVersions(BlueprintVersionsDependencyGraph.BlueprintVersionNode[] order, Collection<BlueprintVersionsDependencyGraph.BlueprintVersionNode> blueprintVersionNodes, int arrayLength) {
        for (BlueprintVersionsDependencyGraph.BlueprintVersionNode blueprintVersionNode : blueprintVersionNodes) {
            if (blueprintVersionNode.getDependencies() != 0) continue;
            order[arrayLength] = blueprintVersionNode;
            ++arrayLength;
        }
        return arrayLength;
    }
}

