/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.admin;

import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QGovernSchemaVersion;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DBMigrationDAO
extends AbstractPostgreSQLClient
implements IDBMigrationDAO {
    public static final int BATCH_SIZE = 100;

    @Override
    @GHReadonlyTransaction
    public String getDatabaseVersion() throws IOException {
        try {
            return (String)this.querydslJdbcTemplate.queryForObject("SELECT version();", String.class);
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    @Override
    @GHReadonlyTransaction
    @Nullable
    public Long getSchemaVersion() throws IOException {
        try {
            List tableNames = this.querydslJdbcTemplate.queryForList("SELECT table_name FROM information_schema.tables WHERE table_name = ? AND table_schema = (SELECT CURRENT_SCHEMA)", new Object[]{QGovernSchemaVersion.governSchemaVersion.getTableName()});
            if (CollectionUtils.isEmpty((Collection)tableNames)) {
                return null;
            }
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QGovernSchemaVersion.governSchemaVersion.version).from((Expression)QGovernSchemaVersion.governSchemaVersion)).orderBy(QGovernSchemaVersion.governSchemaVersion.version.desc())).limit(1L);
            List versions = this.querydslJdbcTemplate.queryForStream(query, (rs, rowNum) -> rs.getLong(ColumnMetadata.getName(QGovernSchemaVersion.governSchemaVersion.version))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(versions) || versions.size() != 1) {
                throw new RuntimeException("Unexpected govern schema version in DB");
            }
            return (Long)versions.get(0);
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    @Override
    @GHWriteTransaction
    public void setSchemaVersion(long version) throws IOException {
        try {
            SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QGovernSchemaVersion.governSchemaVersion).columns(new Path[]{QGovernSchemaVersion.governSchemaVersion.version})).values(new Object[]{version});
            this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    @Override
    @GHWriteTransaction
    public void runMigration(MigrationFile migrationFile) throws IOException {
        try {
            String sql = new String(Files.readAllBytes(migrationFile.file.toPath()));
            this.querydslJdbcTemplate.execute(sql);
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.querydslJdbcTemplate;
    }

    @Override
    @GHWriteTransaction
    public void executeAnalyze() throws IOException {
        try {
            this.querydslJdbcTemplate.execute("ANALYZE");
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }
}

