/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.api.auth;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.APIAuthUtils;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.security.PermissionsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPIAuthCtxController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private UIAuthService uiAuthService;
    @Autowired
    private TicketAuthService ticketAuthService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PermissionsService permissionsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.publicapi.auth");

    @AuditInline
    @RequestMapping(value={"/publicapi/auth/info"}, method={RequestMethod.GET})
    public void getAuthInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean withSecrets) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getTicketOrKey(req);
            }
            AuthCtxInfo info = this.infoFromAuthCtx_NT(authCtx, withSecrets);
            AuditContextBase.setAuthContext((AuthCtx)authCtx);
            this.auditTrailService.generic("security-get-auth-info").emit();
            PublicAPIAuthCtxController.writeJSON((HttpServletResponse)resp, (Object)info);
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-get-auth-info", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/auth/info-from-browser"}, method={RequestMethod.GET})
    public void getAuthInfoFromBrowser(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean withSecrets, @RequestParam(required=false) String callOrigin, @RequestParam(required=false, defaultValue="false") boolean withXSRFCheck) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = withXSRFCheck ? this.uiAuthService.getMandatoryUser(req) : this.uiAuthService.getMandatoryUserNoXSRF(req);
            }
            AuthCtxInfo info = this.infoFromAuthCtx_NT(authCtx, withSecrets);
            AuditContextBase.setAuthContext((AuthCtx)authCtx);
            this.auditTrailService.generic("security-get-auth-info").with("callOrigin", callOrigin).emit();
            PublicAPIAuthCtxController.writeJSON((HttpServletResponse)resp, (Object)info);
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-get-auth-info", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/auth/info-from-browser-headers"}, method={RequestMethod.POST})
    public void getAuthInfoFromBrowserHeaders(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean withSecrets, @RequestParam(required=false) String callOrigin) throws Exception {
        try {
            AuthCtx authCtx;
            JsonObject parsedHeaders = this.getParsedHeadersFromHeadersBody(req);
            if (parsedHeaders.has("authorization")) {
                String apiKey = APIAuthUtils.getKeyStr((JsonObject)parsedHeaders);
                try (Transaction t = this.transactionService.beginRead();){
                    PublicAPIKey key = this.publicAPIKeysService.getKey(apiKey);
                    if (key == null) {
                        throw new NotAuthenticatedException("No matching auth found", "get-auth-info-bad-auth");
                    }
                    authCtx = GHAuthCtx.forAPIKey(key);
                }
            }
            if (parsedHeaders.has("x-dku-apiticket")) {
                authCtx = this.apiTicketService.getTicketAuthCtx(parsedHeaders.get("x-dku-apiticket").getAsString());
                if (authCtx == null) {
                    throw new NotAuthenticatedException("No matching auth found", "get-auth-info-bad-auth");
                }
            } else {
                Map<String, String> parsedCookies = this.getParsedCookiesFromParsedHeaders(parsedHeaders);
                try {
                    authCtx = this.getAuthCtxFromAccessCookies(parsedCookies);
                }
                catch (NotAuthenticatedException e) {
                    authCtx = this.getAuthCtxFromIdentityCookies(parsedCookies);
                    if (withSecrets) {
                        logger.warn((Object)"Tried to get info-from-browser-headers with secrets, but only have an identity token, not sending secrets");
                    }
                    withSecrets = false;
                }
            }
            AuthCtxInfo info = this.infoFromAuthCtx_NT(authCtx, withSecrets);
            AuditContextBase.setAuthContext((AuthCtx)authCtx);
            this.auditTrailService.generic("security-get-auth-info").with("callOrigin", callOrigin).emit();
            PublicAPIAuthCtxController.writeJSON((HttpServletResponse)resp, (Object)info);
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-get-auth-info", (Throwable)e).emit();
            throw e;
        }
    }

    private JsonObject getParsedHeadersFromHeadersBody(HttpServletRequest req) throws IOException {
        JsonObject obj = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry e : obj.entrySet()) {
            keys.add((String)e.getKey());
        }
        for (String key : keys) {
            obj.add(key.toLowerCase(Locale.ENGLISH), obj.get(key));
        }
        return obj;
    }

    private Map<String, String> getParsedCookiesFromParsedHeaders(JsonObject parsedHeaders) throws IOException {
        JsonElement setCookieElt = parsedHeaders.get("cookie");
        Map<String, String> parsedCookies = new HashMap<String, String>();
        if (setCookieElt != null) {
            parsedCookies = ServletUtils.parseCookies((String)setCookieElt.getAsString());
        }
        return parsedCookies;
    }

    private AuthCtx getAuthCtxFromAccessCookies(Map<String, String> parsedCookies) throws IOException, NotAuthenticatedException, UnauthorizedException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getUserInternal(parsedCookies, null, null, false, false);
        }
        if (authCtx == null) {
            throw new NotAuthenticatedException("Not authenticated", "get-auth-info-no-auth");
        }
        return authCtx;
    }

    private AuthCtx getAuthCtxFromIdentityCookies(Map<String, String> parsedCookies) throws IOException, NotAuthenticatedException, UnauthorizedException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.uiAuthService.getUserFromIdentityInternal(parsedCookies, null, false);
        }
        if (authCtx == null) {
            throw new NotAuthenticatedException("Not authenticated", "get-auth-info-no-auth");
        }
        return authCtx;
    }

    private AuthCtxInfo infoFromAuthCtx_NT(AuthCtx authCtx, boolean withSecrets) throws DKUSecurityException {
        AuthCtxInfo info = new AuthCtxInfo();
        info.authSource = authCtx.getAuthSource();
        info.via = authCtx.getVia();
        info.authIdentifier = authCtx.getIdentifier();
        if (authCtx.isGroupsAware()) {
            info.groups = authCtx.getGroups();
        }
        info.userProfile = authCtx.getUserProfile();
        info.associatedDSSUser = authCtx.getAssociatedDSSUser();
        if (authCtx.getAuthSource() != AuthCtx.AuthSource.NONE) {
            info.userForImpersonation = authCtx.getDSSUserForImpersonation();
        }
        return info;
    }

    static class AuthCtxInfo {
        AuthCtx.AuthSource authSource;
        List<String> via;
        String authIdentifier;
        Collection<String> groups;
        String userProfile;
        String associatedDSSUser;
        String userForImpersonation;
        List<SimpleKeyValue> secrets;

        AuthCtxInfo() {
        }
    }
}

