(function(){
    'use strict';

    const dssObjectLink = {
        bindings: {
            item: '<',
            moveToTargetProject: '<',
            hook: '<',
            showLocation: '<',
            reload: '=',
            options: '<',
        },
        templateUrl : 'static/dataiku/shared/components/dss-object-link/dss-object-link.component.html',
        controller: function (StateUtils, $scope, $state, SmartId, TAGGABLE_TYPES, $stateParams, $sanitize, $filter, MLUtilsService) {
            this.$onInit = () => {
                if (this.reload) {
                    this.objectSref = item => this.refFunction(item, StateUtils.uiSref);
                } else {
                    this.objectLink = item => this.refFunction(item, StateUtils.href);
                }
            }

            this.isExternalLink = () => false;
            this.isLinkableDssObject = item => item && (TAGGABLE_TYPES.includes(item.objectType) || item.objectType == "APP" || item.objectType == "PLUGIN" || item.isInstalledCodeEnv);
            this.isTensorboardFuture = item => item && item.objectType === 'WEB_APP' && item.objectId.startsWith('TENSORBOARD_');
            this.getSubTypeFromItem = item => item.details.datasetType || item.details.streamingType || item.details.recipeType || item.details.webappType || item.details.insightType || item.details.mesFlavor || item.details.modelTaskType;
            this.getIconClass = (item) => {
                let subtype;
                if (item.objectType === 'SAVED_MODEL') {
                    // In some cases the `savedModelMlCategory` is populated from the backend. This is because we didn't want to pollute some resources with
                    // ML types information (`ExposedObject` and `SmartObjectRef` notably).
                    if (item.details && item.details.savedModelMLCategory) {
                        subtype = item.details.savedModelMLCategory;
                    } else {
                        subtype = item && item.details && MLUtilsService.getMLCategory(item.details.taskType, item.details.backendType, item.details.predictionType, item.details.savedModelType, item.details.proxyModelProtocol || item.details.externalSavedModelType);
                    }
                } else {
                    subtype = item && item.details && (this.getSubTypeFromItem(item));
                }
                return $filter("toModernIcon")($filter("subTypeToIcon")(subtype, item.objectType, 16), 16);
            };
            this.getColorClass = (item) => {
                if (item && item.objectType === 'SAVED_MODEL' && item.details) {
                    if (item.details.savedModelMLCategory) {
                        return $filter("savedModelMLCategoryToClassColor")(item.details.savedModelMLCategory, true);
                    } else {
                        return $filter("savedModelTypeToClassColor")(item.details.savedModelType, true);
                    }
                }
                return item && item.details && $filter("subTypeToColor")(this.getSubTypeFromItem(item), item.objectType);
            }

            this.$onChanges = (changes) => {
                if (changes && changes.hook && changes.hook.currentValue) {
                    this.isLinkableDssObject = this.hook.isLinkableDssObject(this.isLinkableDssObject);
                    this.isExternalLink = this.hook.isExternalLink(this.isExternalLink);
                    if (this.reload) {
                        this.objectSref = this.hook.objectLink(this.objectSref);
                    } else {
                        this.objectLink = this.hook.objectLink(this.objectLink);
                    }
                }
            }

            this.refFunction = (item, util) => {
                if (!item) return;
                if (item.objectType == "PLUGIN") {
                    if (item.pluginsList) {
                        for (let i = 0; i < item.pluginsList.plugins.length; i++) {
                            let plugin = item.pluginsList.plugins[i];
                            if (plugin.id===item.objectId && plugin.installed) {
                                let updateAvailable = plugin.storeDesc && plugin.storeDesc.storeVersion > plugin.installedDesc.desc.version;
                                return updateAvailable ? util.pluginStore(item.objectId) : util.pluginSummary(item.objectId);
                                }
                            }
                        return util.pluginStore(item.objectId);
                    } else {
                        return util.pluginStore(item.objectId);
                    }
                } else if (item.objectType === "CODE_ENV") {
                    return util.codeEnvEdit(item.targetName || item.objectId, item.envLang);
                }
                if (item.workspaceKey) {
                    if (item.projectKey) {
                        return util.workspaceObject(item.workspaceKey, item.projectKey, item.objectType, item.objectId, { discussionId: item.discussionId });
                    }
                    return util.workspace(item.workspaceKey, { discussionId: item.discussionId });
                }
                return util.dssObject(item.objectType, SmartId.fromRef(item, $stateParams.projectKey), null, {moveToTargetProject: this.moveToTargetProject, discussionId: item.discussionId,
                    subType: item.subType || this.getSubTypeFromItem(item), ...this.options});
            }

            this.itemDisplayName = (item) => {
                const name = item && ((item.details && $sanitize(item.details.objectDisplayName)) || $sanitize(item.name || item.objectId))
                return $filter('unescapeHtml')(name);
            }
        }
    }

    angular.module('dataiku.shared').component('dssObjectLink', dssObjectLink);
})();
