/* global describe, it, beforeEach, ChartFeaturesTestUtils */

describe('chart features multi_columns_lines', function () {

    const chartType = 'multi_columns_lines';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        ChartFeaturesTestUtils.setAxisSpecs(chartType);
    });

    it('has left menu filters dropzone', function () {
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');
    })

    it('doesn\'t have regression line options', function () {
        renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
        expectIdToBeHidden('qa_charts_regression-line-form');
    })

});
