from dataiku.project_standards import (
    ProjectStandardsCheckRunResult,
    ProjectStandardsCheckSpec,
)


class TestScenarioCheckSpec(ProjectStandardsCheckSpec):

    def run(self):
        scenarios = self.project.list_scenarios()
        test_scenarios = [s for s in scenarios if s.get("markedAsTest", False)]
        if len(test_scenarios) == 0:
            return ProjectStandardsCheckRunResult.failure(3, "At least one test scenario is required, but none were found.")
        else:
            return ProjectStandardsCheckRunResult.success("A test scenario has been found.")
