<!-- html:true -->
<#-- FreeMarker functions for duration calculation -->
<#function computeEnd end>
  <#if end = 0>
    <#return .now?long>
  <#else>
    <#return end>
  </#if>
</#function>
<#function computeDuration start end>
  <#return computeEnd(end) - start>
</#function>

<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>DSS scenario report</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Source+Sans+3:ital,wght@0,200..900;1,200..900&display=swap');
    </style>
    <style type="text/css">
        /* Basic Resets & Client Fixes */
        body,
        #bodyTable {
            height: 100% !important;
            width: 100% !important;
            margin: 0;
            padding: 0;
            font-family: "Source Sans 3", Arial, sans-serif;
            background-color: #e0f7f6; /* Recent template background */
        }

        body, table, td, p, a, li, blockquote {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
        }

        .thread-item.expanded .thread-body .body, .msg-body {
            width: 100% !important;
            display: block !important;
        }

        .ReadMsgBody, .ExternalClass {
            width: 100%;
            background-color: #f4f4f4;
        }

        /* Kept light grey for external compatibility */
        .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {
            line-height: 100%;
        }

        table {
            border-spacing: 0;
        }

        table, td {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        img {
            -ms-interpolation-mode: bicubic;
        }

        img, a img {
            border: 0;
            outline: none;
            text-decoration: none;
        }

        .yshortcuts a {
            border-bottom: none !important;
        }

        /* Responsive Container */
        @media only screen and (min-width: 601px) {
            /* Adjusted max-width for consistency */
            .email-container {
                width: 600px !important;
            }
        }

        /* Custom Styles from Recent Template */
        .email-wrapper { /* Not directly used but kept for reference */
            width: 100%;
            max-width: 600px;
            margin: 16px auto;
            padding: 20px;
        }

        ul {
            line-height: 1.6;
        }

        a {
            color: #00B2A9;
            text-decoration: none; /* Default link style */
        }

        .logo-header {
            text-align: left;
            margin-bottom: 20px;
        }

        .logo {
            max-width: 120px;
            margin-bottom: 4px;
        }

        .container {
            background-color: #ffffff;
            padding: 24px 32px; /* Adjusted padding slightly */
            border: 1px solid #00B2A9;
            border-radius: 8px;
        }

        .content {
            color: #333333;
            line-height: 1.5;
        }

        .footer {
            text-align: center;
            color: #888888;
            font-size: 12px;
            padding: 40px 0;
        }

        .footer a {
            color: #00B2A9;
            text-decoration: underline;
        }

        /* Footer link style */
        .social-icons img {
            padding: 10px;
        }

        /* Scenario Report Specific Styles */
        .scenario-outcome {
            font-family: 'Source Sans 3', arial, sans-serif;
            font-size: 18px;
            font-weight: 600;
            line-height: 1.4;
            color: #333333;
            margin-bottom: 20px;
            text-align: left;
        }

        .details-section, .steps-section {
            font-family: 'Source Sans 3', arial, sans-serif;
            font-size: 16px;
            line-height: 24px;
            margin-bottom: 15px;
        }

        .steps-table {
            width: 100%;
            margin-top: 15px;
            border-collapse: collapse; /* Ensure collapse */
            /* table-layout: fixed; /* Optional: Uncomment if columns still misbehave */
        }

        .steps-table th, .steps-table td {
            font-family: 'Source Sans 3', arial, sans-serif;
            font-size: 14px;
            line-height: 20px;
            text-align: left;
            padding: 8px 5px;
            border-bottom: 1px solid #dddddd; /* Add bottom border */
            vertical-align: top; /* Ensure content aligns nicely */
        }

        .steps-table th {
            font-weight: 600;
            background-color: #f8f8f8;
            border-top: 1px solid #dddddd;
        }

        .steps-table td.duration {
            text-align: right;
            padding-right: 8px;
            white-space: nowrap;
        }

        .steps-table tr.even-row {
            background-color: #f9f9f9;
        }

        .error-message {
            font-size: 13px;
            color: #b94a48;
            font-family: "Courier New", Courier, monospace; /* Use monospace for errors */
            line-height: 16px;
            word-wrap: break-word; /* Wrap long error messages */
            white-space: normal; /* Allow error message text to wrap */
        }

        .log-output {
            font-size: 13px;
            color: #b94a48;
            font-family: "Courier New", Courier, monospace;
            line-height: 16px;
            max-height: 200px; /* Limit vertical size */
            overflow-y: auto; /* Add vertical scrollbar if needed */
            white-space: pre-wrap; /* IMPORTANT: Allow wrapping of long lines */
            word-wrap: break-word; /* IMPORTANT: Force break for long words/URLs */
            display: block; /* Ensure it behaves as a block */
            background-color: #fdf0f0; /* Light red background */
            padding: 8px; /* Add some padding */
            border: 1px solid #eedddd; /* Light red border */
            margin-top: 5px;
            box-sizing: border-box; /* Include padding/border in element's total width/height */
        }

        /* Outcome Colors */
        .outcome-success {
            color: #468847;
            font-weight: bold;
        }

        .outcome-warning {
            color: #c09853;
            font-weight: bold;
        }

        .outcome-failed {
            color: #b94a48;
            font-weight: bold;
        }

        .outcome-aborted {
            color: #b94a48;
            font-weight: bold;
        }

        .outcome-default {
            color: #b94a48;
            font-weight: bold;
        }

        /* For unexpected */

    </style>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
<table id="bodyTable" border="0" cellpadding="0" cellspacing="0" width="100%" height="100%">
    <tr>
        <td align="center" valign="top">
            <table align="center" border="0" cellpadding="0" cellspacing="0" class="email-container" style="max-width: 600px;">
                <tr>
                    <td height="20" style="font-size: 0; line-height: 0;">&nbsp;</td>
                </tr>
                <tr>
                    <td>
                        <div class="logo-header">
                            <a href="https://www.dataiku.com">
                                <img src="https://dku-assets.s3.amazonaws.com/img/emailing/DataikuLogoTeal_2025.png" alt="Dataiku" height="64">
                            </a>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="container">
                            <div class="content">

                                <div class="scenario-outcome">
                                    The scenario <strong>${scenarioName!scenarioId}</strong> in project <strong>${projectKey}</strong>
                                    <#switch outcome>
                                        <#case 'SUCCESS'><span class="outcome-success"> ran successfully</span><#break>
                                        <#case 'WARNING'><span class="outcome-warning"> ran with warnings</span><#break>
                                        <#case 'FAILED'><span class="outcome-failed"> failed</span><#break>
                                        <#case 'ABORTED'><span class="outcome-aborted"> was aborted</span><#break>
                                        <#default><span class="outcome-default"> terminated unexpectedly</span>
                                    </#switch>
                                    <#if scenarioRunURL??>
                                        <a href="${scenarioRunURL}" style="font-weight: normal;"> (view run)</a>
                                    </#if>
                                </div>

                                <#if username??>
                                    <div class="details-section" style="margin-bottom: 20px;">
                                        Hi ${username},
                                    </div>
                                </#if>

                                <div class="details-section">
                                    <#assign runStart = _rawScenarioRun.start>
                                    <#assign runEnd = computeEnd(_rawScenarioRun.end)>
                                    <#assign runDuration = computeDuration(runStart, _rawScenarioRun.end)>
                                    <strong>Run Details:</strong><br/>
                                    Started: ${runStart?number_to_datetime}<br/>
                                    Completed: ${runEnd?number_to_datetime}<br/>
                                    Duration: <#if runDuration < 120000 >${(runDuration/1000)?string["0.#"]}s<#elseif runDuration < 3600000 >${(runDuration/60000)?floor}m ${((runDuration/1000) % 60)?string["0.#"]}s<#else>${(runDuration/3600000)?floor}h ${((runDuration/60000)%60)?floor}m ${((runDuration/1000) % 60)?string["0.#"]}s</#if>
                                    <br/>
                                    <#if _rawScenarioRun.trigger??>
                                        <#if _rawScenarioRun.trigger.trigger.type == 'manual'>
                                            Trigger: Started manually
                                        <#else>
                                            Trigger: Started by
                                            <em>${_rawScenarioRun.trigger.trigger.name!'of type ' + _rawScenarioRun.trigger.trigger.type}</em>
                                        </#if>
                                    <#else>
                                        Trigger: Unknown
                                    </#if>
                                </div>

                                <div class="steps-section">
                                    <strong>${_fullStepRuns?size} step(s) executed:</strong>
                                    <table class="steps-table" cellpadding="0" cellspacing="0">
                                        <thead>
                                        <tr>
                                            <th>Step Name/ID</th>
                                            <th class="duration">Duration</th>
                                            <th>Outcome & Details</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <#list _fullStepRuns as stepRun>
                                            <#assign stepOutcome=(stepRun.result.outcome)!'NONE'>
                                            <#assign stepDuration=computeDuration(stepRun.start, stepRun.end)>
                                            <tr class="${((stepRun_index % 2) == 1)?string("even-row", "odd-row")}">
                                                <td>${stepRun.step.name!stepRun.step.id}</td>
                                                <td class="duration">
                                                    <#if stepDuration < 60000 >${(stepDuration/1000)?string["0.#"]}s<#elseif stepDuration < 3600000 >${(stepDuration/60000)?floor}m ${((stepDuration/1000) % 60)?string["0.#"]}s<#else>${(stepDuration/3600000)?floor}h ${((stepDuration/60000)%60)?floor}m ${((stepDuration/1000) % 60)?string["0.#"]}s</#if>
                                                </td>
                                                <td>
                                                    <#switch stepOutcome>
                                                        <#case 'SUCCESS'><span class="outcome-success">SUCCESS</span><#break>
                                                        <#case 'WARNING'><span class="outcome-warning">WARNING</span><#break>
                                                        <#case 'FAILED'><span class="outcome-failed">FAILED</span><#break>
                                                        <#case 'ABORTED'><span class="outcome-aborted">ABORTED</span><#break>
                                                        <#default><span style="color: #888888;">${stepOutcome}</span>
                                                    </#switch>
                                                    <#-- Display error message and log tail on failure -->
                                                    <#if stepOutcome == "FAILED">
                                                        <#assign errorBearer=getBearerOfError(stepRun)!>
                                                        <#assign logBearer=getBearerOfLog(stepRun)!>
                                                    <#-- Error Message (now uses .error-message class for wrapping) -->
                                                        <#if (errorBearer.thrown)?? && (errorBearer.thrown.message)??>
                                                            <div class="error-message" style="margin-top: 4px;">${errorBearer.thrown.message?html}</div>
                                                        </#if>
                                                    <#-- Log Tail (uses .log-output class with wrapping and scrolling) -->
                                                        <#if (logBearer.logTail)?? && (logBearer.logTail.lines?size > 0)>
                                                            <pre class="log-output"><#list logBearer.logTail.lines as line>${line?html}<#if line_has_next>&#10;</#if></#list></pre>
                                                        </#if>
                                                    </#if>
                                                </td>
                                            </tr>
                                        </#list>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="details-section">
                                    <#if scenarioRunURL??>
                                        More details are available on the <a href="${scenarioRunURL}">run report page</a>.
                                    <#else>
                                        To get a link to the run report page, ask your DSS administrator to configure the DSS instance URL in General Settings.
                                    </#if>
                                </div>

                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="footer" style="text-align: center; color: #888888; font-size: 12px; padding-bottom: 10px;">
                        Powered by <a href="https://www.dataiku.com/dss">Dataiku DSS</a>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
</body>
</html>