/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.RegexpFieldsMatcher;
import java.util.List;

public class RegexpFieldsBuilderFactory {
    public static RegexpFieldsMatcher build(boolean autoAddSpace, List<Step> steps) {
        RegexpFieldsMatcher out = new RegexpFieldsMatcher(autoAddSpace);
        for (Step step : steps) {
            String fieldType = step.type;
            if (fieldType == null) break;
            String fieldPattern = step.pattern;
            if (fieldType.equals("predefcapture")) {
                String fieldPredef = step.predef;
                if (fieldPredef == null) {
                    throw ErrorContext.iae((String)"Neither pattern nor predef specified");
                }
                if (fieldPredef.equals("quotted_no_escape")) {
                    fieldPattern = "\"([^\"]*)\"";
                    fieldType = "customcapture";
                } else if (fieldPredef.equals("integer")) {
                    fieldPattern = "[-0-9]+";
                    fieldType = "capture";
                } else if (fieldPredef.equals("ip")) {
                    fieldPattern = "[0-9abcdef:\\.\\[\\]]*";
                    fieldType = "capture";
                } else {
                    throw ErrorContext.iae((String)("Unknown predef value " + fieldPredef));
                }
            }
            if (fieldType.equals("capture")) {
                out.capture(step.column, fieldPattern);
                continue;
            }
            if (fieldType.equals("match")) {
                out.match(fieldPattern);
                continue;
            }
            if (fieldType.equals("customcapture")) {
                out.customCapture(step.column, fieldPattern);
                continue;
            }
            throw ErrorContext.iae((String)("Unknown field type " + fieldType));
        }
        out.compile();
        return out;
    }

    public static class Step {
        public String type;
        public String pattern;
        public String column;
        public String predef;

        public static Step matchStep(String pattern) {
            Step step = new Step();
            step.type = "match";
            step.pattern = pattern;
            return step;
        }

        public static Step captureStep(String column, String pattern) {
            Step step = new Step();
            step.type = "capture";
            step.column = column;
            step.pattern = pattern;
            return step;
        }

        public static Step customCaptureStep(String column, String pattern) {
            Step step = new Step();
            step.type = "customcapture";
            step.column = column;
            step.pattern = pattern;
            return step;
        }

        public static Step predefCaptureStep(String column, String predef) {
            Step step = new Step();
            step.type = "predefcapture";
            step.column = column;
            step.predef = predef;
            return step;
        }
    }
}

