/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class Reflector {
    private ClassLoader classLoader;

    public Reflector() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public Reflector(ClassLoader cl) {
        this.classLoader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private static Class[] getTypes(Object[] params) {
        Class[] classes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            classes[i] = params[i] != null ? params[i].getClass() : null;
        }
        return classes;
    }

    public Class getClassForName(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public Class getInnerClass(Class parentClass, String innerClass) throws ClassNotFoundException {
        for (Class<?> c : parentClass.getDeclaredClasses()) {
            if (!c.getSimpleName().equals(innerClass)) continue;
            return c;
        }
        throw new ClassNotFoundException("Unable to find inner class " + innerClass + " in " + parentClass.getName());
    }

    public Object newInstance(Class cl, Object ... params) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor ctor = null;
        try {
            ctor = cl.getDeclaredConstructor(Reflector.getTypes(params));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ctor == null) {
            ctor = ConstructorUtils.getMatchingAccessibleConstructor((Class)cl, (Class[])Reflector.getTypes(params));
        }
        if (ctor == null) {
            throw new NoSuchMethodException("constructor of " + cl.getName());
        }
        ctor.setAccessible(true);
        return ctor.newInstance(params);
    }

    public Object newInstance(String className, Object ... params) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class cl = this.getClassForName(className);
        return this.newInstance(cl, params);
    }

    public Object call(Object o, String method, Object ... params) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = null;
        Class<?> cl = o.getClass();
        try {
            m = cl.getDeclaredMethod(method, Reflector.getTypes(params));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (m == null) {
            m = MethodUtils.getMatchingAccessibleMethod(cl, (String)method, (Class[])Reflector.getTypes(params));
        }
        if (m == null) {
            throw new NoSuchMethodException(method + " in " + cl.getName());
        }
        m.setAccessible(true);
        return m.invoke(o, params);
    }

    public Object callStatic(String className, String method, Object ... params) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = null;
        Class cl = this.getClassForName(className);
        try {
            m = cl.getDeclaredMethod(method, Reflector.getTypes(params));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (m == null) {
            m = MethodUtils.getMatchingAccessibleMethod((Class)cl, (String)method, (Class[])Reflector.getTypes(params));
        }
        if (m == null) {
            throw new NoSuchMethodException(method + " in " + cl.getName());
        }
        m.setAccessible(true);
        return m.invoke(null, params);
    }

    public Object getEnumValue(String enumName, String value) throws ClassNotFoundException {
        return Enum.valueOf(this.getClassForName(enumName), value);
    }

    public Object getAttribute(Object o, String name) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = null;
        try {
            f = o.getClass().getDeclaredField(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f == null) {
            f = FieldUtils.getField(o.getClass(), (String)name, (boolean)true);
        }
        if (f == null) {
            throw new NoSuchFieldException(name + " in " + o.getClass().getName());
        }
        f.setAccessible(true);
        return f.get(o);
    }

    public Field getStaticField(String className, String attr) throws Exception {
        Class cl = this.getClassForName(className);
        Field f = null;
        try {
            f = cl.getDeclaredField(attr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f == null) {
            f = FieldUtils.getField((Class)this.getClassForName(className), (String)attr, (boolean)true);
        }
        if (f == null) {
            throw new NoSuchFieldException(attr + " in " + className);
        }
        f.setAccessible(true);
        return f;
    }

    public Object getStaticAttribute(String className, String attr) throws IllegalArgumentException, IllegalAccessException, Exception {
        return this.getStaticField(className, attr).get(null);
    }

    public void setStaticAttribute(String className, String attr, Object val) throws IllegalArgumentException, IllegalAccessException, Exception {
        this.getStaticField(className, attr).set(null, val);
    }

    public boolean isInstanceOf(Object o, String className) {
        try {
            Class c = this.getClassForName(className);
            return c.isInstance(o);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Object getImplementationOf(String interfaceName, InvocationHandler handler) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class interfaceClass = this.getClassForName(interfaceName);
        Class<?> implementationClass = Proxy.getProxyClass(this.getClassLoader(), interfaceClass);
        Object implementation = implementationClass.getConstructor(InvocationHandler.class).newInstance(handler);
        return implementation;
    }
}

