/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AIGrouping
extends AIRecipe {
    public static final String type = "grouping";
    public Params params;

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        if (this.params.grouping_keys.isEmpty()) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.GROUP.EMPTY_GROUPING_KEY", "We were unable to detect what column(s) to use to group rows together", new Object[0])));
        }
        Set datasetColumnNames = dataset.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        for (String gk : this.params.grouping_keys) {
            if (datasetColumnNames.contains(gk)) continue;
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.GROUP.INVALID_GROUPING_KEY", String.format("The column name %s use to group rows together is not present in the dataset", gk), "column", gk)));
        }
        this.validateAggregationFunctions(creationMessages, this.params.aggregations, dataset, false, lang);
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        GroupingRecipePayloadParams groupingRecipePayloadParams = new GroupingRecipePayloadParams();
        this.enrichParams(groupingRecipePayloadParams, recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey);
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)groupingRecipePayloadParams);
        return metaCreation;
    }

    public void enrichParams(GroupingRecipePayloadParams recipeParams, List<Dataset> datasets, String contextProjectKey) {
        Dataset dataset = AIRecipe.AIRecipeParams.getDataset(datasets, this.params.input_dataset, contextProjectKey);
        Set validDatasetColumnNames = dataset.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        if (this.params.grouping_keys != null && !this.params.grouping_keys.isEmpty()) {
            this.params.grouping_keys.stream().filter(validDatasetColumnNames::contains).forEach(key -> recipeParams.getRawGroupingKeys().add(new GroupingRecipePayloadParams.GroupingKey((String)key)));
        }
        HashMap<String, Set> groupByColumnToAggregation = new HashMap<String, Set>();
        for (AIRecipe.Aggregation aggregation : this.params.aggregations) {
            if (!validDatasetColumnNames.contains(aggregation.column)) continue;
            Set computingFunctions = groupByColumnToAggregation.getOrDefault(aggregation.column, new HashSet());
            computingFunctions.add(aggregation.function);
            groupByColumnToAggregation.put(aggregation.column, computingFunctions);
        }
        for (Map.Entry entry : groupByColumnToAggregation.entrySet()) {
            String column = (String)entry.getKey();
            Set aggregationFunctions = (Set)entry.getValue();
            GroupingRecipePayloadParams.GroupingValue gv = new GroupingRecipePayloadParams.GroupingValue(column, aggregationFunctions.contains("MIN"), aggregationFunctions.contains("MAX"), aggregationFunctions.contains("SUM"), aggregationFunctions.contains("AVG"), aggregationFunctions.contains("COUNT"), aggregationFunctions.contains("COUNT_DISTINCT"), aggregationFunctions.contains("FIRST"), aggregationFunctions.contains("LAST"), aggregationFunctions.contains("CONCAT"), aggregationFunctions.contains("CONCAT_DISTINCT"), aggregationFunctions.contains("STD_DEV"), null);
            recipeParams.values.add(gv);
        }
        recipeParams.globalCount = this.params.global_count != null && this.params.global_count != false;
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public List<String> grouping_keys;
        public List<AIRecipe.Aggregation> aggregations;
        public Boolean global_count;
    }
}

