/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class PerTimeseriesMetricsTableExtractor
implements ModelExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModel = (TimeseriesForecastingModelDetails)model;
        FullModelId fmi = FullModelId.parse(timeseriesModel.fullModelId);
        TimeseriesForecastingModelPerf fullPerf = fmi.getTimeseriesForecastingPerf(true);
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        if (fullPerf.perTimeseriesMetrics.isEmpty()) {
            return output;
        }
        Map.Entry<String, TimeseriesForecastingModelPerf.TimeseriesForecastingMetrics> firstRowEntry = fullPerf.perTimeseriesMetrics.entrySet().iterator().next();
        JsonObject tsIdentifiersHeaders = (JsonObject)JSON.parse((String)firstRowEntry.getKey(), JsonObject.class);
        ArrayList<String> headerRow = new ArrayList<String>(tsIdentifiersHeaders.keySet());
        headerRow.add("MASE");
        headerRow.add("MAPE");
        headerRow.add("MSE");
        headerRow.add("MSIS");
        headerRow.add("SMAPE");
        headerRow.add("MAE");
        output.add(headerRow);
        for (Map.Entry<String, TimeseriesForecastingModelPerf.TimeseriesForecastingMetrics> entry : fullPerf.perTimeseriesMetrics.entrySet()) {
            String timeseriesIdentifierString = entry.getKey();
            TimeseriesForecastingModelPerf.TimeseriesForecastingMetrics metrics = entry.getValue();
            ArrayList<String> row = new ArrayList<String>();
            JsonObject tsIdentifiers = (JsonObject)JSON.parse((String)timeseriesIdentifierString, JsonObject.class);
            for (String identifier : tsIdentifiers.keySet()) {
                row.add(tsIdentifiers.get(identifier).getAsString());
            }
            row.add(this.metricValueString(metrics.mase, metrics.masestd, false));
            row.add(this.metricValueString(metrics.mape, metrics.mapestd, true));
            row.add(this.metricValueString(metrics.mse, metrics.msestd, false));
            row.add(this.metricValueString(metrics.msis, metrics.msisstd, false));
            row.add(this.metricValueString(metrics.smape, metrics.smapestd, true));
            row.add(this.metricValueString(metrics.mae, metrics.maestd, false));
            output.add(row);
        }
        return output;
    }

    private String metricValueString(@Nullable Double metricValue, @Nullable Double metricStd, boolean percentage) {
        String percentString;
        if (metricValue == null) {
            return "-";
        }
        String string = percentString = percentage ? "%" : "";
        if (percentage) {
            metricValue = metricValue * 100.0;
            if (metricStd != null) {
                metricStd = metricStd * 100.0;
            }
        }
        Object cellValue = String.format("%.5g%s", metricValue, percentString);
        if (metricStd != null) {
            cellValue = (String)cellValue + String.format(" (\u00b1%.5g%s)", 2.0 * metricStd, percentString);
        }
        return cellValue;
    }
}

