/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.analysis.model.prediction.CategoricalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.NumericalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModelTrainInfo {
    public ModelTrainState state;
    public APIError failure;
    public PreSearchDescription preSearchDescription;
    public PostSearchDescription postSearchDescription;
    public boolean resumed;
    public boolean timeOrderingEnabled;
    public String timeVariable;
    public boolean sampleWeightsEnabled;
    public String sampleWeightsVariable;
    public String modelId;
    public TrainProgress progress;
    public long startTime;
    public long endTime;
    public long preprocessingTime;
    public long trainingTime;
    public long hyperparamsSearchTime;
    @JSON.FileTransient
    public boolean kfold;
    public Long fullRows;
    public Long trainRows;
    public Long testRows;
    public String pythonVersion;
    public JsonObject packagesVersion;

    public static class PostSearchDescription {
        public List<SearchParam> importantParams = new ArrayList<SearchParam>();

        public PostSearchDescription withSVParam(String key, Object value) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.val = value.toString();
            this.importantParams.add(sp);
            return this;
        }

        public PostSearchDescription withSVParam(String key, Object value, String id) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.val = value.toString();
            sp.id = id;
            this.importantParams.add(sp);
            return this;
        }

        public PostSearchDescription withMVParam(String key, int[] values) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.vals = new String[values.length];
            for (int i = 0; i < sp.vals.length; ++i) {
                sp.vals[i] = Integer.toString(values[i]);
            }
            this.importantParams.add(sp);
            return this;
        }

        public PostSearchDescription withMVParam(String key, float[] values) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.vals = new String[values.length];
            for (int i = 0; i < sp.vals.length; ++i) {
                sp.vals[i] = Float.toString(values[i]);
            }
            this.importantParams.add(sp);
            return this;
        }

        public PostSearchDescription withMVParam(String key, double[] values) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.vals = new String[values.length];
            for (int i = 0; i < sp.vals.length; ++i) {
                sp.vals[i] = Double.toString(values[i]);
            }
            this.importantParams.add(sp);
            return this;
        }
    }

    public static class PreSearchDescription {
        public int gridLength = 1;
        private PredictionModelingParams.GridSearchParams.Strategy searchStrategy;
        public List<SearchParam> importantParams = new ArrayList<SearchParam>();

        public PreSearchDescription(PreTrainPredictionModelingParams rpmp) {
            this.searchStrategy = rpmp != null && rpmp.grid_search_params != null ? rpmp.grid_search_params.strategy : PredictionModelingParams.GridSearchParams.Strategy.GRID;
        }

        public PreSearchDescription withGridLength(int gridLength) {
            this.gridLength = gridLength;
            return this;
        }

        public PreSearchDescription withSVParam(String key, Object value) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.val = value.toString();
            this.importantParams.add(sp);
            return this;
        }

        public PreSearchDescription withSVParam(String key, int[] values) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.vals = new String[values.length];
            for (int i = 0; i < sp.vals.length; ++i) {
                sp.vals[i] = Integer.toString(values[i]);
            }
            this.importantParams.add(sp);
            return this;
        }

        public PreSearchDescription withMVParam(String key, List<? extends Object> values) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.vals = new String[values.size()];
            for (int i = 0; i < sp.vals.length; ++i) {
                sp.vals[i] = values.get(i).toString();
            }
            this.importantParams.add(sp);
            return this;
        }

        public PreSearchDescription withRangeParam(String key, NumericalHyperparameterDimension.Range range) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.min = range.min.toString();
            sp.max = range.max.toString();
            this.importantParams.add(sp);
            return this;
        }

        public PreSearchDescription withMVParam(String key, NumericalHyperparameterDimension param) {
            NumericalHyperparameterDimension.ValueMode paramMode = PredictionModelingParams.GridSearchParams.Strategy.GRID.equals((Object)this.searchStrategy) ? param.gridMode : param.randomMode;
            if (NumericalHyperparameterDimension.ValueMode.EXPLICIT == paramMode) {
                return this.withMVParam(key, Arrays.asList(param.values));
            }
            return this.withRangeParam(key, param.range);
        }

        public PreSearchDescription withMVParam(String key, CategoricalHyperparameterDimension param) {
            ArrayList<String> keyList = new ArrayList<String>();
            for (String hpkey : param.values.keySet()) {
                if (!param.values.get((Object)hpkey).enabled) continue;
                keyList.add(hpkey);
            }
            return this.withMVParam(key, keyList);
        }

        public PreSearchDescription withMVParamFromBooleans(String key, Object ... data) {
            ArrayList<String> selectedValues = new ArrayList<String>();
            for (int i = 0; i < data.length; i += 2) {
                if (!((Boolean)data[i + 1]).booleanValue()) continue;
                selectedValues.add(data[i].toString());
            }
            return this.withMVParam(key, selectedValues);
        }

        public PreSearchDescription withMVParam(String key, int[] values) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.vals = new String[values.length];
            for (int i = 0; i < sp.vals.length; ++i) {
                sp.vals[i] = Integer.toString(values[i]);
            }
            this.importantParams.add(sp);
            return this;
        }

        public PreSearchDescription withMVParam(String key, float[] values) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.vals = new String[values.length];
            for (int i = 0; i < sp.vals.length; ++i) {
                sp.vals[i] = Float.toString(values[i]);
            }
            this.importantParams.add(sp);
            return this;
        }

        public PreSearchDescription withMVParam(String key, double[] values) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.vals = new String[values.length];
            for (int i = 0; i < sp.vals.length; ++i) {
                sp.vals[i] = Double.toString(values[i]);
            }
            this.importantParams.add(sp);
            return this;
        }

        public PreSearchDescription withCountParam(String key, int value) {
            SearchParam sp = new SearchParam();
            sp.name = key;
            sp.cnt = value;
            this.importantParams.add(sp);
            return this;
        }
    }

    public static class SearchParam {
        public String id;
        public String name;
        public Integer cnt;
        public String[] vals;
        public String val;
        public String min;
        public String max;
    }

    public static class TrainProgress {
        public List<String> top_level_todo;
        public List<FutureProgressState> stack;
        public List<TopLevelDone> top_level_done;

        public static class TopLevelDone {
            public String name;
            public long time;

            public TopLevelDone(String name, long time) {
                this.name = name;
                this.time = time;
            }
        }
    }

    public static enum ModelTrainState {
        PENDING,
        RUNNING,
        DONE,
        FAILED,
        ABORTED;


        public boolean isBeingTrained() {
            return this == PENDING || this == RUNNING;
        }
    }
}

