/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.ClusteringAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import java.util.ArrayList;
import java.util.List;

public class TwoStepMeta
extends ClusteringAlgorithmMeta {
    private final MLTask.BackendType backendType;

    public TwoStepMeta(MLTask.BackendType backendType) {
        this.backendType = backendType;
    }

    @Override
    public MLTask.BackendType backendType() {
        return this.backendType;
    }

    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "Interactive Clustering";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "";
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        ClusteringModelingParams.TwoStepParams ts = task.modeling.two_step;
        if (ts.enabled && ts.kmeans_k > 300) {
            checks.addWarning("Many clusters for two step", "You have selected " + ts.kmeans_k + " pre-clusters for two-step clustering, which will result in a poorly readable model.");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.TwoStepParams ts = task.modeling.two_step;
        if (ts.enabled && task.backendType == this.backendType) {
            boolean isMLLib = this.backendType == MLTask.BackendType.MLLIB;
            PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(isMLLib ? PreTrainClusteringModelingParams.Algorithm.MLLIB_TWO_STEP : PreTrainClusteringModelingParams.Algorithm.PY_TWO_STEP);
            rcmp.ts_kmeans_k = ts.kmeans_k;
            rcmp.k = ts.n_clusters;
            if (ts.seed != 0) {
                rcmp.seed = ts.seed;
            }
            rcmp.max_iterations = ts.max_iterations;
            ret.add(new WorkSet.ModelingSet(rcmp));
        }
        return ret;
    }
}

