/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.core;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.prediction.DeepHubPreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public interface PreTrainModelingParams {
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription();

    public String generateName();

    public String getEvaluationMetricName();

    public static class JsonAdapterInit {
        static {
            JSON.registerAdapter(PreTrainModelingParams.class, (Object)new JSON.Adapter<PreTrainModelingParams>(){

                public PreTrainModelingParams deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    if (jsonObj.has("k")) {
                        return (PreTrainModelingParams)jsonDeserializationContext.deserialize(jsonElement, PreTrainClusteringModelingParams.class);
                    }
                    if (jsonObj.has("type")) {
                        String type = jsonObj.get("type").getAsString();
                        if (PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_OBJECT_DETECTION.name().equals(type) || PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_CLASSIFICATION.name().equals(type)) {
                            return (PreTrainModelingParams)jsonDeserializationContext.deserialize(jsonElement, DeepHubPreTrainModelingParams.class);
                        }
                        throw new IllegalArgumentException("Unknown type: " + type);
                    }
                    return (PreTrainModelingParams)jsonDeserializationContext.deserialize(jsonElement, PreTrainPredictionModelingParams.class);
                }

                public JsonElement serialize(PreTrainModelingParams modelingParams, Type type, JsonSerializationContext ctx) {
                    return ctx.serialize((Object)modelingParams);
                }
            });
        }
    }
}

