/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.core;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ResolvedClusteringCoreParams;
import com.dataiku.dip.analysis.model.core.TrainExecutionParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedCausalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedDeepHubPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.io.Serializable;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public abstract class ResolvedCoreParams
implements Serializable,
ParamsWithContainerizable {
    private static final long serialVersionUID = 1L;
    public MLTask.BackendType backendType;
    public final MLTask.MLTaskType taskType;
    public MLTask.DiagnosticsSettings diagnosticsSettings;
    public TrainExecutionParams executionParams;

    protected ResolvedCoreParams(MLTask.MLTaskType taskType) {
        this.taskType = taskType;
    }

    @Override
    @Nullable
    public ContainerExecSelection getContainerSelection() {
        if (this.executionParams == null) {
            return null;
        }
        return this.executionParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        assert (this.executionParams != null) : "ResolvedCoreParams.executionParams should not be null when calling ResolvedCoreParams#setContainerSelection()";
        this.executionParams.containerSelection = selection;
    }

    static {
        JSON.registerAdapter(ResolvedCoreParams.class, (Object)new JSON.Adapter<ResolvedCoreParams>(){

            public JsonElement serialize(ResolvedCoreParams coreParams, Type type, JsonSerializationContext ctx) {
                return ctx.serialize((Object)coreParams);
            }

            public ResolvedCoreParams deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                if ("CLUSTERING".equals(jsonObj.get("taskType").getAsString())) {
                    return (ResolvedCoreParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedClusteringCoreParams.class);
                }
                if (jsonObj.has("backendType") && MLTask.BackendType.DEEP_HUB.name().equals(jsonObj.get("backendType").getAsString())) {
                    return (ResolvedCoreParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedDeepHubPredictionCoreParams.class);
                }
                if (jsonObj.has("prediction_type") && PredictionMLTask.PredictionType.TIMESERIES_FORECAST.name().equals(jsonObj.get("prediction_type").getAsString())) {
                    return (ResolvedCoreParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedTimeseriesForecastingCoreParams.class);
                }
                if (jsonObj.has("prediction_type") && (PredictionMLTask.PredictionType.CAUSAL_BINARY_CLASSIFICATION.name().equals(jsonObj.get("prediction_type").getAsString()) || PredictionMLTask.PredictionType.CAUSAL_REGRESSION.name().equals(jsonObj.get("prediction_type").getAsString()))) {
                    return (ResolvedCoreParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedCausalPredictionCoreParams.class);
                }
                return (ResolvedCoreParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedClassicalPredictionCoreParams.class);
            }
        });
    }
}

