/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.apideployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.apideployer.infra.MultiAutomationNodeInfraManager;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiAutomationNodeInfra
extends AbstractProjectDeploymentInfra {
    public List<AutomationNodeRef> automationNodes = new ArrayList<AutomationNodeRef>();
    public String loadBalancerResourceUrl;
    public boolean setInstanceAsNotAliveDuringDeploymentUpdate;
    public int updateDelaySecs = 60;

    private MultiAutomationNodeInfra() {
    }

    public MultiAutomationNodeInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
    }

    @Override
    public AbstractDeploymentInfra.InfraType getInfraType() {
        return AbstractDeploymentInfra.InfraType.MULTI_AUTOMATION_NODE;
    }

    @Nonnull
    public List<NodeConnection> getConnectionInfos() {
        PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        if (this.autoconfigureFromNodesDirectory) {
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            ArrayList<NodeConnection> nodeConnections = new ArrayList<NodeConnection>();
            for (AutomationNodeRef automationNodeRef : this.automationNodes) {
                NodesDirectory.NodeRef nodeRef = (NodesDirectory.NodeRef)nd.getById(automationNodeRef.nodeId).orElseThrow(() -> new IllegalArgumentException("Invalid automation node " + automationNodeRef.nodeId));
                nodeConnections.add(NodeConnection.forMultiNodeInfra((String)automationNodeRef.automationNodeId, (String)nodeRef.url, (String)nodeRef.externalUrl, (String)passwordEncryptionService.decryptIfEncrypted(nodeRef.adminAPIKey), (boolean)true, (NodesDirectory.NodeStatus)nodeRef.status));
            }
            return nodeConnections;
        }
        return this.automationNodes.stream().map(node -> NodeConnection.forMultiNodeInfra((String)node.automationNodeId, (String)node.automationNodeUrl, (String)node.automationNodeExternalUrl, (String)passwordEncryptionService.decryptIfEncrypted(node.adminApiKey), (boolean)this.trustAllSSLCertificates, null)).collect(Collectors.toList());
    }

    @Nonnull
    public Map<String, Optional<NodeConnection>> getOptionalNodeConnections() {
        LinkedHashMap<String, Optional<NodeConnection>> nodeConnectionsMap = new LinkedHashMap<String, Optional<NodeConnection>>();
        PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        if (this.autoconfigureFromNodesDirectory) {
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            for (AutomationNodeRef automationNodeRef : this.automationNodes) {
                Optional optionalNodeRef = nd.getById(automationNodeRef.nodeId);
                nodeConnectionsMap.put(automationNodeRef.automationNodeId, optionalNodeRef.map(nr -> NodeConnection.forMultiNodeInfra((String)automationNodeRef.automationNodeId, (String)nr.url, (String)nr.externalUrl, (String)passwordEncryptionService.decryptIfEncrypted(nr.adminAPIKey), (boolean)true, (NodesDirectory.NodeStatus)nr.status)));
            }
        } else {
            for (AutomationNodeRef automationNodeRef : this.automationNodes) {
                nodeConnectionsMap.put(automationNodeRef.automationNodeId, Optional.of(NodeConnection.forMultiNodeInfra((String)automationNodeRef.automationNodeId, (String)automationNodeRef.automationNodeUrl, (String)automationNodeRef.automationNodeExternalUrl, (String)passwordEncryptionService.decryptIfEncrypted(automationNodeRef.adminApiKey), (boolean)this.trustAllSSLCertificates, null)));
            }
        }
        return nodeConnectionsMap;
    }

    @Override
    public AbstractAutomationNodeInfraManager getInfraManager(AuthCtx authCtx, int connectTimeout, int socketTimeout) {
        return new MultiAutomationNodeInfraManager(authCtx, this, connectTimeout, socketTimeout);
    }

    public static class AutomationNodeRef {
        @Nullable
        public String nodeId;
        @Nonnull
        public String automationNodeId;
        public String automationNodeUrl;
        @Nullable
        public String automationNodeExternalUrl;
        @Nullable
        public String adminApiKey;

        private AutomationNodeRef() {
        }

        public AutomationNodeRef(String nodeId, String automationNodeUrl, String automationNodeExternalUrl, String adminApiKey) {
            this.nodeId = nodeId;
            this.automationNodeId = nodeId;
            this.automationNodeUrl = automationNodeUrl;
            this.automationNodeExternalUrl = automationNodeExternalUrl;
            this.adminApiKey = adminApiKey;
        }
    }
}

