/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deploymentinfo;

import com.dataiku.dip.apideployer.deploymentinfo.AbstractDeploymentInfo;
import com.dataiku.dip.apideployer.deploymentinfo.DeploymentInfoPaths;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DeploymentInfoCRUDService {
    public void save(AbstractDeploymentInfo deploymentInfo) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)deploymentInfo.infraId), (Object)"Infra id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)deploymentInfo.deploymentId), (Object)"Deployment id is not specified");
        JSON.prettyToFile((Object)deploymentInfo, (File)DeploymentInfoPaths.deploymentInfoFile(deploymentInfo.infraId, deploymentInfo.deploymentId));
    }

    public boolean exists(String infraId, String deploymentId) {
        return DeploymentInfoPaths.deploymentInfoFile(infraId, deploymentId).exists();
    }

    @Nullable
    public AbstractDeploymentInfo get(String infraId, String deploymentId) throws IOException {
        return this.get(infraId, deploymentId, AbstractDeploymentInfo.class);
    }

    @Nullable
    public <T extends AbstractDeploymentInfo> T get(String infraId, String deploymentId, Class<T> clazz) throws IOException {
        if (this.exists(infraId, deploymentId)) {
            AbstractDeploymentInfo deploymentInfo = (AbstractDeploymentInfo)JSON.parseFile((File)DeploymentInfoPaths.deploymentInfoFile(infraId, deploymentId), clazz);
            deploymentInfo.infraId = infraId;
            deploymentInfo.deploymentId = deploymentId;
            return (T)deploymentInfo;
        }
        return null;
    }

    public void delete(String infraId, String deploymentId) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)infraId), (Object)"Infra id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)deploymentId), (Object)"Deployment id is not specified");
        Files.deleteIfExists(DeploymentInfoPaths.deploymentInfoFile(infraId, deploymentId).toPath());
    }
}

