/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentHelper;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDockerDeploymentConfigManager;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDockerDeploymentManager;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSettingsProvider;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.containers.exec.BaseDockerFilePreparer;
import com.dataiku.dip.containers.exec.ECRUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.snowpark.SnowparkUtils;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.FileSymmetricKeyBasedPasswordEncryptionProvider;
import com.dataiku.dip.security.PasswordEncryptionProvider;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.APIServiceCodes;
import com.dataiku.lambda.model.serverconfig.DatasetResource;
import com.dataiku.lambda.model.serverconfig.EndpointWithConnections;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.ServiceState;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class APIDeployerImageBuilderService {
    public static final String CODE_ENVS_BUILD = "Docker.code_envs_build";
    public static final String POD_DKUINSTALLDIR = "/opt/dataiku/installdir";
    @Autowired
    PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    PasswordEncryptionService passwordEncryptionService;
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    AutomationNodeCodeEnvsService automationNodeCodeEnvsService;
    @Autowired
    CodeEnvSettingsProvider codeEnvSettingsProvider;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.imagebuilder");

    public static String sanitizeDeploymentId(String deploymentId) {
        if (StringUtils.isEmpty((String)deploymentId)) {
            return deploymentId;
        }
        return deploymentId.toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    private void syncGeneration(AbstractAPIServiceDeployment deployment, File contextDir, File gensDir, String generation) throws IOException {
        logger.info((Object)("Prepare sync of package version " + generation));
        File sourcePackageFile = this.publishedAPIServicesService.getPublishedPackageFileMandatory(deployment.publishedServiceId, generation);
        boolean hasAPermissionToQueryThroughDeployer = deployment.auth.permissions.stream().anyMatch(permission -> permission.queryThroughDeployer);
        File authReadyPackageFile = deployment.auth.authMode == AbstractAPIServiceDeployment.APIAuthSettings.DeployedAuthenticationMode.INHERIT_DEV && !hasAPermissionToQueryThroughDeployer ? sourcePackageFile : APIServiceDeploymentHelper.getOrMakeAuthReadyPackage(sourcePackageFile, new File(contextDir, "tmp-authready"), deployment, generation);
        logger.info((Object)("  Will sync package " + String.valueOf(authReadyPackageFile)));
        File genDir = new File(gensDir, generation);
        ZipUnzipDir.extractFolder(authReadyPackageFile, genDir);
    }

    private RegularPasswordEncryptionService initializeAndGetDockerImagePasswordEncryptionService(File contextDir) throws Exception {
        File serverConfig = new File(contextDir, "server-config");
        File keyFile = new File(serverConfig.getAbsolutePath() + "/configkey.json");
        FileSymmetricKeyBasedPasswordEncryptionProvider.generateKey((File)keyFile);
        FileSymmetricKeyBasedPasswordEncryptionProvider apiNodeProvider = new FileSymmetricKeyBasedPasswordEncryptionProvider(keyFile);
        return RegularPasswordEncryptionService.withExplicitProvider((PasswordEncryptionProvider)apiNodeProvider);
    }

    private void encryptConnectionsWithNewApiNodeKey(RegularPasswordEncryptionService dockerImagePasswordEncryptionService, LambdaServerConfig lsc) throws Exception {
        Collection connectionsWithEncryptedValues = lsc.remappedConnections.values().stream().filter(ConnectionWithEncryptedFields.class::isInstance).map(c2 -> (ConnectionWithEncryptedFields)((Object)c2)).collect(Collectors.toSet());
        if (lsc.bundledConnection instanceof ConnectionWithEncryptedFields) {
            connectionsWithEncryptedValues.add((ConnectionWithEncryptedFields)((Object)lsc.bundledConnection));
        }
        for (ConnectionWithEncryptedFields connection : connectionsWithEncryptedValues) {
            connection.decryptFields(this.passwordEncryptionService);
            RWTransaction t = this.transactionService.beginWriteAsDSS();
            try {
                connection.encryptFields((PasswordEncryptionService)dockerImagePasswordEncryptionService, this.generalSettingsDAO.getUnsafe().security);
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
    }

    private void encryptAuthKeysWithNewApiNodeKey(RegularPasswordEncryptionService dockerImagePasswordEncryptionService, LambdaServiceConfig serviceConfig) {
        if (serviceConfig.authRealm != null) {
            serviceConfig.authRealm.encryptKeysIfNotEncrypted((PasswordEncryptionService)dockerImagePasswordEncryptionService);
        }
    }

    public File prepareDockerImageContext(AuthCtx authCtx, AbstractAPIDockerDeploymentInfra infra, AbstractAPIServiceDockerDeployment deployment, String targetServiceId, File tmpDir) throws Exception {
        File contextDir = new File(tmpDir, "dockerbuildcontext");
        DKUFileUtils.mkdirs((File)contextDir);
        try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Preparing packages");){
            RegularPasswordEncryptionService dockerImagePasswordEncryptionService = this.initializeAndGetDockerImagePasswordEncryptionService(contextDir);
            this.commonPrepareDockerImageContext(infra, deployment, targetServiceId, contextDir, dockerImagePasswordEncryptionService);
            this.commonPrepareServerConfigDirectory(authCtx, infra, deployment, targetServiceId, contextDir, dockerImagePasswordEncryptionService);
            deployment.prepareServerResources(infra, contextDir);
            deployment.prepareInstallIni(infra, contextDir);
        }
        return contextDir;
    }

    private void commonPrepareServerConfigDirectory(AuthCtx authCtx, AbstractAPIDockerDeploymentInfra infra, AbstractAPIServiceDockerDeployment deployment, String targetServiceId, File contextDir, RegularPasswordEncryptionService dockerImagePasswordEncryptionService) throws Exception {
        File serverConfig = new File(contextDir, "server-config");
        LambdaServerConfig lsc = new LambdaServerConfig();
        lsc.codeEnvsSettings = (LambdaServerConfig.APINodeCodeEnvsSettings)JSON.deepCopy((Object)infra.codeEnvsSettings);
        lsc.remappedConnections = infra.remappedConnections.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (DSSConnection)JSON.deepCopy((Object)((DSSConnection)e.getValue())), (prev, next) -> next, HashMap::new));
        lsc.bundledConnection = (DSSConnection)JSON.deepCopy((Object)infra.bundledConnection);
        logger.infoV("%s hiding of stacks and log tails in API error replies", new Object[]{infra.enableDkuHttpRequestVariable ? "Enabling" : "Disabling"});
        lsc.hideStackTracesAndLogTails = infra.hideStackTracesAndLogTails;
        logger.infoV("%s dku_http_request_metadata variable in python code", new Object[]{infra.enableDkuHttpRequestVariable ? "Enabling" : "Disabling"});
        lsc.isRequestMetadataEnabled = infra.enableDkuHttpRequestVariable;
        this.encryptConnectionsWithNewApiNodeKey(dockerImagePasswordEncryptionService, lsc);
        AbstractAPIServiceDockerDeploymentManager manager = (AbstractAPIServiceDockerDeploymentManager)AbstractAPIServiceDockerDeploymentManager.getManagerForInfraAndDeployment(authCtx, infra, deployment, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        manager.enrichLambdaServerConfig(dockerImagePasswordEncryptionService, lsc);
        JSON.prettyToFile((Object)lsc, (File)new File(serverConfig, "server.json"));
        File serviceDir = new File(serverConfig, "services/" + targetServiceId);
        DKUFileUtils.mkdirs((File)serviceDir);
        for (AbstractAPIServiceDeployment.OverrideEndpointServerSideConfig oessc : deployment.endpointsServerSideConfigs) {
            JSON.prettyToFile((Object)oessc.config, (File)new File(serviceDir, oessc.endpointId + ".json"));
        }
        FileUtils.copyFileToDirectory((File)DKUApp.getFile((String)"config/license.json"), (File)serverConfig);
    }

    private void commonPrepareDockerImageContext(AbstractAPIDockerDeploymentInfra infra, AbstractAPIServiceDockerDeployment deployment, String targetServiceId, File contextDir, RegularPasswordEncryptionService dockerImagePasswordEncryptionService) throws IOException, CodedException {
        File prebuiltDir = new File(contextDir, "prebuilt-services");
        File serviceDir = new File(prebuiltDir, targetServiceId);
        DKUFileUtils.mkdirs((File)serviceDir);
        ServiceState ss = deployment.getDefaultServiceState();
        JSON.prettyToFile((Object)ss, (File)new File(serviceDir, "state.json"));
        File gensDir = new File(serviceDir, "gens");
        DKUFileUtils.mkdirs((File)gensDir);
        if (deployment.generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        for (GenerationsMapping.MappingEntry mappingEntry : deployment.generationsMapping.getEntries()) {
            this.syncGeneration(deployment, contextDir, gensDir, mappingEntry.generation);
            File genDir = new File(gensDir, mappingEntry.generation);
            File genConfigFile = new File(genDir, "config.json");
            LambdaServiceConfig config = (LambdaServiceConfig)JSON.parseFile((File)genConfigFile, LambdaServiceConfig.class);
            this.checkIfMandatoryConnectionsAreSet(config, infra);
            this.encryptAuthKeysWithNewApiNodeKey(dockerImagePasswordEncryptionService, config);
            JSON.prettyToFile((Object)config, (File)genConfigFile);
        }
        File codeenvsDir = new File(contextDir, "tmp/codeenvs");
        DKUFileUtils.mkdirs((File)codeenvsDir);
        StringBuilder buildCodeEnv = new StringBuilder();
        for (CodeEnvModel.EnvLang envLang : List.of(CodeEnvModel.EnvLang.PYTHON, CodeEnvModel.EnvLang.R)) {
            List endpointCodeEnvDirs = DKUFileUtils.recursiveListFiles((File)prebuiltDir, file -> file.isDirectory() && StringUtils.equals((String)(envLang.getLanguageInfo() + "-env-desc"), (String)file.getName()));
            File languageCodeenvsDir = new File(codeenvsDir, envLang.getLanguageInfo());
            DKUFileUtils.mkdirs((File)languageCodeenvsDir);
            HashSet<String> addedCodeEnvHashes = new HashSet<String>();
            HashSet<CodeEnvModel.PredefinedContainerHookType> addedHooks = new HashSet<CodeEnvModel.PredefinedContainerHookType>();
            boolean deprecatedPythonSupport = DKUApp.getProperty((String)"dku.apinode.pythoncodeenvs.supportdeprecatedpython", (boolean)false);
            for (File curEndpointCodeEnvDir : endpointCodeEnvDirs) {
                String md5 = DKUFileUtils.digestDirectoryMD5((File)curEndpointCodeEnvDir);
                if (!addedCodeEnvHashes.contains(md5)) {
                    addedCodeEnvHashes.add(md5);
                    logger.infoV("Adding to Dockerfile the commands to build the %s code environment in path %s, with hash %s.", new Object[]{envLang.getLanguageInfo(), curEndpointCodeEnvDir.getCanonicalPath(), md5});
                    DKUFileUtils.copyDirectory((File)curEndpointCodeEnvDir, (File)new File(languageCodeenvsDir, md5));
                    try {
                        CodeEnvModel.AbstractEnvDesc envDesc = switch (envLang) {
                            case CodeEnvModel.EnvLang.PYTHON -> {
                                CodeEnvModel.PythonEnvDesc pythonEnvDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)curEndpointCodeEnvDir, (String[])new String[]{"desc.json"}), CodeEnvModel.PythonEnvDesc.class);
                                pythonEnvDesc.containerCacheBustingLocation = null;
                                if (deprecatedPythonSupport && pythonEnvDesc.pythonInterpreter.isInRange(StandardPythonInterpreter.PYTHON36, StandardPythonInterpreter.PYTHON39) && pythonEnvDesc.predefinedContainerHooks.stream().noneMatch(hook -> hook.type.name().equals(pythonEnvDesc.pythonInterpreter.name() + "_SUPPORT")) && !addedHooks.contains((Object)CodeEnvModel.PredefinedContainerHookType.valueOf(pythonEnvDesc.pythonInterpreter.name() + "_SUPPORT"))) {
                                    CodeEnvModel.PredefinedContainerHook hook = new CodeEnvModel.PredefinedContainerHook();
                                    hook.type = CodeEnvModel.PredefinedContainerHookType.valueOf(pythonEnvDesc.pythonInterpreter.name() + "_SUPPORT");
                                    pythonEnvDesc.predefinedContainerHooks.add(hook);
                                    addedHooks.add(hook.type);
                                }
                                yield pythonEnvDesc;
                            }
                            case CodeEnvModel.EnvLang.R -> (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)curEndpointCodeEnvDir, (String[])new String[]{"desc.json"}), CodeEnvModel.REnvDesc.class);
                            default -> throw new NotImplementedException(String.format("%s not supported", new Object[]{envLang}));
                        };
                        CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> envSpecData = this.automationNodeCodeEnvsService.getEnvSpecData(curEndpointCodeEnvDir, envDesc, envLang);
                        String envDir = "global-code-envs/" + md5;
                        LambdaServerConfig.APINodeCodeEnvsSettings envSettings = infra.codeEnvsSettings.preventOverrideFromImportedEnvs ? infra.codeEnvsSettings : this.codeEnvSettingsProvider.getCodeEnvSettings(envDesc);
                        APIDeployerDockerFilePreparer preparer = new APIDeployerDockerFilePreparer(envDesc, envSettings, envSpecData, md5, null, envDir);
                        buildCodeEnv.append(preparer.prepareDockerFileFragment(contextDir));
                        buildCodeEnv.append("\n\n");
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not parse code environment desc. Required commands may have not been added to Dockerfile.", (Throwable)e);
                    }
                    continue;
                }
                logger.debugV("Skipping the %s code environment in path %s, with hash %s, as the commands to build it have already been added to Dockerfile.", new Object[]{envLang.getLanguageInfo(), curEndpointCodeEnvDir.getAbsolutePath(), md5});
            }
        }
        File dockedCodeEnvBuildHook = new File(contextDir, CODE_ENVS_BUILD);
        DKUFileUtils.writeFileUTF8((File)dockedCodeEnvBuildHook, (String)buildCodeEnv.toString());
        File datadirlibjdbc = DKUApp.getFile((String[])new String[]{"lib", "jdbc"});
        File target = new File(contextDir, "lib-jdbc");
        if (datadirlibjdbc.isDirectory()) {
            DKUFileUtils.copyDirectory((File)datadirlibjdbc, (File)target);
        } else {
            FileUtils.forceMkdir((File)target);
        }
        deployment.additionalInitForDeploymentType(contextDir);
        deployment.additionalFinalizeForDeploymentType(contextDir, infra);
    }

    private void checkIfMandatoryConnectionsAreSet(LambdaServiceConfig config, AbstractAPIDockerDeploymentInfra infra) throws CodedException {
        for (LambdaEndpointConfig endpoint : config.endpoints) {
            if (!(endpoint instanceof EndpointWithConnections)) continue;
            for (String connection : ((EndpointWithConnections)((Object)endpoint)).getConnections()) {
                if (infra.remappedConnections.containsKey(connection)) continue;
                throw new CodedException((InfoMessage.MessageCode)APIServiceCodes.ERR_INFRASTRUCTURE_INVALID_CONFIG, "Connection '" + connection + "' is missing from the infrastructure settings but required by endpoint " + endpoint.id);
            }
        }
        for (DatasetResource datasetResource : config.datasetResources) {
            switch (datasetResource.packagingType) {
                case BUNDLED_INTERNAL: {
                    throw new Error("Not implemented yet");
                }
                case BUNDLED_TOCONNECTION: {
                    if (infra.bundledConnection != null) break;
                    throw new CodedException((InfoMessage.MessageCode)APIServiceCodes.ERR_INFRASTRUCTURE_INVALID_CONFIG, "The bundled connection is not referenced in the infrastructure settings");
                }
                case REFERENCED: {
                    String conn = datasetResource.dssDataset.getParams().getConnection();
                    if (infra.remappedConnections.containsKey(conn)) break;
                    throw new CodedException((InfoMessage.MessageCode)APIServiceCodes.ERR_INFRASTRUCTURE_INVALID_CONFIG, "The connection '" + conn + "' is not referenced in the infrastructure settings");
                }
            }
        }
    }

    public void buildDockerImage(AbstractAPIDockerDeploymentInfra infra, ImageNameTags imageNameTags, DKUtils.SmartLogTailBuilder logTailBuilder, boolean rebuildCodeEnv, File contextDir, Map<String, String> additionalEnv) throws IOException, InterruptedException {
        try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Building docker images for code environments and API service");){
            List<String> command = Stream.of(DKUApp.getResourceFile((String[])new String[]{"api-deployer", "kubernetes", "image", "build-code-envs-package.sh"}).getAbsolutePath(), contextDir.getAbsolutePath(), imageNameTags.codeEnvImageName, imageNameTags.imageName, imageNameTags.imageVersion, imageNameTags.fullyQualifiedBaseImageName).collect(Collectors.toList());
            if (rebuildCodeEnv || !infra.buildIntermediateImageWithCodeEnvs) {
                command.add("yes");
            } else {
                command.add("no");
            }
            if (DKUApp.isDataikuCloud()) {
                command.add("yes");
                if (StringUtils.isBlank((String)infra.getRegistryHost())) {
                    throw ErrorContext.ice((String)"Registry host is not defined in the infrastructure settings");
                }
                command.add(infra.getRegistryHost());
            } else {
                command.add("no");
            }
            String uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
            additionalEnv.put("DKU_UID", uid);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.environment().putAll(additionalEnv);
            DKUtils.execAndLogUnfilteredThrows((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder);
        }
        File dockerfile = DKUFileUtils.getWithin((File)contextDir, (String[])new String[]{"Dockerfile"});
        try {
            if (dockerfile.exists()) {
                logger.infoV("Dockerfile used to build image:\n--- Beginning of Dockerfile ---\n%s\n--- End of Dockerfile ---\n", new Object[]{DKUFileUtils.readFileToStringUTF8((File)dockerfile)});
            } else {
                logger.infoV("No Dockerfile found in context dir %s", new Object[]{contextDir.getAbsolutePath()});
            }
        }
        catch (Exception e) {
            logger.warnV("Error when accessing %s", new Object[]{dockerfile.getAbsolutePath()});
        }
    }

    public String tagAndPushImage(AuthCtx authCtx, AbstractAPIDockerDeploymentInfra infra, DKUtils.SmartLogTailBuilder logTailBuilder, ImageNameTags imageNameTags, ProxySettings proxySettings, Map<String, String> additionalEnv) throws IOException, InterruptedException, DKUSecurityException {
        String finalImageTag = null;
        try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Pushing Docker image");){
            String completeImageTag = String.format("%s:%s", imageNameTags.imageName, imageNameTags.imageVersion);
            if (StringUtils.isNotBlank((String)infra.getRegistryHost())) {
                String hostPlusCompleteImageTag = infra.getImageAliasInRegistryHost(imageNameTags.imageName, imageNameTags.imageVersion);
                logger.debugV("Tagging source docker image %s as %s", new Object[]{completeImageTag, hostPlusCompleteImageTag});
                ProcessBuilder pbTag = new ProcessBuilder("docker", "tag", completeImageTag, hostPlusCompleteImageTag);
                DKUtils.execAndLogUnfilteredThrows((ProcessBuilder)pbTag, (DKUtils.SmartLogTailBuilder)logTailBuilder);
                this.executePrePushScript(authCtx, infra, imageNameTags, proxySettings, additionalEnv, logTailBuilder);
                logger.debugV("Pushing Docker image to %s", new Object[]{hostPlusCompleteImageTag});
                ProcessBuilder pbPush = new ProcessBuilder("docker", "push", hostPlusCompleteImageTag);
                pbPush.environment().putAll(additionalEnv);
                DKUtils.execAndLogUnfilteredThrows((ProcessBuilder)pbPush, (DKUtils.SmartLogTailBuilder)logTailBuilder);
                finalImageTag = infra.getImageAliasInPullRegistryHost(imageNameTags.imageName, imageNameTags.imageVersion);
            } else {
                logTailBuilder.appendLine("No push to registry as 'Registry host' is not defined in the infrastructure settings.");
                finalImageTag = completeImageTag;
            }
        }
        return finalImageTag;
    }

    protected void executePrePushScript(AuthCtx authCtx, AbstractAPIDockerDeploymentInfra infra, ImageNameTags imageNameTags, @Nonnull ProxySettings proxySettings, @Nonnull Map<String, String> additionalEnv, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException, DKUSecurityException {
        String onCloud;
        String proxySettingsJson = JSON.json((Object)proxySettings);
        String registryHost = infra.getRegistryHost();
        String string = onCloud = DKUApp.isDataikuCloud() ? "On Dataiku Cloud: " : "";
        if (DKUApp.isDataikuCloud()) {
            logger.debugV("On Dataiku Cloud: Logging in Cloud's registry to interact with base image %s", new Object[]{imageNameTags.fullyQualifiedBaseImageName});
            logTailBuilder.appendLine("ECR login script for Dataiku Cloud");
            ProcessBuilder pbLS = new ProcessBuilder(DKUApp.getInstallFile((String[])new String[]{"resources", "api-deployer", "kubernetes", "dataiku-cloud-base-image-login.sh"}).getAbsolutePath(), imageNameTags.fullyQualifiedBaseImageName);
            HashMap<String, String> envLoginVariables = new HashMap<String, String>();
            if (proxySettings.hasProxy()) {
                logger.infoV("Setting HTTP_PROXY and HTTPS_PROXY according to global proxy settings", new Object[0]);
                String proxy = proxySettings.getAsString();
                envLoginVariables.put("HTTP_PROXY", proxy);
                envLoginVariables.put("HTTPS_PROXY", proxy);
            }
            pbLS.environment().putAll(envLoginVariables);
            logTailBuilder.appendLine("$ " + StringUtils.join(pbLS.command(), (char)' '));
            DKUtils.execAndLogUnfilteredThrows((ProcessBuilder)pbLS, (DKUtils.SmartLogTailBuilder)logTailBuilder);
        }
        switch (infra.prePushMode) {
            case NONE: {
                logger.debugV("No pre-push action performed.", new Object[0]);
                break;
            }
            case ECR: {
                logger.debugV(onCloud + "Executing pre-push script to login Docker and create the ECR repository in %s.", new Object[]{registryHost});
                String region = ECRUtils.getRegionFromRepositoryURL(registryHost);
                logTailBuilder.appendLine(onCloud + "ECR Pre-push script. Detected region: " + region);
                ProcessBuilder pbPPS = DKUApp.isDataikuCloud() ? new ProcessBuilder(DKUApp.getInstallFile((String[])new String[]{"resources", "api-deployer", "kubernetes", "dataiku-cloud-aws-ecr-prepush.sh"}).getAbsolutePath(), registryHost, region, imageNameTags.imageName, imageNameTags.codeEnvImageName) : new ProcessBuilder(DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "aws-ecr-prepush.sh"}).getAbsolutePath(), registryHost, region, imageNameTags.imageName, imageNameTags.imageVersion);
                HashMap<String, String> envVariables = new HashMap<String, String>(additionalEnv);
                if (proxySettings.hasProxy()) {
                    logger.infoV("Setting HTTP_PROXY and HTTPS_PROXY according to global proxy settings", new Object[0]);
                    String proxy = proxySettings.getAsString();
                    envVariables.put("HTTP_PROXY", proxy);
                    envVariables.put("HTTPS_PROXY", proxy);
                }
                pbPPS.environment().putAll(envVariables);
                logTailBuilder.appendLine("$ " + StringUtils.join(pbPPS.command(), (char)' '));
                DKUtils.execAndLogUnfilteredThrows((ProcessBuilder)pbPPS, (DKUtils.SmartLogTailBuilder)logTailBuilder);
                break;
            }
            case ACR: {
                logger.debugV(onCloud + "Executing pre-push script to login Azure.", new Object[0]);
                logTailBuilder.appendLine(onCloud + "ACR Pre-push script");
                ProcessBuilder pbPPS = DKUApp.isDataikuCloud() ? new ProcessBuilder(DKUApp.getInstallFile((String[])new String[]{"resources", "api-deployer", "kubernetes", "dataiku-cloud-azure-acr-prepush.sh"}).getAbsolutePath(), registryHost, imageNameTags.imageName, imageNameTags.imageVersion) : new ProcessBuilder(DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "azure-acr-prepush.sh"}).getAbsolutePath(), registryHost, imageNameTags.imageName, imageNameTags.imageVersion);
                pbPPS.environment().putAll(additionalEnv);
                logTailBuilder.appendLine("$ " + StringUtils.join(pbPPS.command(), (char)' '));
                DKUtils.execAndLogUnfilteredThrows((ProcessBuilder)pbPPS, (DKUtils.SmartLogTailBuilder)logTailBuilder);
                break;
            }
            case GCR: {
                logger.debugV(onCloud + "Executing pre-push script to login to Google Artifact Registry.", new Object[0]);
                logTailBuilder.appendLine(onCloud + "GAR Pre-push script");
                ProcessBuilder pbPPS = new ProcessBuilder(DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "gcloud-gcr-prepush.sh"}).getAbsolutePath(), registryHost, proxySettingsJson);
                pbPPS.environment().putAll(additionalEnv);
                logTailBuilder.appendLine("$ " + StringUtils.join(pbPPS.command(), (char)' '));
                DKUtils.execAndLogUnfilteredThrows((ProcessBuilder)pbPPS, (DKUtils.SmartLogTailBuilder)logTailBuilder);
                break;
            }
            case SCS: {
                logger.debugV(onCloud + "Executing pre-push script to login to Snowflake Registry.", new Object[0]);
                logTailBuilder.appendLine(onCloud + "SCS Pre-push script");
                if (!(infra instanceof SnowparkAPIDeploymentInfra)) {
                    throw ErrorContext.ice((String)"You need a Snowpark infra to execute SCS pre-push script");
                }
                SnowparkAPIDeploymentInfra snowparkInfra = (SnowparkAPIDeploymentInfra)infra;
                SnowflakeConnection connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, snowparkInfra.authConnection);
                if (connection == null) {
                    throw ErrorContext.ice((String)"No connection defined in the infrastructure.");
                }
                JsonObject registryToken = SnowparkUtils.getSnowflakeToken_NT(authCtx, connection);
                ArrayList command = DKUApp.isDataikuCloud() ? Lists.newArrayList((Object[])new String[]{"crane", "auth", "login", registryHost, "-u", "0sessiontoken", "--password-stdin"}) : Lists.newArrayList((Object[])new String[]{"docker", "login", registryHost, "-u", "0sessiontoken", "--password-stdin"});
                logTailBuilder.appendLine("$ " + StringUtils.join((Collection)command, (char)' '));
                DKUtils.execAndLogUnfilteredThrows((String[])command.toArray(new String[0]), additionalEnv, (String)registryToken.toString(), (DKUtils.SmartLogTailBuilder)logTailBuilder);
                break;
            }
            case CUSTOM: {
                ProcessBuilder pbPPS;
                if (StringUtils.isNotBlank((String)infra.getPrePushScript())) {
                    logger.debugV(onCloud + "Executing custom pre-push script for registryHost='%s', imageName='%s' and tag='%s'", new Object[]{registryHost, imageNameTags.imageName, imageNameTags.imageVersion});
                    logTailBuilder.appendLine(onCloud + "Pre-push script");
                    pbPPS = new ProcessBuilder(infra.getPrePushScript(), registryHost, imageNameTags.imageName, imageNameTags.imageVersion);
                    pbPPS.environment().putAll(additionalEnv);
                    logTailBuilder.appendLine("$ " + StringUtils.join(pbPPS.command(), (char)' '));
                    DKUtils.execAndLogUnfilteredThrows((ProcessBuilder)pbPPS, (DKUtils.SmartLogTailBuilder)logTailBuilder);
                    break;
                }
                logger.debugV("No custom pre-push action performed since pre-push script is not defined.", new Object[0]);
            }
        }
    }

    protected Map<String, String> getCraneAuthToken(String registryHost, Map<String, String> additionalEnv) {
        HashMap<String, String> buildAdditionalEnv = new HashMap<String, String>();
        String registryRoot = registryHost.split("/")[0];
        try {
            ProcessBuilder pbPPS = new ProcessBuilder("crane", "auth", "get", registryRoot);
            pbPPS.environment().putAll(additionalEnv);
            String kanikoAuth = new String(DKUtils.execAndGetOutputWithErrorInException((ProcessBuilder)pbPPS, (String)"Can't get auth from crane"), StandardCharsets.UTF_8);
            Map usernameAndSecret = JSON.parseToMap((String)kanikoAuth);
            buildAdditionalEnv.put("DKU_CLOUD_KANIKO_REGISTRY", registryRoot);
            buildAdditionalEnv.put("DKU_CLOUD_KANIKO_USERNAME", (String)usernameAndSecret.get("Username"));
            buildAdditionalEnv.put("DKU_CLOUD_KANIKO_PASSWORD", (String)usernameAndSecret.get("Secret"));
        }
        catch (Exception e) {
            logger.error((Object)"Can't get auth token from crane. Kaniko won't be able to push.", (Throwable)e);
        }
        return buildAdditionalEnv;
    }

    public class APIDeployerDockerFilePreparer
    extends BaseDockerFilePreparer {
        public APIDeployerDockerFilePreparer(CodeEnvModel.AbstractEnvDesc envDesc, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings, CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData, String envName, String envVersion, String envDir) {
            super(envDesc, envSettings, specData, envName, envVersion, envDir);
        }

        @Override
        public BaseDockerFilePreparer.VirtualEnvParams getVirtualEnvParams() {
            return new BaseDockerFilePreparer.VirtualEnvParams(this, "/opt/dataiku/installdir/scripts/_create-virtualenv.sh", "/home/dataiku/data/bin/python");
        }

        @Override
        protected String getPythonBasePackageDir() {
            return "/opt/dataiku/installdir/python";
        }

        @Override
        protected boolean shouldRunInitScriptWhenBuildingImage(CodeEnvModel.PythonEnvDesc envDesc) {
            return !envDesc.updateResourcesApiNode;
        }

        @Override
        protected String getRScriptRootDir() {
            return "/opt/dataiku/installdir/resources/code-envs/r";
        }
    }

    public static class ImageNameTags {
        public final String imageName;
        public final String imageVersion;
        public final String deploymentVersion;
        public final String fullyQualifiedBaseImageName;
        public final String codeEnvImageName;

        public ImageNameTags(AbstractAPIDockerDeploymentInfra infra, AbstractAPIServiceDockerDeployment deployment, VariablesContext vc) {
            AbstractAPIServiceDockerDeploymentConfigManager configManager = AbstractAPIServiceDockerDeploymentConfigManager.getConfigManager(infra, deployment, vc);
            this.imageName = configManager.getImageName();
            this.deploymentVersion = this.imageVersion = configManager.generateImageVersion();
            this.fullyQualifiedBaseImageName = this.resolveFullyQualifiedBaseImageName(infra);
            this.codeEnvImageName = configManager.getCodeEnvImageName();
        }

        private String resolveFullyQualifiedBaseImageName(AbstractAPIDockerDeploymentInfra infra) {
            if (!DKUApp.isDataikuCloud()) {
                return StringUtils.defaultIfBlank((String)infra.baseImageTag, (String)("dku-apideployer-apinode-base:dss-" + APIServiceDeploymentHelper.getSanitizedDSSVersionForImages()));
            }
            if (AbstractDeploymentInfra.InfraType.K8S != infra.getInfraType()) {
                return ApplicationConfigurator.getParams().getNonEmptyMandParam("dku.cloud.fullyQualifiedBaseApiNodeImageName");
            }
            String registryHost = infra.getRegistryHost();
            String baseImageTag = infra.baseImageTag;
            if (StringUtils.isBlank((String)registryHost)) {
                throw ErrorContext.isef((String)"Registry host is not specified for infra '%s'", (Object)infra.id, (Object[])new Object[0]);
            }
            if (StringUtils.isBlank((String)baseImageTag)) {
                throw ErrorContext.isef((String)"Base image tag is not specified for infra '%s'", (Object)infra.id, (Object[])new Object[0]);
            }
            return String.format("%s/%s", registryHost, baseImageTag);
        }
    }
}

