/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.infra;

import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.InfraLightStatus;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.apideployer.deployments.AbstractDeploymentsService;
import com.dataiku.dip.apideployer.engine.DeploymentHooksService;
import com.dataiku.dip.apideployer.infra.DeploymentInfrasDAO;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractInfrasService<D extends AbstractDeployment, I extends AbstractPublishedItemBasicInfo, N extends AbstractDeploymentInfra> {
    @Autowired
    private DeploymentHooksService deploymentHooksService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    protected GeneralSettingsDAO generalSettingsDAO;

    protected abstract AbstractDeploymentsService<D, I, N> getDeploymentsService();

    protected abstract DeploymentInfrasDAO<N> getDeploymentInfrasDAO();

    protected abstract void publishInfraCreationEventAfterTransaction(String var1);

    protected abstract void publishInfraChangedEventAfterTransaction(String var1);

    protected abstract void publishInfraDeletedEventAfterTransaction(String var1, AbstractDeploymentInfra.InfraType var2);

    public abstract InfoMessage.InfoMessages checkInfraStatus_Check_NT(AuthCtx var1, String var2) throws IOException, DKUSecurityException, InterruptedException;

    private List<N> listAll_Uncheck() throws IOException {
        return this.getDeploymentInfrasDAO().list();
    }

    private void save_Uncheck(N deploymentInfra) throws IOException {
        this.encryptAndSave(deploymentInfra);
    }

    public List<InfraLightStatus> listLightStatusUnsafe_Check(AuthCtx authCtx) throws IOException {
        ArrayList<InfraLightStatus> ret = new ArrayList<InfraLightStatus>();
        for (AbstractDeploymentInfra infra : this.getDeploymentInfrasDAO().listUnsafe()) {
            InfraLightStatus lightStatus = this.getLightStatusUnsafeOrNull(infra.id, authCtx);
            if (lightStatus == null) continue;
            ret.add(lightStatus);
        }
        return ret;
    }

    public abstract List<? extends AbstractInfraBasicInfo> listBasicInfoUnsafe_Check(AuthCtx var1) throws IOException;

    private InfraLightStatus getLightStatusUnsafeOrNull(String infraId, AuthCtx authCtx) throws IOException {
        N infra = this.getSettingsMandatoryUnsafe(infraId);
        if (!AbstractInfrasService.hasReadPermission(infra, authCtx)) {
            return null;
        }
        InfraLightStatus lightStatus = new InfraLightStatus();
        lightStatus.infraBasicInfo = this.basicInfoUnsafe(infra);
        lightStatus.deployments = this.getDeploymentsService().listBasicInfoForInfraUnsafe_Check(((AbstractDeploymentInfra)infra).id, authCtx);
        lightStatus.isAdmin = AbstractInfrasService.hasAdminPermission(infra, authCtx);
        lightStatus.canDeploy = AbstractInfrasService.hasDeployPermission(infra, authCtx);
        if (infra instanceof MultiAutomationNodeInfra) {
            lightStatus.canDeploy &= this.generalSettingsDAO.getUnsafe().projectDeployerServerSettings.allowMultiNodeInfrastructures;
        }
        return lightStatus;
    }

    public InfraLightStatus getLightStatusUnsafe_Check(String infraId, AuthCtx authCtx) throws IOException, UnauthorizedException {
        InfraLightStatus lightStatus = this.getLightStatusUnsafeOrNull(infraId, authCtx);
        if (lightStatus == null) {
            throw new UnauthorizedException("You may not read this infrastructure", this.getExceptionTypePrefix() + "infrastructure-action-denied");
        }
        return lightStatus;
    }

    public N getSettingsMandatoryUnsafe_CheckAdmin(String infraId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        N infra = this.getSettingsMandatoryUnsafe(infraId);
        this.checkAdminPermission((AbstractDeploymentInfra)infra, authCtx);
        return infra;
    }

    public N getSettingsMandatoryUnsafe_CheckAdminAndHooks(String infraId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        Object infra = this.getSettingsMandatoryUnsafe_CheckAdmin(infraId, authCtx);
        if (!authCtx.isSafeCodeAllowed()) {
            infra = (AbstractDeploymentInfra)JSON.deepCopy(infra);
            ((AbstractDeploymentInfra)infra).deploymentHookSettings = null;
        }
        return infra;
    }

    public N getSettingsMandatoryUnsafe(String infraId) throws IOException {
        return (N)((AbstractDeploymentInfra)this.getDeploymentInfrasDAO().getMandatoryUnsafe(infraId));
    }

    public void create_Check(N newInfra, AuthCtx authCtx) throws UnauthorizedException, IOException {
        if (!authCtx.isAdmin()) {
            throw new UnauthorizedException("Action forbidden, you are not admin", "not-admin");
        }
        if (newInfra instanceof MultiAutomationNodeInfra) {
            this.checkMultiAutomationNodeInfrastructuresAllowed();
        }
        this.checkNewIdValidity(((AbstractDeploymentInfra)newInfra).id);
        this.publishInfraCreationEventAfterTransaction(((AbstractDeploymentInfra)newInfra).id);
        AbstractDeploymentInfra encryptedCopy = (AbstractDeploymentInfra)JSON.deepCopy(newInfra);
        this.encryptAndSave(encryptedCopy);
    }

    public void checkMultiAutomationNodeInfrastructuresAllowed() throws IOException {
        GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsDAO.getUnsafe();
        if (!gs.projectDeployerServerSettings.allowMultiNodeInfrastructures) {
            throw ErrorContext.iae((String)"Multi automation node infrastructures are not allowed.");
        }
    }

    public void save_Check(N deploymentInfra, AuthCtx authCtx, boolean shouldVerify) throws DKUSecurityException, IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        N currentInfra = this.getSettingsMandatoryUnsafe_CheckAdmin(((AbstractDeploymentInfra)deploymentInfra).id, authCtx);
        if (!authCtx.isSafeCodeAllowed()) {
            if (!this.deploymentHooksService.hookSettingAreEmpty((AbstractDeploymentInfra)deploymentInfra)) {
                throw new UnauthorizedException("You may not modify deployment hook settings", this.getExceptionTypePrefix() + "infrastructure-action-denied");
            }
            ((AbstractDeploymentInfra)deploymentInfra).deploymentHookSettings = ((AbstractDeploymentInfra)currentInfra).deploymentHookSettings;
        }
        ((AbstractDeploymentInfra)deploymentInfra).verifyHookChangePermission(authCtx, (AbstractDeploymentInfra)currentInfra);
        if (shouldVerify) {
            ((AbstractDeploymentInfra)deploymentInfra).verifyFields(authCtx, (AbstractDeploymentInfra)currentInfra);
        }
        ((AbstractDeploymentInfra)deploymentInfra).creationTag = ((AbstractDeploymentInfra)currentInfra).creationTag;
        ((AbstractDeploymentInfra)deploymentInfra).versionTag = VersionTag.increment(((AbstractDeploymentInfra)deploymentInfra).versionTag, t.getUser().getIdentifier());
        this.publishInfraChangedEventAfterTransaction(((AbstractDeploymentInfra)deploymentInfra).id);
        this.encryptAndSave(deploymentInfra);
    }

    private void encryptAndSave(N infraToSave) throws IOException {
        ((AbstractDeploymentInfra)infraToSave).encryptFields(this.passwordEncryptionService);
        this.getDeploymentInfrasDAO().save(infraToSave);
    }

    public void delete(AbstractDeploymentInfra deploymentInfra) throws IOException {
        if (this.getDeploymentsService().hasDeploymentForInfra(deploymentInfra.id)) {
            throw ErrorContext.iae((String)"Cannot delete an infra that still has deployments on it");
        }
        this.publishInfraDeletedEventAfterTransaction(deploymentInfra.id, deploymentInfra.getInfraType());
        this.getDeploymentInfrasDAO().delete(deploymentInfra.id);
    }

    public static boolean hasDeployPermission(AbstractDeploymentInfra infra, AuthCtx authCtx) {
        if (authCtx.isAdmin()) {
            return true;
        }
        for (AbstractDeploymentInfra.PermissionItem pi : infra.permissions) {
            if (!pi.deploy && !pi.admin || !authCtx.getGroupsIfRelevant().contains(pi.group)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadPermission(AbstractDeploymentInfra infra, AuthCtx authCtx) {
        if (authCtx.isAdmin()) {
            return true;
        }
        for (AbstractDeploymentInfra.PermissionItem pi : infra.permissions) {
            if (!pi.read && !pi.deploy && !pi.admin || !authCtx.getGroupsIfRelevant().contains(pi.group)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAdminPermission(AbstractDeploymentInfra infra, AuthCtx authCtx) {
        if (authCtx.isAdmin()) {
            return true;
        }
        for (AbstractDeploymentInfra.PermissionItem pi : infra.permissions) {
            if (!pi.admin || !authCtx.getGroupsIfRelevant().contains(pi.group)) continue;
            return true;
        }
        return false;
    }

    private void checkAdminPermission(AbstractDeploymentInfra infra, AuthCtx authCtx) throws UnauthorizedException {
        if (!AbstractInfrasService.hasAdminPermission(infra, authCtx)) {
            throw new UnauthorizedException("Permission denied: unable to manage a deployment infrastructure", this.getExceptionTypePrefix() + "infrastructure-action-denied");
        }
    }

    public abstract AbstractInfraBasicInfo basicInfoUnsafe(N var1);

    public void removeGroupFromPermissions_Uncheck(String groupName) throws IOException {
        for (AbstractDeploymentInfra di : this.listAll_Uncheck()) {
            boolean changed = false;
            ListIterator<AbstractDeploymentInfra.PermissionItem> it = di.permissions.listIterator();
            while (it.hasNext()) {
                AbstractDeploymentInfra.PermissionItem pi = it.next();
                if (!pi.group.equals(groupName)) continue;
                it.remove();
                changed = true;
            }
            if (!changed) continue;
            this.getLogger().info((Object)("Changed permissions of deployment infra " + di.id));
            this.save_Uncheck(di);
        }
    }

    protected abstract String getExceptionTypePrefix();

    private void checkNewIdValidity(String id) throws IOException {
        if (StringUtils.isBlank((String)id)) {
            throw ErrorContext.iae((String)"Deployment infra id cannot be empty");
        }
        if (!id.matches("^[A-Za-z0-9_ -]+$")) {
            throw ErrorContext.iaef((String)"Deployment infra id is invalid: %s", (Object)id, (Object[])new Object[0]);
        }
        if (this.getDeploymentInfrasDAO().getOrNullUnsafe(id) != null) {
            throw ErrorContext.iaef((String)"Duplicate deployment infra id: %s", (Object)id, (Object[])new Object[0]);
        }
    }

    protected abstract DKULogger getLogger();
}

