/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.infra;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.apideployer.monitoring.DatabricksActivityMetricsFetchingService;
import com.dataiku.dip.connections.ConnectionWithDatabricksCredentials;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DatabricksInfraManager
implements ApiNodeInfraManager {
    private final DatabricksAPIDeploymentInfra infra;
    @Autowired
    private DatabricksActivityMetricsFetchingService activityMetricsFetchingService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.infra.databricks.manager");

    public DatabricksInfraManager(DatabricksAPIDeploymentInfra infra) {
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_NT(AuthCtx authCtx) {
        try {
            return this.getStatusMessages(authCtx);
        }
        catch (Exception e) {
            InfoMessage.MessageCode code = null;
            if (e instanceof ICodedException) {
                code = ((ICodedException)e).getCode();
            }
            if (code == null) {
                code = DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_ERROR;
            }
            String errorMessage = "Databricks request failed with error: " + String.valueOf(e);
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            messages.withFatal(code, errorMessage);
            logger.error((Object)errorMessage);
            return messages;
        }
    }

    @Nonnull
    private InfoMessage.InfoMessages getStatusMessages(AuthCtx authCtx) throws DKUSecurityException, IOException, URISyntaxException {
        DatabricksModelDeploymentConnection connection = (DatabricksModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, this.infra.authConnection);
        if (connection == null) {
            return new InfoMessage.InfoMessages().withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_MISSING_CONNECTION, String.format("it is not defined in the '%s' infrastructure's configuration.", this.infra.id));
        }
        DatabricksModelDeploymentConnection.Params connectionParams = connection.params;
        InfoMessage.InfoMessages connectionConfigMessages = this.getConnectionConfigInfoMessages(connection.name, connectionParams);
        if (connectionConfigMessages != null) {
            return connectionConfigMessages;
        }
        InfoMessage.InfoMessages infraConfigMessages = this.getInfraConfigInfoMessages();
        if (infraConfigMessages != null) {
            return infraConfigMessages;
        }
        DatabricksUtils.listEndpoints(authCtx, connection.name, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return new InfoMessage.InfoMessages();
    }

    @Nullable
    private InfoMessage.InfoMessages getInfraConfigInfoMessages() {
        if (StringUtils.isBlank((String)this.infra.defaultExperimentLocation)) {
            return new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_MISSING_EXPERIMENT_LOCATION, "it is not defined in the '%s' infrastructure's configuration.", new Object[]{this.infra.id});
        }
        if (this.infra.usesUnityCatalog) {
            if (StringUtils.isBlank((String)this.infra.defaultCatalogName)) {
                return new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_MISSING_CATALOG_NAME, "it is not defined in the '%s' infrastructure's configuration.", new Object[]{this.infra.id});
            }
            if (StringUtils.isBlank((String)this.infra.defaultSchemaName)) {
                return new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_MISSING_SCHEMA_NAME, "it is not defined in the '%s' infrastructure's configuration.", new Object[]{this.infra.id});
            }
        }
        return null;
    }

    @Nullable
    private InfoMessage.InfoMessages getConnectionConfigInfoMessages(String connectionName, DatabricksModelDeploymentConnection.Params connectionParams) {
        if (StringUtils.isBlank((String)connectionParams.host)) {
            return new InfoMessage.InfoMessages().withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_INVALID_CONNECTION, String.format("host is not defined in the '%s' connection.", connectionName));
        }
        if (connectionParams.authType == ConnectionWithDatabricksCredentials.AuthType.PERSONAL_ACCESS_TOKEN) {
            if (StringUtils.isBlank((String)connectionParams.personalAccessToken)) {
                return new InfoMessage.InfoMessages().withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_INVALID_CONNECTION, String.format("personal access token is not defined in the '%s' connection.", connectionName));
            }
        } else if (connectionParams.authType == ConnectionWithDatabricksCredentials.AuthType.OAUTH2_APP) {
            if (StringUtils.isBlank((String)connectionParams.oauth2ClientId)) {
                return new InfoMessage.InfoMessages().withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_INVALID_CONNECTION, String.format("Databricks OAuth on Azure client id is not defined in the '%s' connection.", connectionName));
            }
            if (StringUtils.isBlank((String)connectionParams.oauth2ClientSecret)) {
                return new InfoMessage.InfoMessages().withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_INVALID_CONNECTION, String.format("Databricks OAuth on Azure client secret is not defined in the '%s' connection.", connectionName));
            }
        }
        return null;
    }

    @Override
    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getActivityMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) throws Exception {
        return this.activityMetricsFetchingService.getInfraActivityMetrics_NT(authCtx, this.infra, overridingConnectionName, connectTimeout, socketTimeout);
    }
}

